/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.IGuiGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class GuiGroup
extends GuiSized
implements IGuiGroup {
    protected final List<GuiControl> controls = new ArrayList<GuiControl>();

    public GuiGroup() {
        super(0, 0, 0, 0);
    }

    public GuiGroup(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    @Override
    public int translateToScreenX(int x) {
        return this.parent.translateToScreenX(x + this.x);
    }

    @Override
    public int translateToScreenY(int y) {
        return this.parent.translateToScreenY(y + this.y);
    }

    @Override
    public int translateFromScreenX(int x) {
        return this.parent.translateFromScreenX(x) - this.x;
    }

    @Override
    public int translateFromScreenY(int y) {
        return this.parent.translateFromScreenX(y) - this.y;
    }

    @Override
    public void sort() {
        this.controls.sort(Comparator.comparingInt(a -> a.zIndex));
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        for (GuiControl control : this.controls) {
            if (!control.isVisible()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)control.getX(), (float)control.getY(), (float)0.0f);
            control.preDraw();
            control.draw();
            control.postDraw();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void update() {
        for (GuiControl control : this.controls) {
            control.update();
        }
    }

    @Override
    public boolean notifyTakeFocus(GuiControl taker) {
        if (this.parent != null && !this.parent.notifyTakeFocus(this)) {
            return false;
        }
        for (GuiControl control : this.controls) {
            if (control == taker || !control.hasFocus()) continue;
            control.setFocused(false);
        }
        return true;
    }

    @Override
    public GuiControl hitTest(int x, int y) {
        for (int i = this.controls.size() - 1; i >= 0; --i) {
            GuiControl res;
            GuiControl control = this.controls.get(i);
            if (!control.isVisible() || (res = control.hitTest(x - control.getX(), y - control.getY())) == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public void addControl(GuiControl control) {
        this.controls.add(control);
        control.setParent(this);
        this.sort();
    }

    @Override
    public void removeControl(GuiControl control) {
        this.controls.remove((Object)control);
    }

    @Override
    public void clearControls() {
        this.controls.clear();
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.parent.getFontRenderer();
    }

    @Override
    public boolean hasFocus() {
        for (GuiControl control : this.controls) {
            if (!control.hasFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHaveFocus() {
        return this.controls.stream().anyMatch(GuiControl::canHaveFocus);
    }

    @Override
    public void setFocused(boolean focused) {
        if (!focused) {
            for (GuiControl control : this.controls) {
                if (!control.hasFocus()) continue;
                control.setFocused(false);
                break;
            }
        } else {
            for (GuiControl control : this.controls) {
                if (!control.isEnabled() || !control.canHaveFocus()) continue;
                control.setFocused(true);
                break;
            }
        }
    }

    @Override
    public void onKeyTyped(char typedChar, int keyCode) {
        for (GuiControl control : this.controls) {
            if (!control.hasFocus()) continue;
            control.onKeyTyped(typedChar, keyCode);
            break;
        }
    }
}

