/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.Mod;
import com.mike_caron.mikesmodslib.gui.GuiBase;
import com.mike_caron.mikesmodslib.gui.GuiButton;
import com.mike_caron.mikesmodslib.gui.GuiGuidePage;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import net.minecraft.util.ResourceLocation;

public class GuiGuide
extends GuiBase
implements GuiButton.ClickedListener,
GuiGuidePage.NavigationListener {
    private final String titleKey;
    private GuiButton backButton = GuiUtil.translatedButton(1, 7, 147, 55, 14, "mikesmodslib.gui.guide.back", new Object[0]);
    private GuiButton closeButton = GuiUtil.translatedButton(2, 194, 147, 55, 14, "mikesmodslib.gui.guide.close", new Object[0]);
    private GuiButton indexButton = GuiUtil.translatedButton(3, 104, 147, 55, 14, "mikesmodslib.gui.guide.index", new Object[0]);
    private final GuiGuidePage guidePage;
    private final Stack<String> pageNav = new Stack();
    private final Stack<Integer> scrolls = new Stack();
    private String currentPage;

    public GuiGuide(int width, int height, String titleKey, ResourceLocation background, ResourceLocation initialPage) {
        super(width, height, background);
        this.background = background;
        this.titleKey = titleKey;
        this.guidePage = new GuiGuidePage(7, 18, 242, 126, initialPage.func_110624_b());
        this.currentPage = initialPage.func_110623_a();
        this.initControls();
        this.loadPage();
    }

    @Override
    protected String getTitleKey() {
        return this.titleKey;
    }

    @Override
    protected void addControls() {
        super.addControls();
        this.addControl(this.backButton);
        this.addControl(this.guidePage);
        this.addControl(this.closeButton);
        this.addControl(this.indexButton);
        this.backButton.setEnabled(false);
        this.backButton.addListener(this);
        this.closeButton.addListener(this);
        this.guidePage.addListener(this);
        this.indexButton.addListener(this);
    }

    @Override
    public void clicked(GuiButton.ClickedEvent event) {
        if (event.id == 1) {
            this.currentPage = this.pageNav.pop();
            this.backButton.setEnabled(!this.pageNav.isEmpty());
            this.loadPage();
            this.guidePage.setScrollY(this.scrolls.pop());
        } else if (event.id == 2) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (event.id == 3) {
            this.navigated("/index");
        }
    }

    private void loadPage() {
        this.guidePage.loadPage(this.currentPage);
    }

    @Override
    public void navigated(String newUri) {
        this.pageNav.push(this.currentPage);
        this.scrolls.push(this.guidePage.getScrollY());
        this.currentPage = newUri;
        this.backButton.setEnabled(true);
        this.loadPage();
    }

    @Override
    public void navigatedExternal(String uri) {
        try {
            URI url = new URI(uri);
            this.func_175282_a(url);
        }
        catch (URISyntaxException ex) {
            Mod.logger.error("Unable to parse Uri", (Throwable)ex);
        }
    }
}

