/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mike_caron.mikesmodslib.gui.GuiButton;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiEmpty;
import com.mike_caron.mikesmodslib.gui.GuiGroup;
import com.mike_caron.mikesmodslib.gui.GuiHorizontalLayout;
import com.mike_caron.mikesmodslib.gui.GuiImage;
import com.mike_caron.mikesmodslib.gui.GuiImageFlipper;
import com.mike_caron.mikesmodslib.gui.GuiImageItemStack;
import com.mike_caron.mikesmodslib.gui.GuiImageTexture;
import com.mike_caron.mikesmodslib.gui.GuiLabel;
import com.mike_caron.mikesmodslib.gui.GuiMultilineLabel;
import com.mike_caron.mikesmodslib.gui.GuiScrollPort;
import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import com.mike_caron.mikesmodslib.util.DataUtils;
import com.mike_caron.mikesmodslib.util.ItemUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EventListener;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.apache.commons.io.FilenameUtils;

public class GuiGuidePage
extends GuiScrollPort
implements GuiButton.ClickedListener {
    String title;
    String currentJson = null;
    String currentUri = null;
    final String modId;
    int yPos = 0;

    public GuiGuidePage(int x, int y, int width, int height, String modId) {
        super(x, y, width, height);
        this.modId = modId;
    }

    public void loadPage(String uri) {
        this.clearControls();
        this.setEnableScrollBar(false);
        this.currentUri = uri;
        this.yPos = 4;
        this.scrollY = 0;
        ResourceLocation rl = new ResourceLocation(this.modId, this.baseFile(uri));
        try {
            JsonObject templates = this.loadResourceAsJson(new ResourceLocation(this.modId, this.baseFile("/_templates")));
            JsonObject body = this.loadResourceAsJson(rl);
            if (body == null) {
                String message = new TextComponentTranslation("mikesmodslib.gui.guide.pagenotfound", new Object[]{this.currentJson}).func_150254_d();
                GuiMultilineLabel label = new GuiMultilineLabel(2, 0, this.width - 4 - 8, message);
                this.addControl(label);
                this.yPos += label.getHeight();
            } else {
                JsonObject translation = this.loadLocalizedResourceAsJson(uri);
                if (translation != null && translation.has("title")) {
                    this.insertLabel(translation, (JsonElement)new JsonPrimitive("title"), true);
                }
                if (body.has("index")) {
                    this.addButtonsForList(body, "index", translation);
                }
                if (body.has("body")) {
                    this.addLabelsForList(body.get("body").getAsJsonArray(), translation, templates);
                }
                if (body.has("seealso")) {
                    GuiLabel seealso = GuiUtil.staticLabelFromTranslationKey(2, this.yPos, "mikesmodslib.gui.guide.seealso", new Object[0]);
                    this.yPos += 10;
                    this.addButtonsForList(body, "seealso", translation);
                }
            }
        }
        catch (Exception ex) {
            String message = "Error while parsing " + this.currentJson + "\r\n" + ex.getMessage();
            GuiMultilineLabel label = new GuiMultilineLabel(2, 0, this.width - 4 - 8, message);
            this.addControl(label);
            this.yPos += label.getHeight();
            ex.printStackTrace();
        }
        if (this.yPos > this.height) {
            this.setEnableScrollBar(true);
            this.yPos = 4;
            for (GuiControl control : this.controls) {
                if (control instanceof GuiButton || control instanceof GuiMultilineLabel) {
                    ((GuiSized)control).setWidth(this.width - 4 - this.marginRight);
                } else if (control instanceof GuiImage || control instanceof GuiLabel) {
                    control.setX((this.width - this.marginRight) / 2 - control.getWidth() / 2);
                }
                control.setY(this.yPos);
                this.yPos += control.getHeight();
                if (!control.extraData.containsKey("spacing")) continue;
                this.yPos += ((Integer)control.extraData.get("spacing")).intValue();
            }
        }
        this.setMaxScrollY(this.yPos - this.height);
    }

    private void addLabelsForList(JsonArray index, JsonObject translation, JsonObject templates) {
        for (int i = 0; i < index.size(); ++i) {
            JsonElement p = index.get(i);
            p = this.resolveTemplate(p, templates);
            this.insertLabel(translation, p, false);
        }
    }

    private JsonElement resolveTemplate(JsonElement src, JsonObject templates) {
        if (!src.isJsonObject()) {
            return src;
        }
        if (templates == null) {
            return src;
        }
        JsonObject obj = src.getAsJsonObject();
        if (!obj.has("template")) {
            return src;
        }
        String templateName = obj.get("template").getAsString();
        if (!templates.has(templateName)) {
            return src;
        }
        JsonArray elements = this.getElements(src.getAsJsonObject().get("elements"));
        JsonObject template = templates.get(templateName).getAsJsonObject();
        JsonObject ret = new JsonObject();
        for (Map.Entry entry : template.entrySet()) {
            ret.add((String)entry.getKey(), this.resolveTemplateObject(elements, (JsonElement)entry.getValue()));
        }
        for (Map.Entry entry : obj.entrySet()) {
            if (((String)entry.getKey()).equals("template") || ((String)entry.getKey()).equals("elements")) continue;
            ret.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return ret;
    }

    private JsonArray getElements(JsonElement elementsEl) {
        if (elementsEl == null || elementsEl.isJsonNull() || elementsEl.isJsonPrimitive()) {
            return new JsonArray();
        }
        if (elementsEl.isJsonArray()) {
            return elementsEl.getAsJsonArray();
        }
        JsonObject obj = elementsEl.getAsJsonObject();
        if (obj.has("recipe")) {
            String itemId = obj.get("recipe").getAsString();
            IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)new ResourceLocation(itemId));
            JsonArray ret = new JsonArray();
            int numIng = 0;
            JsonObject air = new JsonObject();
            air.addProperty("item", "minecraft:air");
            int recipe_width = 3;
            int recipe_height = 3;
            if (obj.has("recipe_width")) {
                recipe_width = obj.get("recipe_width").getAsInt();
            }
            if (obj.has("recipe_height")) {
                recipe_height = obj.get("recipe_height").getAsInt();
            }
            if (recipe != null) {
                NonNullList ingredients = recipe.func_192400_c();
                numIng = ingredients.size();
                int w = 100;
                int h = 100;
                if (recipe instanceof IShapedRecipe) {
                    w = ((IShapedRecipe)recipe).getRecipeWidth();
                    h = ((IShapedRecipe)recipe).getRecipeHeight();
                }
                int x = 0;
                int y = 0;
                int q = 0;
                for (int i = 0; i < 9; ++i) {
                    if (w != 0 && x >= w || h != 0 && y >= h || q >= ingredients.size()) {
                        ret.add((JsonElement)air);
                    } else {
                        Ingredient ing = (Ingredient)ingredients.get(q++);
                        ret.add(this.elementForIngredient(ing));
                    }
                    if (++x < recipe_width) continue;
                    x = 0;
                    if (++y >= recipe_height) break;
                }
                ret.add((JsonElement)DataUtils.toJson(recipe.func_77571_b()));
            }
            return ret;
        }
        return new JsonArray();
    }

    private JsonElement elementForIngredient(Ingredient ing) {
        ItemStack[] stacks = ing.func_193365_a();
        if (stacks.length == 1) {
            return DataUtils.toJson(stacks[0]);
        }
        JsonObject arrHolder = new JsonObject();
        JsonArray arr = new JsonArray();
        for (int j = 0; j < stacks.length; ++j) {
            arr.add((JsonElement)DataUtils.toJson(stacks[j]));
        }
        arrHolder.add("imgarray", (JsonElement)arr);
        return arrHolder;
    }

    private JsonElement resolveTemplateObject(JsonArray elements, JsonElement entry) {
        if (entry.isJsonPrimitive()) {
            return entry;
        }
        if (entry.isJsonNull()) {
            return entry;
        }
        if (entry.isJsonArray()) {
            JsonArray newArray = new JsonArray();
            for (JsonElement el : entry.getAsJsonArray()) {
                newArray.add(this.resolveTemplateObject(elements, el));
            }
            return newArray;
        }
        if (entry.isJsonObject()) {
            JsonObject newObj = entry.getAsJsonObject();
            if (entry.getAsJsonObject().has("placeholder")) {
                newObj = new JsonObject();
                for (Map.Entry subentry : entry.getAsJsonObject().entrySet()) {
                    if (!((String)subentry.getKey()).equals("placeholder")) {
                        newObj.add((String)subentry.getKey(), (JsonElement)subentry.getValue());
                        continue;
                    }
                    int placeholderId = ((JsonElement)subentry.getValue()).getAsInt();
                    if (placeholderId < 0 || placeholderId >= elements.size()) continue;
                    for (Map.Entry srcEntry : elements.get(placeholderId).getAsJsonObject().entrySet()) {
                        newObj.add((String)srcEntry.getKey(), this.resolveTemplateObject(elements, (JsonElement)srcEntry.getValue()));
                    }
                }
            }
            return newObj;
        }
        throw new RuntimeException("This can't happen");
    }

    private void insertLabel(JsonObject translation, JsonElement l, boolean isTitle) {
        if (l.isJsonPrimitive()) {
            JsonPrimitive p = l.getAsJsonPrimitive();
            if (p.isString()) {
                String key = l.getAsString();
                if (translation.has(key)) {
                    key = translation.get(key).getAsString();
                }
                if (isTitle) {
                    key = TextFormatting.UNDERLINE + key + TextFormatting.RESET;
                }
                GuiMultilineLabel label = new GuiMultilineLabel(2, this.yPos, this.width - 4, key);
                label.setColor(Color.BLACK);
                if (isTitle) {
                    label.setAlignment(GuiMultilineLabel.Alignment.CENTER);
                }
                this.addControl(label);
                label.extraData.put("spacing", 6);
                this.yPos += label.getHeight() + 6;
            } else if (p.isNumber()) {
                int space = p.getAsInt();
                GuiEmpty empty = new GuiEmpty(2, this.yPos, this.width - 4, space);
                this.yPos += space;
            }
        } else {
            GuiControl control = null;
            JsonObject obj = l.getAsJsonObject();
            control = this.insertImage(obj);
            if (control != null) {
                control.setX((this.width - this.marginRight) / 2 - control.getWidth() / 2);
            } else if (obj.has("link") || obj.has("extLink")) {
                control = this.insertLink((JsonElement)obj, translation);
                if (control != null) {
                    control.setX(2);
                    ((GuiSized)control).setWidth(this.width - 4);
                }
            } else if (obj.has("horiz") || obj.has("canvas")) {
                JsonArray elements = null;
                GuiGroup layout = null;
                if (obj.has("horiz")) {
                    elements = obj.get("horiz").getAsJsonArray();
                    layout = new GuiHorizontalLayout(2, this.yPos, this.width - 2 - this.marginRight, 0, 2);
                } else if (obj.has("canvas")) {
                    elements = obj.get("canvas").getAsJsonArray();
                    layout = new GuiGroup(2, this.yPos, 0, this.height);
                } else {
                    throw new RuntimeException("This can't happen");
                }
                int height = 0;
                int width = layout.getWidth();
                int z = 0;
                boolean autoHeight = true;
                boolean autoWidth = true;
                if (obj.has("height")) {
                    height = obj.get("height").getAsInt();
                    autoHeight = false;
                }
                if (obj.has("width")) {
                    width = obj.get("width").getAsInt();
                    autoWidth = false;
                }
                if (obj.has("spacing")) {
                    layout.extraData.put("spacing", obj.get("spacing").getAsInt());
                }
                for (int i = 0; i < elements.size(); ++i) {
                    JsonObject el = elements.get(i).getAsJsonObject();
                    GuiImage image = this.imageForIcon(el);
                    if (image == null) continue;
                    image.setzIndex(z++);
                    layout.addControl(image);
                    if (autoHeight && height < image.getY() + image.getHeight()) {
                        height = image.getY() + image.getHeight();
                    }
                    if (!autoWidth || width >= image.getX() + image.getWidth()) continue;
                    width = image.getX() + image.getWidth();
                }
                layout.setHeight(height);
                layout.setWidth(width);
                layout.setX(this.width / 2 - layout.getWidth() / 2);
                control = layout;
            }
            if (control != null) {
                this.addControl(control);
                control.setY(this.yPos);
                this.yPos += control.getHeight();
                if (control.extraData.containsKey("spacing")) {
                    this.yPos += ((Integer)control.extraData.get("spacing")).intValue();
                }
            }
        }
    }

    private void addButtonsForList(JsonObject body, String seealso2, JsonObject translation) {
        JsonArray index = body.get(seealso2).getAsJsonArray();
        for (int i = 0; i < index.size(); ++i) {
            GuiSized control = this.insertLink(index.get(i), translation);
            if (control == null) continue;
            control.setY(this.yPos);
            control.setX(2);
            control.setWidth(this.width - 4);
            this.addControl(control);
            this.yPos += control.getHeight();
            if (!control.extraData.containsKey("spacing")) continue;
            this.yPos += ((Integer)control.extraData.get("spacing")).intValue();
        }
    }

    private GuiControl insertImage(JsonObject img) {
        return this.imageForIcon(img);
    }

    private GuiSized insertLink(JsonElement ele, JsonObject translation) {
        String otherUri = null;
        String extUri = null;
        int spacing = 4;
        GuiControl image = null;
        String label = null;
        if (ele.isJsonPrimitive()) {
            otherUri = this.resolveUri(this.currentUri, ele.getAsString());
        } else {
            JsonObject obj = ele.getAsJsonObject();
            if (obj.has("link")) {
                otherUri = this.resolveUri(this.currentUri, obj.get("link").getAsString());
            } else if (obj.has("extLink")) {
                extUri = obj.get("extLink").getAsString();
            }
            if (obj.has("spacing")) {
                spacing = obj.get("spacing").getAsInt();
            }
            if (obj.has("icon")) {
                image = this.imageForIcon(obj.get("icon").getAsJsonObject());
            }
            if (obj.has("label") && translation.has(label = obj.get("label").getAsString())) {
                label = translation.get(label).getAsString();
            }
        }
        if (otherUri != null) {
            JsonElement enabled;
            JsonObject otherPage = this.loadResourceAsJson(new ResourceLocation(this.modId, this.baseFile(otherUri)));
            JsonObject otherTranslation = this.loadLocalizedResourceAsJson(otherUri);
            if (otherPage != null && otherPage.has("enabled") && (enabled = otherPage.get("enabled")).isJsonPrimitive()) {
                if (enabled.getAsJsonPrimitive().isBoolean() && !enabled.getAsBoolean()) {
                    return null;
                }
                if (enabled.getAsJsonPrimitive().isString()) {
                    try {
                        ItemUtils.getStackFromTag(enabled.getAsString());
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
            }
            if (image == null && otherPage != null && otherPage.has("icon")) {
                image = this.imageForIcon(otherPage.get("icon").getAsJsonObject());
            }
            if (label == null) {
                label = otherUri;
                if (otherTranslation != null) {
                    label = otherTranslation.get("title").getAsString();
                }
            }
        }
        GuiButton button = new GuiButton(0, 0, 0, this.width - 4, Math.max(14, image != null ? image.getHeight() + 4 : 0) + 4, label, (GuiImage)image);
        button.addListener(this);
        if (otherUri != null) {
            button.extraData.put("link", otherUri);
        } else if (extUri != null) {
            button.extraData.put("extLink", extUri);
        }
        if (spacing > 0) {
            button.extraData.put("spacing", spacing);
        }
        return button;
    }

    public String getTitle() {
        return this.title;
    }

    private String baseFile(String uri) {
        return "guide" + uri + ".json";
    }

    private String localeFile(String uri, String locale) {
        return "guide" + uri + "." + locale + ".json";
    }

    private JsonObject loadResourceAsJson(ResourceLocation res) {
        this.currentJson = res.func_110623_a();
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(res);
            JsonParser parser = new JsonParser();
            InputStreamReader is = new InputStreamReader(resource.func_110527_b());
            JsonObject ret = parser.parse((Reader)is).getAsJsonObject();
            is.close();
            return ret;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private JsonObject loadLocalizedResourceAsJson(String uri) {
        String locale = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        InputStream stream = null;
        try {
            ResourceLocation loc = new ResourceLocation(this.modId, this.localeFile(uri, locale));
            this.currentJson = loc.func_110623_a();
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
            stream = res.func_110527_b();
        }
        catch (IOException ex) {
            if (!locale.equals("en_us")) {
                try {
                    ResourceLocation loc = new ResourceLocation(this.modId, this.localeFile(uri, "en_us"));
                    this.currentJson = loc.func_110623_a();
                    IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
                    stream = res.func_110527_b();
                }
                catch (IOException ex2) {
                    return null;
                }
            }
            return null;
        }
        try {
            JsonParser parser = new JsonParser();
            InputStreamReader is = new InputStreamReader(stream);
            JsonObject ret = parser.parse((Reader)is).getAsJsonObject();
            is.close();
            return ret;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void triggerNavigated(String newUri) {
        if (!this.enabled) {
            return;
        }
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof NavigationListener)) continue;
            ((NavigationListener)listener).navigated(newUri);
        }
    }

    private void triggerNavigatedExternal(String newUri) {
        if (!this.enabled) {
            return;
        }
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof NavigationListener)) continue;
            ((NavigationListener)listener).navigatedExternal(newUri);
        }
    }

    @Override
    public void clicked(GuiButton.ClickedEvent event) {
        if (event.control.extraData.containsKey("link")) {
            this.triggerNavigated((String)event.control.extraData.get("link"));
        } else if (event.control.extraData.containsKey("extLink")) {
            String uri = (String)event.control.extraData.get("extLink");
            this.triggerNavigatedExternal(uri);
        }
    }

    private GuiImage imageForIcon(JsonObject icon) {
        int x = 0;
        int y = 0;
        int spacing = 4;
        String link = null;
        if (icon.has("x")) {
            x = icon.get("x").getAsInt();
        }
        if (icon.has("y")) {
            y = icon.get("y").getAsInt();
        }
        if (icon.has("link")) {
            link = icon.get("link").getAsString();
        }
        if (icon.has("spacing")) {
            spacing = icon.get("spacing").getAsInt();
        }
        GuiImage ret = null;
        if (icon.has("imgarray")) {
            JsonArray images = icon.get("imgarray").getAsJsonArray();
            GuiImageFlipper flipper = new GuiImageFlipper(x, y);
            for (JsonElement el : images) {
                if (!el.isJsonObject()) continue;
                flipper.addImage(this.imageForIcon(el.getAsJsonObject()));
            }
            ret = flipper;
        } else if (icon.has("bucket")) {
            String fluidId = icon.get("bucket").getAsString();
            Fluid fluid = FluidRegistry.getFluid((String)fluidId);
            if (fluid != null) {
                ItemStack item = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
                ret = new GuiImageItemStack(x, y, item);
            }
        } else if (icon.has("img")) {
            ResourceLocation src = icon.has("mod") ? new ResourceLocation(icon.get("mod").getAsString(), icon.get("img").getAsString()) : new ResourceLocation(this.modId, icon.get("img").getAsString());
            int width = icon.get("width").getAsInt();
            int height = icon.get("height").getAsInt();
            int sourceX = 0;
            int sourceY = 0;
            int sourceWidth = width;
            int sourceHeight = height;
            int textureWidth = 256;
            int textureHeight = 256;
            boolean sub = false;
            if (icon.has("sx")) {
                sourceX = icon.get("sx").getAsInt();
                sub = true;
            }
            if (icon.has("sy")) {
                sourceY = icon.get("sy").getAsInt();
                sub = true;
            }
            if (icon.has("sw")) {
                sourceWidth = icon.get("sw").getAsInt();
                sub = true;
            }
            if (icon.has("sh")) {
                sourceHeight = icon.get("sh").getAsInt();
                sub = true;
            }
            if (icon.has("tw")) {
                textureWidth = icon.get("tw").getAsInt();
                sub = true;
            }
            if (icon.has("th")) {
                textureHeight = icon.get("th").getAsInt();
                sub = true;
            }
            if (!sub) {
                textureWidth = width;
                textureHeight = height;
            }
            GuiImageTexture image = new GuiImageTexture(x, y, width, height, sourceX, sourceY, sourceWidth, sourceHeight, src, textureWidth, textureHeight);
            ret = image;
        } else if (icon.has("item")) {
            ItemStack stack = DataUtils.toItemStack(icon);
            ret = new GuiImageItemStack(x, y, stack);
        }
        if (ret == null) {
            return null;
        }
        if (link != null) {
            ret.extraData.put("link", link);
            ret.addListener(this);
        }
        if (spacing > 0) {
            ret.extraData.put("spacing", spacing);
        }
        return ret;
    }

    private String resolveUri(String currentUri, String newUri) {
        String currentPath;
        if (newUri.startsWith("/")) {
            return newUri;
        }
        if (!currentUri.contains("/")) {
            currentUri = "/" + currentUri;
        }
        if (!(currentPath = FilenameUtils.getPath((String)currentUri)).endsWith("/")) {
            currentPath = currentPath + "/";
        }
        if (!currentPath.startsWith("/")) {
            currentPath = "/" + currentPath;
        }
        return currentPath + newUri;
    }

    public static interface NavigationListener
    extends EventListener {
        public void navigated(String var1);

        public void navigatedExternal(String var1);
    }
}

