/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiGroup;
import com.mike_caron.mikesmodslib.gui.IGuiGroup;

public class GuiHorizontalLayout
extends GuiGroup
implements IGuiGroup {
    private int margin;

    public GuiHorizontalLayout(int x, int y, int width, int height, int margin) {
        super(x, y, width, height);
        this.margin = margin;
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.doLayout();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.doLayout();
    }

    @Override
    public void addControl(GuiControl control) {
        super.addControl(control);
        this.doLayout();
    }

    @Override
    public void removeControl(GuiControl control) {
        super.removeControl(control);
        this.doLayout();
    }

    private void doLayout() {
        if (this.controls.size() < 1) {
            return;
        }
        int totalWidth = 0;
        totalWidth += this.margin * (this.controls.size() - 1);
        for (GuiControl control : this.controls) {
            totalWidth += control.getWidth();
        }
        int left = this.width / 2 - totalWidth / 2;
        for (GuiControl control : this.controls) {
            control.setY(this.height / 2 - control.getHeight() / 2);
            control.setX(left);
            left += control.getWidth() + this.margin;
        }
    }
}

