/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiImage;
import com.mike_caron.mikesmodslib.gui.IGuiGroup;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;

public class GuiImageFlipper
extends GuiImage {
    private final List<GuiImage> subImages = new ArrayList<GuiImage>();
    private int timer;
    private int currentImage;

    public GuiImageFlipper(int x, int y) {
        super(x, y);
    }

    @Override
    public void update() {
        ++this.timer;
        if (this.timer >= 20) {
            this.timer = 0;
            ++this.currentImage;
        }
    }

    @Override
    public int getWidth() {
        return this.subImages.stream().map(GuiControl::getWidth).max(Integer::compareTo).orElse(0);
    }

    @Override
    public int getHeight() {
        return this.subImages.stream().map(GuiControl::getHeight).max(Integer::compareTo).orElse(0);
    }

    @Override
    public void setParent(IGuiGroup parent) {
        super.setParent(parent);
        for (GuiImage image : this.subImages) {
            image.setParent(parent);
        }
    }

    public void addImage(GuiImage image) {
        this.subImages.add(image);
        image.setParent(this.parent);
    }

    public void clearImages() {
        this.subImages.clear();
    }

    @Override
    @Nullable
    public List<String> getTooltip(EntityPlayer player, ITooltipFlag tooltipFlag, int mouseX, int mouseY) {
        if (this.subImages.size() == 0) {
            return null;
        }
        if (this.currentImage >= this.subImages.size()) {
            this.currentImage = 0;
        }
        return this.subImages.get(this.currentImage).getTooltip(player, tooltipFlag, mouseX, mouseY);
    }

    @Override
    public void draw() {
        if (this.subImages.size() == 0) {
            return;
        }
        if (this.currentImage >= this.subImages.size()) {
            this.currentImage = 0;
        }
        GuiImage realImage = this.subImages.get(this.currentImage);
        int w = this.getWidth();
        int h = this.getHeight();
        int x = w / 2 - realImage.getWidth() / 2;
        int y = h / 2 - realImage.getHeight() / 2;
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        realImage.draw();
    }
}

