/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiImage;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.awt.Color;
import net.minecraft.util.ResourceLocation;

public class GuiImageTexture
extends GuiImage {
    private int width;
    private int height;
    private int sourceX;
    private int sourceY;
    private int sourceWidth;
    private int sourceHeight;
    private int textureWidth;
    private int textureHeight;
    private ResourceLocation texture;

    public GuiImageTexture(int x, int y, int width, int height, int sourceX, int sourceY, ResourceLocation texture) {
        this(x, y, width, height, sourceX, sourceY, width, height, texture);
    }

    public GuiImageTexture(int x, int y, int width, int height, int sourceX, int sourceY, int sourceWidth, int sourceHeight, ResourceLocation texture) {
        this(x, y, width, height, sourceX, sourceY, sourceWidth, sourceHeight, texture, 256, 256);
    }

    public GuiImageTexture(int x, int y, int width, int height, int sourceX, int sourceY, int sourceWidth, int sourceHeight, ResourceLocation texture, int textureWidth, int textureHeight) {
        super(x, y);
        this.width = width;
        this.height = height;
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    @Override
    public void draw() {
        GuiUtil.bindTexture(this.texture);
        GuiUtil.setGLColor(Color.WHITE);
        GuiUtil.drawStretchedTexturePart(0.0f, 0.0f, this.width, this.height, this.sourceX, this.sourceY, this.sourceWidth, this.sourceHeight, this.textureWidth, this.textureHeight);
    }

    public void setSourceX(int sourceX) {
        this.sourceX = sourceX;
    }

    public void setSourceY(int sourceY) {
        this.sourceY = sourceY;
    }

    public void setSourceWidth(int sourceWidth) {
        this.sourceWidth = sourceWidth;
    }

    public void setSourceHeight(int sourceHeight) {
        this.sourceHeight = sourceHeight;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

