/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiControl;
import java.awt.Color;

public class GuiLabel
extends GuiControl {
    protected String stringLabel;
    protected Color color;
    protected Alignment alignment;
    protected VerticalAlignment verticalAlignment;

    public GuiLabel(int x, int y, String key) {
        this(x, y, null, key, Alignment.LEFT, VerticalAlignment.BOTTOM);
    }

    public GuiLabel(int x, int y, Color color, String key) {
        this(x, y, color, key, Alignment.LEFT, VerticalAlignment.BOTTOM);
    }

    public GuiLabel(int x, int y, Color color, String key, Alignment alignment) {
        this(x, y, color, key, alignment, VerticalAlignment.BOTTOM);
    }

    public GuiLabel(int x, int y, Color color, String key, Alignment alignment, VerticalAlignment verticalAlignment) {
        super(x, y);
        this.color = color;
        this.stringLabel = key;
        this.alignment = alignment;
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public int getWidth() {
        return this.parent.getFontRenderer().func_78256_a(this.stringLabel);
    }

    @Override
    public int getHeight() {
        return 10;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        String l = this.getLabel();
        int dx = 0;
        int dy = 0;
        int sw = this.parent.getFontRenderer().func_78256_a(l);
        int sh = this.parent.getFontRenderer().field_78288_b;
        if (this.alignment == Alignment.CENTER) {
            dx = -(sw / 2);
        } else if (this.alignment == Alignment.RIGHT) {
            dx = -sw;
        }
        if (this.verticalAlignment == VerticalAlignment.TOP) {
            dy = -sh;
        } else if (this.verticalAlignment == VerticalAlignment.MIDDLE) {
            dy = -(sh / 2);
        }
        Color col = this.color != null ? this.color : this.parent.getForeColor();
        this.parent.getFontRenderer().func_78276_b(l, dx, dy, col.getRGB());
    }

    public String getLabel() {
        return this.stringLabel;
    }

    public static enum VerticalAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

