/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiClippedSized;
import com.mike_caron.mikesmodslib.gui.GuiScrollBar;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class GuiList
extends GuiClippedSized
implements GuiScrollBar.ScrollListener {
    Producer producer;
    private GuiScrollBar scrollBar;
    private int lastNumItems = -1;
    int mouseX = -1;
    int mouseY = -1;

    public GuiList(int x, int y, int width, int height, Producer producer) {
        super(x, y, width, height);
        this.producer = producer;
        this.scrollBar = new GuiScrollBar(this.width - 9, 1, 8, this.height - 2);
        this.scrollBar.addListener(this);
        this.lastNumItems = this.producer.getNumItems();
        this.scrollBar.setOneClick(this.getScrollClick());
        this.marginTop = 1;
        this.marginBottom = 1;
        this.marginLeft = 1;
        this.marginRight = 1;
    }

    @Override
    public void update() {
        if (this.producer.getNumItems() != this.lastNumItems) {
            this.lastNumItems = this.producer.getNumItems();
            this.scrollBar.setOneClick(this.getScrollClick());
        }
    }

    @Override
    public void draw() {
        int sw = this.scrollBarWidth();
        GuiUtil.setGLColor(Color.WHITE);
        GuiUtil.bindTexture(GuiUtil.MISC_RESOURCES);
        GuiUtil.draw3x3Stretched(0, 0, this.width, this.height, 16, 16);
        if (sw > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.scrollBar.getX(), (float)this.scrollBar.getY(), (float)0.0f);
            this.scrollBar.draw();
            GlStateManager.func_179121_F();
        }
        if (this.producer != null) {
            int itemHeight = this.producer.getItemHeight();
            int numItems = this.maxVisibleItems();
            int numSkipped = this.scrollY / itemHeight;
            int over = -1;
            over = this.getItemOver(this.mouseX, this.mouseY - 1, this.width - 2 - this.scrollBarWidth(), itemHeight);
            this.start();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)1.0f, (float)(1 + numSkipped * itemHeight), (float)0.0f);
            for (int i = 0; i < numItems && i + numSkipped < this.producer.getNumItems(); ++i) {
                ListItem item = this.producer.getItem(i + numSkipped);
                item.draw(this.width - 2 - sw, itemHeight, ListItemState.forState(over == i + numSkipped));
                GL11.glTranslatef((float)0.0f, (float)itemHeight, (float)0.0f);
            }
            GL11.glPopMatrix();
            this.finish();
        }
    }

    private int maxVisibleItems() {
        if (this.producer == null) {
            return 0;
        }
        return 1 + this.height / this.producer.getItemHeight();
    }

    private int maxScrollHeight() {
        if (this.producer == null) {
            return 0;
        }
        int h = this.producer.getItemHeight();
        return Math.max(0, h * this.producer.getNumItems() - (this.height - 2));
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.scrollBar.setX(this.width - 9);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.scrollBar.setHeight(this.height - 2);
        this.scrollBar.setOneClick(this.getScrollClick());
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.scrollBar.onMouseUp(mouseX, mouseY, button);
    }

    @Override
    public void onMouseWheel(int mouseX, int mouseY, int deltaWheel) {
        this.scrollBar.setProgress(this.scrollBar.getProgress() - this.scrollBar.getOneClick() * (float)deltaWheel);
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.scrollBar.onMouseMove(mouseX - this.scrollBar.getX(), mouseY - this.scrollBar.getY());
    }

    @Override
    public void onMouseExit() {
        this.mouseX = -1;
        this.mouseY = -1;
    }

    @Override
    public void onMouseOver(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        int over;
        int sX = this.width - 9;
        if (GuiUtil.inBounds(mouseX, mouseY, this.scrollBar)) {
            this.scrollBar.onMouseDown(mouseX - this.scrollBar.getX(), mouseY - this.scrollBar.getY(), button);
        } else if (this.producer != null && (over = this.getItemOver(mouseX, mouseY - 1, this.width - 2 - this.scrollBarWidth(), this.producer.getItemHeight())) != -1 && over < this.producer.getNumItems()) {
            this.producer.onClick(over);
        }
    }

    private float getScrollClick() {
        int h = this.maxScrollHeight();
        if (h == 0) {
            return 1.0f;
        }
        return 7.0f / (float)h;
    }

    private int getItemOver(int mouseX, int mouseY, int itemWidth, int itemHeight) {
        if (mouseX >= 1 && mouseX < itemWidth + 1) {
            return (mouseY + this.scrollY) / itemHeight;
        }
        return -1;
    }

    private int scrollBarWidth() {
        if (this.producer == null || this.producer.getNumItems() * this.producer.getItemHeight() <= this.height - 2) {
            return 0;
        }
        return 8;
    }

    @Override
    @Nullable
    public List<String> getTooltip(EntityPlayer player, ITooltipFlag tooltipFlag, int mouseX, int mouseY) {
        int iw;
        int over;
        if (this.producer != null && (over = this.getItemOver(mouseX, mouseY - 1, iw = this.width - 2 - this.scrollBarWidth(), this.producer.getItemHeight())) >= 0 && over < this.producer.getNumItems()) {
            int itemHeight = this.producer.getItemHeight();
            int adjustedY = mouseY + this.scrollY - 1;
            int realY = adjustedY - itemHeight * (adjustedY / itemHeight);
            return this.producer.getItem(over).getTooltip(player, tooltipFlag, mouseX - 1, realY, iw);
        }
        return null;
    }

    @Override
    public void scrolled(GuiScrollBar.ScrollEvent event) {
        this.scrollY = (int)Math.floor((float)this.maxScrollHeight() * event.progress);
    }

    public static enum ListItemState {
        NORMAL(false),
        MOUSE_OVER(true);

        boolean isOver;

        private ListItemState(boolean isOver) {
            this.isOver = isOver;
        }

        public boolean isOver() {
            return this.isOver;
        }

        public static ListItemState forState(boolean isOver) {
            if (isOver) {
                return MOUSE_OVER;
            }
            return NORMAL;
        }
    }

    public static interface ListItem {
        public void draw(int var1, int var2, ListItemState var3);

        default public List<String> getTooltip(EntityPlayer player, ITooltipFlag tooltipFlag, int mouseX, int mouseY, int width) {
            return null;
        }
    }

    public static interface Producer {
        public int getNumItems();

        public int getItemHeight();

        public ListItem getItem(int var1);

        public void onClick(int var1);
    }
}

