/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public class GuiMultilineLabel
extends GuiSized {
    private String string;
    private Color color;
    private Alignment alignment;
    private VerticalAlignment valignment;
    private List<String> lines;
    private boolean autoHeight = false;

    public GuiMultilineLabel(int x, int y, int width, String string) {
        this(x, y, width, -1, string);
    }

    public GuiMultilineLabel(int x, int y, int width, int height, String string) {
        this(x, y, width, height, GuiUtil.FONT_COLOUR, Alignment.LEFT, VerticalAlignment.CENTER, string);
    }

    public GuiMultilineLabel(int x, int y, int width, Color color, String string) {
        this(x, y, width, -1, color, Alignment.LEFT, VerticalAlignment.CENTER, string);
    }

    public GuiMultilineLabel(int x, int y, int width, int height, Color color, String string) {
        this(x, y, width, height, color, Alignment.LEFT, VerticalAlignment.CENTER, string);
    }

    public GuiMultilineLabel(int x, int y, int width, int height, Alignment alignment, VerticalAlignment valignment, String string) {
        this(x, y, width, height, GuiUtil.FONT_COLOUR, alignment, valignment, string);
    }

    public GuiMultilineLabel(int x, int y, int width, int height, Color color, Alignment alignment, VerticalAlignment valignment, String string) {
        super(x, y, width, height);
        this.color = color;
        this.string = string;
        this.alignment = alignment;
        this.valignment = valignment;
        if (height == -1) {
            this.autoHeight = true;
        }
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
        this.lines = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.valignment;
    }

    public void setVeticalAlignment(VerticalAlignment valignment) {
        this.valignment = valignment;
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        if (height == -1 && !this.autoHeight) {
            this.autoHeight = true;
            this.lines = null;
        } else if (height != -1 && this.autoHeight) {
            this.autoHeight = false;
            this.lines = null;
        }
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.lines = null;
    }

    @Override
    public int getHeight() {
        if (this.autoHeight) {
            if (this.lines == null) {
                this.updateCache();
            }
            if (this.lines == null) {
                return 10;
            }
            FontRenderer renderer = this.parent.getFontRenderer();
            return this.lines.size() * renderer.field_78288_b;
        }
        return super.getHeight();
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.lines == null) {
            this.updateCache();
        }
        if (this.lines == null) {
            return;
        }
        FontRenderer renderer = this.parent.getFontRenderer();
        int dh = this.lines.size() * renderer.field_78288_b;
        int dy = 0;
        if (!this.autoHeight) {
            switch (this.valignment) {
                case TOP: {
                    dy = 0;
                    break;
                }
                case CENTER: {
                    dy = this.height / 2 - dh / 2;
                    break;
                }
                case BOTTOM: {
                    dy = this.height - dh;
                }
            }
        }
        GuiUtil.setGLColor(Color.WHITE);
        for (int i = 0; i < this.lines.size(); ++i) {
            int w = renderer.func_78256_a(this.lines.get(i));
            int dx = -1;
            switch (this.alignment) {
                case LEFT: {
                    dx = 0;
                    break;
                }
                case CENTER: {
                    dx = this.width / 2 - w / 2;
                    break;
                }
                case RIGHT: {
                    dx = this.width - w;
                }
            }
            renderer.func_78276_b(this.lines.get(i), dx, dy + i * renderer.field_78288_b, this.color.getRGB());
        }
    }

    private void updateCache() {
        if (this.parent == null || this.parent.getFontRenderer() == null) {
            return;
        }
        this.lines = this.parent.getFontRenderer().func_78271_c(this.string, this.width);
        if (this.height == -1) {
            this.height = this.lines.size() * 10;
        }
    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

