/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.ControlEvent;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.awt.Color;
import java.util.EventListener;

public class GuiScrollBar
extends GuiSized {
    int nubY = 0;
    boolean draggingNub = false;
    int draggingStartMouse = 0;
    int draggingStartNub = 0;
    float progress = 0.0f;
    float oneClick = 0.1f;
    final int GFX_X = 64;
    final int GFX_Y = 16;

    public GuiScrollBar(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.draggingNub = false;
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        if (GuiUtil.inBounds(mouseX, mouseY, 0, this.width + this.nubY, this.width, this.width)) {
            this.draggingNub = true;
            this.draggingStartMouse = mouseY;
            this.draggingStartNub = this.nubY;
        } else if (GuiUtil.inBounds(mouseX, mouseY, 0, 0, this.width, this.width)) {
            this.setNubY(this.nubY - 1);
        } else if (GuiUtil.inBounds(mouseX, mouseY, 0, this.height - 8, this.width, this.width)) {
            this.setNubY(this.nubY + 1);
        } else if (GuiUtil.inBounds(mouseX, mouseY, 0, this.width, this.width, this.height - this.width * 2)) {
            this.setNubY(mouseY - this.width - this.width / 2);
        }
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        if (this.draggingNub) {
            int dy = mouseY - this.draggingStartMouse;
            this.setNubY(this.draggingStartNub + dy);
        }
    }

    @Override
    public void draw() {
        GuiUtil.setGLColor(Color.WHITE);
        GuiUtil.bindTexture(GuiUtil.MISC_RESOURCES);
        GuiUtil.draw3x3(0, 0, this.width, this.height, 72, 0, 2, 4);
        GuiUtil.drawStretchedTexturePart(0.0f, 0.0f, this.width, this.width, 64, 16, 8, 8, 256, 256);
        GuiUtil.drawStretchedTexturePart(0.0f, this.height - this.width, this.width, this.width, 64, 24, 8, 8, 256, 256);
        GuiUtil.drawTexturePart(0.0f, this.width + this.nubY, 8, 8, 72, 24, 256, 256);
    }

    private void setNubY(int nubY) {
        int minY = 0;
        int maxY = this.height - this.width * 3;
        if (nubY < minY) {
            nubY = minY;
        } else if (nubY > maxY) {
            nubY = maxY;
        }
        this.nubY = nubY;
        this.progress = (1.0f * (float)nubY - (float)minY) / (float)(maxY - minY);
        this.triggerScrollEvent();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float newProgress) {
        this.progress = Math.max(0.0f, Math.min(1.0f, newProgress));
        this.nubY = (int)Math.floor((float)(this.height - this.width * 3) * this.progress);
        this.triggerScrollEvent();
    }

    public void setOneClick(float newOneClick) {
        this.oneClick = newOneClick;
    }

    public float getOneClick() {
        return this.oneClick;
    }

    void triggerScrollEvent() {
        ScrollEvent evt = new ScrollEvent(this, this.progress);
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof ScrollListener)) continue;
            ((ScrollListener)listener).scrolled(evt);
        }
    }

    public static class ScrollEvent
    extends ControlEvent {
        public final float progress;

        public ScrollEvent(GuiControl control, float progress) {
            super(control);
            this.progress = progress;
        }
    }

    public static interface ScrollListener
    extends EventListener {
        public void scrolled(ScrollEvent var1);
    }
}

