/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiClippedSized;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiScrollBar;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import com.mike_caron.mikesmodslib.gui.IGuiGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class GuiScrollPort
extends GuiClippedSized
implements IGuiGroup,
GuiScrollBar.ScrollListener {
    protected final List<GuiControl> controls = new ArrayList<GuiControl>();
    private boolean enableScrollBar = false;
    protected final GuiScrollBar scrollBar = new GuiScrollBar(this.width - 8, 0, 8, this.height);
    int maxScrollX = 100000;
    int maxScrollY = 100000;
    boolean mouseDragEnabled = false;
    boolean mouseIsDownOnScrollbar = false;
    int mouseDownMouseY = 0;
    int mouseDownScrollY = 0;
    boolean mouseIsDown = false;

    public GuiScrollPort(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.scrollBar.addListener(this);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.scrollBar.setX(this.width - 8);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.scrollBar.setHeight(this.height);
    }

    @Override
    public void addControl(GuiControl control) {
        this.controls.add(control);
        control.setParent(this);
        this.sort();
    }

    @Override
    public void removeControl(GuiControl control) {
        this.controls.remove((Object)control);
    }

    @Override
    public void clearControls() {
        this.controls.clear();
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.parent.getFontRenderer();
    }

    @Override
    public boolean hasFocus() {
        for (GuiControl control : this.controls) {
            if (!control.hasFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHaveFocus() {
        return this.controls.stream().anyMatch(GuiControl::canHaveFocus);
    }

    @Override
    public void setFocused(boolean focused) {
        if (!focused) {
            for (GuiControl control : this.controls) {
                if (!control.hasFocus()) continue;
                control.setFocused(false);
                break;
            }
        } else {
            for (GuiControl control : this.controls) {
                if (!control.isEnabled() || !control.canHaveFocus()) continue;
                control.setFocused(true);
                break;
            }
        }
    }

    @Override
    public void onKeyTyped(char typedChar, int keyCode) {
        for (GuiControl control : this.controls) {
            if (!control.hasFocus()) continue;
            control.onKeyTyped(typedChar, keyCode);
            break;
        }
    }

    @Override
    public GuiControl hitTest(int x, int y) {
        if (GuiUtil.inBoundsThis(x, y, this)) {
            if (GuiUtil.inBounds(x, y, this.marginLeft, this.marginTop, this.width - this.marginLeft - this.marginRight, this.height - this.marginTop - this.marginBottom)) {
                for (GuiControl control : this.controls) {
                    int transY;
                    int transX;
                    GuiControl res;
                    if (!control.isVisible() || (res = control.hitTest(transX = x - control.getX() + this.scrollX, transY = y - control.getY() + this.scrollY)) == null) continue;
                    return res;
                }
            }
            return this;
        }
        return null;
    }

    @Override
    public boolean notifyTakeFocus(GuiControl taker) {
        if (this.parent != null && !this.parent.notifyTakeFocus(this)) {
            return false;
        }
        for (GuiControl control : this.controls) {
            if (control == taker || !control.hasFocus()) continue;
            control.setFocused(false);
        }
        return true;
    }

    @Override
    public void sort() {
        this.controls.sort(Comparator.comparingInt(a -> a.zIndex));
    }

    @Override
    public int translateToScreenX(int x) {
        return this.parent.translateToScreenX(x - this.scrollX + this.x);
    }

    @Override
    public int translateToScreenY(int y) {
        return this.parent.translateToScreenY(y - this.scrollY + this.y);
    }

    @Override
    public int translateFromScreenX(int x) {
        return this.parent.translateFromScreenX(x + this.scrollX - this.x);
    }

    @Override
    public int translateFromScreenY(int y) {
        return this.parent.translateFromScreenY(y + this.scrollY - this.y);
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.enableScrollBar) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.scrollBar.getX(), (float)this.scrollBar.getY(), (float)0.0f);
            this.scrollBar.draw();
            GlStateManager.func_179121_F();
        }
        this.start();
        for (GuiControl control : this.controls) {
            if (!control.isVisible()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)control.getX(), (float)control.getY(), (float)0.0f);
            control.preDraw();
            this.assertClippingPlane();
            control.draw();
            control.postDraw();
            GlStateManager.func_179121_F();
        }
        this.finish();
    }

    @Override
    public void onMouseOver(int mouseX, int mouseY) {
        if (this.enableScrollBar && GuiUtil.inBoundsThis(mouseX, mouseY, this.scrollBar)) {
            this.scrollBar.onMouseOver(mouseX - this.scrollBar.getX(), mouseY - this.scrollBar.getY());
        }
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        if (this.enableScrollBar && GuiUtil.inBounds(mouseX, mouseY, this.scrollBar)) {
            this.mouseIsDownOnScrollbar = true;
            this.scrollBar.onMouseDown(mouseX - this.scrollBar.getX(), mouseY - this.scrollBar.getY(), button);
            return;
        }
        if (this.mouseDragEnabled) {
            this.mouseIsDown = true;
            this.mouseDownMouseY = this.translateToScreenY(mouseY);
            this.mouseDownScrollY = this.scrollY;
        }
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        if (this.mouseIsDownOnScrollbar) {
            this.mouseIsDownOnScrollbar = false;
            if (this.enableScrollBar) {
                this.scrollBar.onMouseUp(mouseX - this.scrollBar.getX(), mouseY - this.scrollBar.getY(), button);
            }
            return;
        }
        if (this.mouseIsDown) {
            this.mouseIsDown = false;
        }
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        if (this.enableScrollBar && this.mouseIsDownOnScrollbar) {
            this.scrollBar.onMouseMove(mouseX - this.scrollBar.getX(), mouseY - this.scrollBar.getY());
        }
        if (this.mouseIsDown) {
            int realMouseY = this.translateToScreenY(mouseY);
            int mouseDelta = realMouseY - this.mouseDownMouseY;
            this.setScrollY(this.mouseDownScrollY - mouseDelta);
        }
    }

    @Override
    public void onMouseWheel(int mouseX, int mouseY, int deltaWheel) {
        this.scrollBar.setProgress(this.scrollBar.getProgress() - this.scrollBar.getOneClick() * (float)deltaWheel);
    }

    public void setEnableScrollBar(boolean enable) {
        this.enableScrollBar = enable;
        this.marginRight = this.enableScrollBar ? 8 : 0;
    }

    @Override
    public void scrolled(GuiScrollBar.ScrollEvent event) {
        this.scrollY = (int)Math.floor((float)this.maxScrollY * event.progress);
    }

    @Override
    public void setScrollY(int scrollY) {
        super.setScrollY(scrollY);
        if (this.maxScrollY == 0) {
            this.scrollBar.setProgress(0.0f);
        } else {
            this.scrollBar.setProgress(1.0f * (float)scrollY / (float)this.maxScrollY);
        }
    }

    public void setMaxScrollY(int maxScrollY) {
        if (maxScrollY < 0) {
            maxScrollY = 0;
        }
        this.maxScrollY = maxScrollY;
        if (maxScrollY != 0) {
            this.scrollBar.setOneClick(7.0f / (float)maxScrollY);
        } else {
            this.scrollBar.setOneClick(1.0f);
        }
        if (this.scrollY > maxScrollY) {
            this.scrollY = maxScrollY;
        }
        this.scrollBar.setProgress((float)this.scrollY / (float)maxScrollY);
    }

    @Override
    public void update() {
        for (GuiControl control : this.controls) {
            control.update();
        }
    }
}

