/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.ControlEvent;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.awt.Color;
import java.util.EventListener;
import javax.annotation.Nonnull;

public class GuiTextBox
extends GuiSized {
    private String currentString;
    private int foreColor;
    private int cursorPosition = 0;
    private int selectStart = 0;
    private int selectEnd = 0;

    public GuiTextBox(int x, int y, int width, int height) {
        this(x, y, width, height, Color.WHITE.getRGB());
    }

    public GuiTextBox(int x, int y, int width, int height, int foreColor) {
        super(x, y, width, height);
        this.foreColor = foreColor;
        this.currentString = "";
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int pos) {
        if (pos > this.currentString.length()) {
            pos = this.currentString.length();
        } else if (pos < 0) {
            pos = 0;
        }
        this.cursorPosition = pos;
    }

    public void setText(@Nonnull String text) {
        this.currentString = text;
        this.cursorPosition = this.currentString.length();
    }

    public String getText() {
        return this.currentString;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        GuiUtil.draw3x3Stretched(0, 0, this.width, this.height, 16, 16);
        String beforeCursor = this.currentString.substring(0, this.cursorPosition);
        int cursorX = this.parent.getFontRenderer().func_78256_a(beforeCursor);
        this.parent.getFontRenderer().func_78276_b(this.currentString, 1, 1, this.foreColor);
    }

    private void triggerChangedEvent() {
        ChangedEvent evt = new ChangedEvent(this);
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof TextboxListener)) continue;
            ((TextboxListener)listener).changed(evt);
        }
    }

    public static class ChangedEvent
    extends ControlEvent {
        public ChangedEvent(GuiControl control) {
            super(control);
        }
    }

    public static interface TextboxListener
    extends EventListener {
        public void changed(ChangedEvent var1);
    }
}

