/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.ControlEvent;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.util.EventListener;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;

public class GuiToggleButton
extends GuiSized {
    protected boolean isMouseOver;
    protected boolean isMouseDown;
    protected boolean pressed;
    protected int id;

    @Override
    public void onMouseEnter() {
        this.isMouseOver = true;
    }

    @Override
    public void onMouseExit() {
        this.isMouseOver = false;
    }

    public GuiToggleButton(int id, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.id = id;
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        if (button != 0) {
            return;
        }
        if (GuiUtil.inBoundsThis(mouseX, mouseY, this)) {
            this.pressed = !this.pressed;
            this.triggerClicked();
        }
        this.isMouseDown = false;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean getPressed() {
        return this.pressed;
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        if (button != 0) {
            return;
        }
        this.isMouseDown = true;
        GuiUtil.playSound(SoundEvents.field_187909_gi);
    }

    private State calcState() {
        if (this.isMouseDown) {
            return State.PRESSED;
        }
        if (this.isMouseOver && !this.pressed) {
            return State.HOVERED;
        }
        if (this.pressed) {
            return State.PRESSED;
        }
        return State.NORMAL;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        int sx = 0;
        State state = this.calcState();
        switch (state) {
            case NORMAL: {
                sx = 16;
                break;
            }
            case HOVERED: {
                sx = 32;
                break;
            }
            case PRESSED: {
                sx = 48;
            }
        }
        GuiUtil.bindTexture(GuiUtil.MISC_RESOURCES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtil.draw3x3(0, 0, this.width, this.height, sx, 0);
    }

    private void triggerClicked() {
        ChangedEvent evt = new ChangedEvent(this, this.id, this.pressed);
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof ChangedListener)) continue;
            ((ChangedListener)listener).changed(evt);
        }
    }

    public static class ChangedEvent
    extends ControlEvent {
        public final boolean newState;
        public final int id;

        public ChangedEvent(GuiControl control, int id, boolean newState) {
            super(control);
            this.id = id;
            this.newState = newState;
        }
    }

    public static interface ChangedListener
    extends EventListener {
        public void changed(ChangedEvent var1);
    }

    static enum State {
        NORMAL,
        HOVERED,
        PRESSED;

    }
}

