/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiButton;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiLabel;
import com.mike_caron.mikesmodslib.gui.GuiMultilineLabel;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiUtil {
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final Color FONT_COLOUR = new Color(0x404040);
    static final ResourceLocation MISC_RESOURCES = new ResourceLocation("mikesmodslib", "textures/gui/misc.png");

    private GuiUtil() {
    }

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resource);
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void setGLColor(Color color) {
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
    }

    public static boolean inBounds(int mouseX, int mouseY, GuiControl button) {
        return GuiUtil.inBounds(mouseX, mouseY, button.getX(), button.getY(), button.getWidth(), button.getHeight());
    }

    public static boolean inBoundsThis(int mouseX, int mouseY, GuiControl control) {
        return GuiUtil.inBounds(mouseX, mouseY, 0, 0, control.getWidth(), control.getHeight());
    }

    public static boolean inBounds(int mouseX, int mouseY, int bx, int by, int bw, int bh) {
        return mouseX >= bx && mouseX < bx + bw && mouseY >= by && mouseY < by + bh;
    }

    public static void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null) {
            return;
        }
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GuiUtil.bindTexture(MC_BLOCK_SHEET);
        int color = fluid.getFluid().getColor(fluid);
        GuiUtil.setGLColorFromInt(color);
        GuiUtil.drawTiledTexture(x, y, GuiUtil.getTexture(fluid.getFluid().getStill(fluid)), width, height);
        GL11.glPopMatrix();
    }

    protected static void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                GuiUtil.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected static void drawScaledTexturedModelRectFromIcon(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        float zLevel = 0.0f;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a(minU, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawTiledTexturePart(int x, int y, int width, int height, int tileX, int tileY, int tileWidth, int tileHeight, int sheetWidth, int sheetHeight) {
        float minU = (float)tileX * 1.0f / (float)sheetWidth;
        float minV = (float)tileY * 1.0f / (float)sheetHeight;
        for (int i = 0; i < width; i += tileWidth) {
            for (int j = 0; j < height; j += tileHeight) {
                int drawWidth = Math.min(width - i, tileWidth);
                int drawHeight = Math.min(height - j, tileHeight);
                BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
                buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b((double)(x + i), (double)(y + j), 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
                buffer.func_181662_b((double)(x + i), (double)(y + j + drawHeight), 0.0).func_187315_a((double)minU, (double)((float)(tileY + drawHeight) * 1.0f / (float)sheetHeight)).func_181675_d();
                buffer.func_181662_b((double)(x + i + drawWidth), (double)(y + j), 0.0).func_187315_a((double)((float)(tileX + drawWidth) * 1.0f / (float)sheetWidth), (double)minV).func_181675_d();
                buffer.func_181662_b((double)(x + i + drawWidth), (double)(y + j + drawHeight), 0.0).func_187315_a((double)((float)(tileX + drawWidth) * 1.0f / (float)sheetWidth), (double)((float)(tileY + drawHeight) * 1.0f / (float)sheetHeight)).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
        }
    }

    public static void drawStretchedTexturePart(float x, float y, int width, int height, int tileX, int tileY, int tileWidth, int tileHeight, int sheetWidth, int sheetHeight) {
        float minU = (float)tileX * 1.0f / (float)sheetWidth;
        float minV = (float)tileY * 1.0f / (float)sheetHeight;
        float maxU = (float)(tileX + tileWidth) * 1.0f / (float)sheetWidth;
        float maxV = (float)(tileY + tileHeight) * 1.0f / (float)sheetHeight;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + (float)height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)(x + (float)width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)(x + (float)width), (double)(y + (float)height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawTexturePart(float x, float y, int width, int height, int tileX, int tileY, int sheetWidth, int sheetHeight) {
        float minU = (float)tileX * 1.0f / (float)sheetWidth;
        float minV = (float)tileY * 1.0f / (float)sheetHeight;
        float maxU = (float)(tileX + width) * 1.0f / (float)sheetWidth;
        float maxV = (float)(tileY + height) * 1.0f / (float)sheetHeight;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + (float)height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)(x + (float)width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)(x + (float)width), (double)(y + (float)height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static GuiButtonImage makeGuiButtonImage(int buttonId, int x, int y, int width, int height, int xTex, int yTex, int yDiff, ResourceLocation resourceLocation) {
        return new GuiButtonImage(buttonId, x, y, width, height, xTex, yTex, yDiff, resourceLocation);
    }

    public static GuiButtonImage makeGuiButtonImage(int buttonId, int x, int y, int width, int height, int xTex, int yTex, ResourceLocation resourceLocation) {
        return new GuiButtonImage(buttonId, x, y, width, height, xTex, yTex, 0, resourceLocation);
    }

    public static GuiButton translatedButton(int buttonId, int x, int y, int width, int height, String key, Object ... replacements) {
        String translated = new TextComponentTranslation(key, replacements).func_150254_d();
        return new GuiButton(buttonId, x, y, width, height, translated);
    }

    public static GuiLabel staticLabelFromTranslationKey(int x, int y, String key, Object ... placeholders) {
        String message = new TextComponentTranslation(key, placeholders).func_150254_d();
        return new GuiLabel(x, y, message);
    }

    public static GuiMultilineLabel staticMultilineLabelFromTranslationKey(int x, int y, int width, int height, String key, Object ... placeholders) {
        String message = new TextComponentTranslation(key, placeholders).func_150254_d();
        return new GuiMultilineLabel(x, y, width, height, message);
    }

    public static void drawDebugFlatRectangle(ResourceLocation misc, int x, int y, int width, int height) {
        GuiUtil.bindTexture(misc);
        float minU = 0.0546875f;
        float maxU = 0.05859375f;
        float minV = 0.01171875f;
        float maxV = 0.015625f;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void draw3x3(int x, int y, int width, int height, int sx, int sy) {
        int CORNER_SIZE = 4;
        int CENTER_SIZE = 8;
        GuiUtil.draw3x3(x, y, width, height, sx, sy, 4, 8);
    }

    public static void draw3x3(int x, int y, int width, int height, int sx, int sy, int cornerSize, int centerSize) {
        int SHEET_SIZE = 256;
        int TILE_SIZE = cornerSize * 2 + centerSize;
        GuiUtil.drawTiledTexturePart(x, y, cornerSize, cornerSize, sx, sy, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x + width - cornerSize, y, cornerSize, cornerSize, sx + TILE_SIZE - cornerSize, sy, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x, y + height - cornerSize, cornerSize, cornerSize, sx, sy + TILE_SIZE - cornerSize, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x + width - cornerSize, y + height - cornerSize, cornerSize, cornerSize, sx + TILE_SIZE - cornerSize, sy + TILE_SIZE - cornerSize, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x + cornerSize, y, width - cornerSize * 2, cornerSize, sx + cornerSize, sy, centerSize, cornerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x + cornerSize, y + height - cornerSize, width - cornerSize * 2, cornerSize, sx + cornerSize, sy + TILE_SIZE - cornerSize, centerSize, cornerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x, y + cornerSize, cornerSize, height - cornerSize * 2, sx, sy + cornerSize, cornerSize, centerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x + width - cornerSize, y + cornerSize, cornerSize, height - cornerSize * 2, sx + TILE_SIZE - cornerSize, sy + cornerSize, cornerSize, centerSize, 256, 256);
        GuiUtil.drawTiledTexturePart(x + cornerSize, y + cornerSize, width - cornerSize * 2, height - cornerSize * 2, sx + cornerSize, sy + cornerSize, centerSize, centerSize, 256, 256);
    }

    public static void draw3x3Stretched(int x, int y, int width, int height, int sx, int sy) {
        int CORNER_SIZE = 4;
        int CENTER_SIZE = 8;
        GuiUtil.draw3x3(x, y, width, height, sx, sy, 4, 8);
    }

    public static void draw3x3Stretched(int x, int y, int width, int height, int sx, int sy, int cornerSize, int centerSize) {
        int SHEET_SIZE = 256;
        int TILE_SIZE = cornerSize * 2 + centerSize;
        GuiUtil.drawStretchedTexturePart(x, y, cornerSize, cornerSize, sx, sy, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x + width - cornerSize, y, cornerSize, cornerSize, sx + TILE_SIZE - cornerSize, sy, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x, y + height - cornerSize, cornerSize, cornerSize, sx, sy + TILE_SIZE - cornerSize, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x + width - cornerSize, y + height - cornerSize, cornerSize, cornerSize, sx + TILE_SIZE - cornerSize, sy + TILE_SIZE - cornerSize, cornerSize, cornerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x + cornerSize, y, width - cornerSize * 2, cornerSize, sx + cornerSize, sy, centerSize, cornerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x + cornerSize, y + height - cornerSize, width - cornerSize * 2, cornerSize, sx + cornerSize, sy + TILE_SIZE - cornerSize, centerSize, cornerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x, y + cornerSize, cornerSize, height - cornerSize * 2, sx, sy + cornerSize, cornerSize, centerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x + width - cornerSize, y + cornerSize, cornerSize, height - cornerSize * 2, sx + TILE_SIZE - cornerSize, sy + cornerSize, cornerSize, centerSize, 256, 256);
        GuiUtil.drawStretchedTexturePart(x + cornerSize, y + cornerSize, width - cornerSize * 2, height - cornerSize * 2, sx + cornerSize, sy + cornerSize, centerSize, centerSize, 256, 256);
    }

    public static String translate(String key, Object ... args) {
        return new TextComponentTranslation(key, args).func_150254_d();
    }

    public static String translateConditional(boolean condition, String trueKey, String falseKey, Object ... args) {
        return new TextComponentTranslation(condition ? trueKey : falseKey, args).func_150254_d();
    }

    public static int getRealX(int x) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        return (int)((double)x / scaledresolution.func_78327_c() * (double)mc.field_71443_c);
    }

    public static int getRealWidth(int x) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        return (int)((double)x / scaledresolution.func_78327_c() * (double)mc.field_71443_c);
    }

    public static int getRealY(int y) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        return (int)((double)mc.field_71440_d - (double)y / scaledresolution.func_78324_d() * (double)mc.field_71440_d);
    }

    public static int getRealHeight(int y) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        return (int)((double)y / scaledresolution.func_78324_d() * (double)mc.field_71440_d);
    }

    public static String i18n(String key, Object ... variables) {
        return new TextComponentTranslation(key, variables).func_150254_d();
    }

    public static void drawItemStack(ItemStack stack, int x, int y, RenderItem itemRender, @Nullable FontRenderer fontRenderer) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        itemRender.field_77023_b = 100.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        RenderHelper.func_74520_c();
        itemRender.func_175042_a(stack, x, y);
        if (fontRenderer != null) {
            itemRender.func_180453_a(fontRenderer, stack, x, y, null);
        }
        RenderHelper.func_74518_a();
        itemRender.field_77023_b = 0.0f;
    }

    public static void playSound(SoundEvent soundEvent) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)soundEvent, (float)1.0f));
    }

    public static void playSound(Minecraft mc, SoundEvent soundEvent) {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)soundEvent, (float)1.0f));
    }

    public static void playSound(Minecraft mc, SoundEvent soundEvent, float pitch) {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)soundEvent, (float)pitch));
    }
}

