/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.gui;

import com.mike_caron.mikesmodslib.gui.GuiSized;
import com.mike_caron.mikesmodslib.gui.GuiTextBox;
import java.util.EventListener;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiTextField;

public class GuiWrappedTextBox
extends GuiSized {
    String currentText = "";
    private GuiTextField textField;
    private String tempText = null;
    private int tempCursorPosition = -1;

    @Override
    public void update() {
        if (this.textField != null) {
            this.textField.func_146178_a();
        }
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        String newText;
        if (!this.enabled || !this.visible) {
            return;
        }
        boolean focused = this.textField.func_146206_l();
        this.textField.func_146192_a(mouseX, mouseY, button);
        if (!focused && this.textField.func_146206_l()) {
            if (!this.parent.notifyTakeFocus(this)) {
                this.textField.func_146195_b(false);
            }
        } else if (focused && !this.textField.func_146206_l() && !(newText = this.textField.func_146179_b()).equals(this.currentText)) {
            this.currentText = newText;
            this.triggerChangedEvent();
        }
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
    }

    public GuiWrappedTextBox(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.textField == null) {
            this.createTextField();
        }
        this.textField.func_146194_f();
    }

    public int getCursorPosition() {
        if (this.textField != null) {
            return this.textField.func_146198_h();
        }
        return this.tempCursorPosition;
    }

    public void setCursorPosition(int pos) {
        if (this.textField != null) {
            this.textField.func_146190_e(pos);
        } else {
            this.tempCursorPosition = pos;
        }
    }

    public void setText(@Nonnull String text) {
        if (this.textField != null) {
            this.textField.func_146180_a(text);
        } else {
            this.tempText = text;
        }
    }

    public String getText() {
        if (this.textField != null) {
            return this.textField.func_146179_b();
        }
        return this.tempText;
    }

    @Override
    public boolean canHaveFocus() {
        return this.isEnabled();
    }

    @Override
    public boolean hasFocus() {
        if (this.textField != null) {
            return this.textField.func_146206_l();
        }
        return false;
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.textField != null) {
            String newText;
            boolean isFocused = this.textField.func_146206_l();
            this.textField.func_146195_b(focused);
            if (isFocused && !focused && !(newText = this.textField.func_146179_b()).equals(this.currentText)) {
                this.currentText = newText;
                this.triggerChangedEvent();
            }
        }
    }

    @Override
    public void onKeyTyped(char typedChar, int keyCode) {
        if (this.textField == null) {
            this.createTextField();
        }
        this.textField.func_146201_a(typedChar, keyCode);
    }

    private void createTextField() {
        if (this.textField != null) {
            this.tempText = this.textField.func_146179_b();
        }
        this.textField = new GuiTextField(1, this.parent.getFontRenderer(), 0, 0, this.width, this.height);
        this.textField.func_146205_d(true);
        if (this.tempText != null) {
            this.textField.func_146180_a(this.tempText);
            this.tempText = null;
        }
        if (this.tempCursorPosition != -1) {
            this.textField.func_146190_e(this.tempCursorPosition);
            this.tempCursorPosition = -1;
        }
    }

    private void triggerChangedEvent() {
        GuiTextBox.ChangedEvent evt = new GuiTextBox.ChangedEvent(this);
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof GuiTextBox.TextboxListener)) continue;
            ((GuiTextBox.TextboxListener)listener).changed(evt);
        }
    }

    public void addTextboxListener(GuiTextBox.TextboxListener listener) {
        this.listeners.add(listener);
    }

    public void removeTextboxListener(GuiTextBox.TextboxListener listener) {
        this.listeners.remove(listener);
    }
}

