/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.inventory;

import com.google.common.base.Preconditions;
import com.mike_caron.mikesmodslib.inventory.GenericInventory;
import com.mike_caron.mikesmodslib.util.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemInventory
extends GenericInventory {
    public static final String TAG_INVENTORY = "inventory";
    @Nonnull
    protected ItemStack containerStack;

    public ItemInventory(@Nonnull ItemStack containerStack, int size) {
        super("", false, size);
        Preconditions.checkNotNull((Object)containerStack);
        this.containerStack = containerStack;
        NBTTagCompound tag = ItemUtils.getItemTag(containerStack);
        this.readFromNBT(ItemInventory.getInventoryTag(tag));
    }

    @Override
    public void onInventoryChanged(int slotNumber) {
        super.onInventoryChanged(slotNumber);
        NBTTagCompound tag = ItemUtils.getItemTag(this.containerStack);
        NBTTagCompound inventoryTag = ItemInventory.getInventoryTag(tag);
        this.writeToNBT(inventoryTag);
        tag.func_74782_a(TAG_INVENTORY, (NBTBase)inventoryTag);
        this.containerStack.func_77982_d(tag);
    }

    public static NBTTagCompound getInventoryTag(NBTTagCompound tag) {
        return tag.func_74775_l(TAG_INVENTORY);
    }
}

