/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.network;

import com.mike_caron.mikesmodslib.Mod;
import com.mike_caron.mikesmodslib.block.TileEntityBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CtoSMessage
implements IMessage {
    private int dim;
    private BlockPos pos;
    private KindEnum kind;
    private int guiElement;
    private String theString;
    private boolean theBoolean;
    private String extraData;

    public static CtoSMessage forGuiButton(int dim, BlockPos pos, int guiElement, String extraData) {
        CtoSMessage ret = new CtoSMessage();
        ret.kind = KindEnum.GuiButton;
        ret.dim = dim;
        ret.pos = pos;
        ret.guiElement = guiElement;
        ret.extraData = extraData;
        return ret;
    }

    public static CtoSMessage forGuiButton(int dim, BlockPos pos, int guiElement) {
        return CtoSMessage.forGuiButton(dim, pos, guiElement, null);
    }

    public static CtoSMessage forGuiString(int dim, BlockPos pos, int guiElement, String string) {
        CtoSMessage ret = new CtoSMessage();
        ret.kind = KindEnum.GuiString;
        ret.dim = dim;
        ret.pos = pos;
        ret.guiElement = guiElement;
        ret.theString = string;
        return ret;
    }

    public static CtoSMessage forGuiToggle(int dim, BlockPos pos, int guiElement, boolean bool) {
        CtoSMessage ret = new CtoSMessage();
        ret.kind = KindEnum.GuiToggle;
        ret.dim = dim;
        ret.pos = pos;
        ret.guiElement = guiElement;
        ret.theBoolean = bool;
        return ret;
    }

    public void fromBytes(ByteBuf buf) {
        int o = buf.readInt();
        this.kind = KindEnum.values()[o];
        this.dim = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        switch (this.kind) {
            case GuiButton: {
                this.guiElement = buf.readInt();
                this.extraData = CtoSMessage.readString(buf);
                break;
            }
            case GuiString: {
                this.guiElement = buf.readInt();
                this.theString = CtoSMessage.readString(buf);
                break;
            }
            case GuiToggle: {
                this.guiElement = buf.readInt();
                this.theBoolean = buf.readBoolean();
                break;
            }
            default: {
                throw new RuntimeException("What the? What kind of kind is " + (Object)((Object)this.kind));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.kind.ordinal());
        buf.writeInt(this.dim);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        switch (this.kind) {
            case GuiButton: {
                buf.writeInt(this.guiElement);
                CtoSMessage.writeString(buf, this.extraData);
                break;
            }
            case GuiString: {
                buf.writeInt(this.guiElement);
                CtoSMessage.writeString(buf, this.theString);
                break;
            }
            case GuiToggle: {
                buf.writeInt(this.guiElement);
                buf.writeBoolean(this.theBoolean);
                break;
            }
            default: {
                throw new RuntimeException("What the? What kind of kind is " + (Object)((Object)this.kind));
            }
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getGuiElement() {
        return this.guiElement;
    }

    public String getString() {
        return this.theString;
    }

    public KindEnum getKind() {
        return this.kind;
    }

    public boolean getBoolean() {
        return this.theBoolean;
    }

    public String getExtraData() {
        return this.extraData;
    }

    private static String readString(ByteBuf byteBuf) {
        return ByteBufUtils.readUTF8String((ByteBuf)byteBuf);
    }

    private static void writeString(ByteBuf byteBuf, String string) {
        if (string == null) {
            string = "";
        }
        ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)string);
    }

    public static class Handler
    implements IMessageHandler<CtoSMessage, IMessage> {
        public IMessage onMessage(CtoSMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            world.func_152344_a(() -> {
                try {
                    if (world.func_175667_e(message.getPos())) {
                        TileEntity te = world.func_175625_s(message.getPos());
                        if (!(te instanceof TileEntityBase) || !((TileEntityBase)te).canInteractWith((EntityPlayer)player)) {
                            return;
                        }
                        switch (message.getKind()) {
                            case GuiButton: {
                                TileEntityBase teb = (TileEntityBase)te;
                                teb.handleGuiButton(player, message.getGuiElement(), message.getExtraData());
                                break;
                            }
                            case GuiString: {
                                TileEntityBase teb = (TileEntityBase)te;
                                teb.handleGuiString(player, message.getGuiElement(), message.getString());
                            }
                            case GuiToggle: {
                                TileEntityBase teb = (TileEntityBase)te;
                                teb.handleGuiToggle(player, message.getGuiElement(), message.getBoolean());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Mod.logger.error("Error while handling message", (Throwable)e);
                }
            });
            return null;
        }
    }

    public static enum KindEnum {
        Unknown,
        GuiButton,
        GuiString,
        GuiToggle;

    }
}

