/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.recipes.specific;

import com.google.gson.JsonObject;
import com.mike_caron.mikesmodslib.recipes.specific.RecipeUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class FluidRecipe
extends ShapedOreRecipe {
    public FluidRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    @Nullable
    private FluidStack getFluidFromItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return null;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack ret = null;
        if (fluidHandler instanceof FluidHandlerItemStack) {
            ret = ((FluidHandlerItemStack)fluidHandler).getFluid();
        }
        if (fluidHandler instanceof FluidHandlerItemStackSimple) {
            ret = ((FluidHandlerItemStackSimple)fluidHandler).getFluid();
        }
        if (ret == null) {
            for (IFluidTankProperties prop : fluidHandler.getTankProperties()) {
                if (!prop.canDrain()) continue;
                ret = prop.getContents();
            }
        }
        if (ret != null) {
            ret = ret.copy();
        }
        return ret;
    }

    private boolean fluidMatches(@Nonnull FluidStack fluid, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return false;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack drained = fluidHandler.drain(fluid, false);
        return drained != null && drained.getFluid() == fluid.getFluid() && drained.amount == fluid.amount;
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        NonNullList ingredients = this.func_192400_c();
        if (inventoryCrafting.func_70302_i_() != ingredients.size()) {
            return false;
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ing = (Ingredient)ingredients.get(i);
            ItemStack ingredientStack = ing.func_193365_a()[0];
            FluidStack desiredFluid = this.getFluidFromItem(ingredientStack);
            ItemStack stack = inventoryCrafting.func_70301_a(i);
            if (!(desiredFluid != null ? !this.fluidMatches(desiredFluid, stack) : !ing.apply(stack))) continue;
            return false;
        }
        return true;
    }

    private String toString(Ingredient ing) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (ItemStack s : ing.func_193365_a()) {
            if (first) {
                first = false;
            } else {
                ret.append(",");
            }
            ret.append(s);
        }
        return ret.toString();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList ingredients = this.func_192400_c();
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Ingredient ing = (Ingredient)ingredients.get(i);
            ItemStack ingredientStack = ing.func_193365_a()[0];
            FluidStack desiredFluid = this.getFluidFromItem(ingredientStack);
            if (desiredFluid != null) {
                if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                FluidStack drained = fluidHandler.drain(desiredFluid, true);
                nonnulllist.set(i, (Object)fluidHandler.getContainer().func_77946_l());
                continue;
            }
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return nonnulllist;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext jsonContext, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            CraftingHelper.ShapedPrimer primer = RecipeUtil.parseShaped(jsonContext, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)jsonContext);
            return new FluidRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
        }
    }
}

