/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mike_caron.mikesmodslib.util.ItemUtils;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.math.Fraction;

public class DataUtils {
    private DataUtils() {
    }

    @Nonnull
    public static Integer[] box(@Nonnull int[] array) {
        return (Integer[])IntStream.of(array).boxed().toArray(Integer[]::new);
    }

    @Nonnull
    public static Float[] box(@Nonnull float[] array) {
        Float[] ret = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = Float.valueOf(array[i]);
        }
        return ret;
    }

    @Nonnull
    public static int[] unbox(@Nonnull Integer[] array) {
        return Stream.of(array).mapToInt(Integer::intValue).toArray();
    }

    @Nonnull
    public static float[] unbox(@Nonnull Float[] array) {
        float[] ret = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = array[i].floatValue();
        }
        return ret;
    }

    public static NBTBase toNBT(Fraction fraction) {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74768_a("N", fraction.getNumerator());
        ret.func_74768_a("D", fraction.getDenominator());
        return ret;
    }

    public static Fraction fraction(NBTBase tag) {
        NBTTagCompound data = (NBTTagCompound)tag;
        return Fraction.getFraction((int)data.func_74762_e("N"), (int)data.func_74762_e("D"));
    }

    public static boolean areEqual(Fraction a, Fraction b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return a.equals((Object)b);
    }

    @Nonnull
    public static JsonElement toJson(@Nonnull NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            JsonObject ret = new JsonObject();
            for (String key : ((NBTTagCompound)nbt).func_150296_c()) {
                ret.add(key, DataUtils.toJson(((NBTTagCompound)nbt).func_74781_a(key)));
            }
            return ret;
        }
        if (nbt instanceof NBTTagList) {
            JsonArray ret = new JsonArray();
            for (int i = 0; i < ((NBTTagList)nbt).func_74745_c(); ++i) {
                ret.add(DataUtils.toJson(((NBTTagList)nbt).func_179238_g(i)));
            }
            return ret;
        }
        if (nbt instanceof NBTTagInt) {
            return new JsonPrimitive((Number)((NBTTagInt)nbt).func_150287_d());
        }
        if (nbt instanceof NBTTagShort) {
            return new JsonPrimitive((Number)((NBTTagShort)nbt).func_150287_d());
        }
        if (nbt instanceof NBTTagByte) {
            return new JsonPrimitive((Number)((NBTTagByte)nbt).func_150287_d());
        }
        if (nbt instanceof NBTTagDouble) {
            return new JsonPrimitive((Number)((NBTTagDouble)nbt).func_150286_g());
        }
        if (nbt instanceof NBTTagFloat) {
            return new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)nbt).func_150288_h()));
        }
        if (nbt instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)nbt).func_150285_a_());
        }
        throw new RuntimeException("I don't know how to convert NBT " + nbt.toString() + " to Json");
    }

    public static NBTBase toNBT(JsonElement el) {
        if (el == null || el.isJsonNull()) {
            throw new RuntimeException("NBT Tags may not be null");
        }
        if (el.isJsonPrimitive()) {
            JsonPrimitive prim = el.getAsJsonPrimitive();
            if (prim.isString()) {
                return new NBTTagString(prim.getAsString());
            }
            if (prim.isNumber()) {
                if (prim.getAsDouble() != Math.floor(prim.getAsDouble())) {
                    return new NBTTagDouble(prim.getAsDouble());
                }
                return new NBTTagInt(prim.getAsInt());
            }
            if (prim.isBoolean()) {
                return new NBTTagByte((byte)(prim.getAsBoolean() ? 1 : 0));
            }
            throw new RuntimeException("Unknown type of Json primitive");
        }
        if (el.isJsonObject()) {
            NBTTagCompound ret = new NBTTagCompound();
            for (Map.Entry kvp : el.getAsJsonObject().entrySet()) {
                ret.func_74782_a((String)kvp.getKey(), DataUtils.toNBT((JsonElement)kvp.getValue()));
            }
            return ret;
        }
        if (el.isJsonArray()) {
            NBTTagList ret = new NBTTagList();
            el.getAsJsonArray().forEach(itm -> ret.func_74742_a(DataUtils.toNBT(itm)));
            return ret;
        }
        throw new RuntimeException("Unknown type of Json");
    }

    public static NBTTagCompound toNBT(JsonObject el) {
        return (NBTTagCompound)DataUtils.toNBT((JsonElement)el);
    }

    public static NBTTagList toNBT(JsonArray el) {
        return (NBTTagList)DataUtils.toNBT((JsonElement)el);
    }

    @Nonnull
    public static JsonObject toJson(@Nonnull ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77955_b(tag);
        JsonObject ret = new JsonObject();
        ret.addProperty("item", tag.func_74779_i("id"));
        ret.addProperty("qty", (Number)tag.func_74771_c("Count"));
        ret.addProperty("meta", (Number)tag.func_74765_d("Damage"));
        if (tag.func_74764_b("tag")) {
            ret.add("tag", DataUtils.toJson(tag.func_74781_a("tag")));
        }
        if (tag.func_74764_b("ForgeCaps")) {
            ret.add("forge", DataUtils.toJson(tag.func_74781_a("ForgeCaps")));
        }
        return ret;
    }

    public static ItemStack toItemStack(@Nonnull JsonObject obj) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(obj.get("item").getAsString()));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = new ItemStack(item, 1, 0, null);
        if (obj.has("qty")) {
            ret.func_190920_e(obj.get("qty").getAsInt());
        }
        if (obj.has("meta")) {
            ret.func_77964_b(obj.get("meta").getAsInt());
        }
        if (obj.has("tag")) {
            ret.func_77982_d(DataUtils.toNBT(obj.get("tag").getAsJsonObject()));
        }
        return ret;
    }

    @Nonnull
    public static JsonElement resolveConstants(@Nonnull JsonElement value, @Nonnull Map<String, JsonElement> constants) {
        if (value.isJsonNull()) {
            return value;
        }
        if (value.isJsonPrimitive()) {
            String key;
            JsonPrimitive prim = value.getAsJsonPrimitive();
            if (prim.isString() && prim.getAsString().startsWith("#") && constants.containsKey(key = prim.getAsString().substring(1))) {
                return DataUtils.resolveConstants(constants.get(key), constants);
            }
            return value;
        }
        if (value.isJsonArray()) {
            JsonArray ret = new JsonArray();
            boolean changed = false;
            for (JsonElement el : value.getAsJsonArray()) {
                JsonElement res = DataUtils.resolveConstants(el, constants);
                if (res != el) {
                    changed = true;
                }
                ret.add(res);
            }
            if (!changed) {
                return value;
            }
            return ret;
        }
        if (value.isJsonObject()) {
            JsonObject ret = new JsonObject();
            boolean changed = false;
            for (Map.Entry kvp : value.getAsJsonObject().entrySet()) {
                JsonElement res = DataUtils.resolveConstants((JsonElement)kvp.getValue(), constants);
                if (res != kvp.getValue()) {
                    changed = true;
                }
                ret.add((String)kvp.getKey(), res);
            }
            if (!changed) {
                return value;
            }
            return ret;
        }
        throw new Error("This can't happen");
    }

    public static JsonElement cloneJson(JsonElement obj) {
        if (obj.isJsonNull()) {
            return obj;
        }
        if (obj.isJsonPrimitive()) {
            JsonPrimitive prim = obj.getAsJsonPrimitive();
            if (prim.isString()) {
                return new JsonPrimitive(prim.getAsString());
            }
            if (prim.isNumber()) {
                return new JsonPrimitive(prim.getAsNumber());
            }
            return new JsonPrimitive(Boolean.valueOf(prim.getAsBoolean()));
        }
        if (obj.isJsonArray()) {
            JsonArray ret = new JsonArray();
            for (JsonElement el : obj.getAsJsonArray()) {
                ret.add(DataUtils.cloneJson(el));
            }
            return ret;
        }
        if (obj.isJsonObject()) {
            JsonObject ret = new JsonObject();
            for (Map.Entry kvp : obj.getAsJsonObject().entrySet()) {
                ret.add((String)kvp.getKey(), DataUtils.cloneJson((JsonElement)kvp.getValue()));
            }
            return ret;
        }
        throw new Error("This can't happen");
    }

    public static JsonElement mergeJson(JsonElement newElement, JsonElement existingElement) {
        if (existingElement.getClass() != newElement.getClass()) {
            throw new JsonIOException("The element types do not match: " + existingElement.getClass() + " vs " + newElement.getClass());
        }
        if (existingElement.isJsonPrimitive() || existingElement.isJsonNull()) {
            return newElement;
        }
        if (existingElement.isJsonObject()) {
            JsonObject ret = DataUtils.cloneJson(existingElement).getAsJsonObject();
            for (Map.Entry kvp : newElement.getAsJsonObject().entrySet()) {
                ret.add((String)kvp.getKey(), DataUtils.cloneJson((JsonElement)kvp.getValue()));
            }
            return ret;
        }
        if (existingElement.isJsonArray()) {
            JsonArray ret = DataUtils.cloneJson(existingElement).getAsJsonArray();
            for (JsonElement el : newElement.getAsJsonArray()) {
                ret.add(DataUtils.cloneJson(el));
            }
            return ret;
        }
        throw new Error("This can't happen");
    }

    @Nonnull
    public static String[][] loadJsonNestedArray(@Nonnull JsonElement element) {
        String[][] ret;
        if (element.isJsonPrimitive()) {
            ret = new String[][]{{element.getAsJsonPrimitive().getAsString()}};
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ret = new String[array.size()][];
            for (int i = 0; i < array.size(); ++i) {
                JsonElement el = array.get(i);
                if (el.isJsonPrimitive()) {
                    ret[i] = new String[]{el.getAsJsonPrimitive().getAsString()};
                    continue;
                }
                if (el.isJsonArray()) {
                    JsonArray array2 = el.getAsJsonArray();
                    ret[i] = new String[array2.size()];
                    for (int j = 0; j < array2.size(); ++j) {
                        ret[i][j] = array2.get(j).getAsJsonPrimitive().getAsString();
                    }
                    continue;
                }
                if (el.isJsonNull()) continue;
                throw new RuntimeException("This is not a string or array: " + el);
            }
        } else {
            throw new RuntimeException("This is not a string or array: " + element);
        }
        return ret;
    }

    @Nonnull
    public static String[] loadJsonArray(@Nonnull JsonElement element) {
        String[] ret;
        if (element.isJsonPrimitive()) {
            ret = new String[]{element.getAsJsonPrimitive().getAsString()};
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ret = new String[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                JsonElement el = array.get(i);
                ret[i] = el.getAsJsonPrimitive().getAsString();
            }
        } else {
            throw new RuntimeException("This is not a string or array: " + element);
        }
        return ret;
    }

    public static JsonElement serializeJson(Object obj) {
        if (obj instanceof ItemStack) {
            return DataUtils.serializeJson(ItemUtils.getTagFromStack((ItemStack)obj));
        }
        Gson gson = new Gson();
        return gson.toJsonTree(obj);
    }
}

