/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidUtils {
    public static boolean fillPlayerHandWithFluid(World world, BlockPos pos, EntityPlayer player, IFluidHandler fluidHandler) {
        if (fluidHandler == null) {
            return false;
        }
        ItemStack inHand = player.field_71071_by.func_70448_g().func_77946_l();
        ItemStack theRest = null;
        if (inHand.func_190916_E() > 1 && player.field_71071_by.func_70447_i() != -1) {
            theRest = inHand.func_77979_a(inHand.func_190916_E() - 1);
        }
        if (inHand.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem container = (IFluidHandlerItem)inHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            for (IFluidTankProperties prop : fluidHandler.getTankProperties()) {
                FluidStack drained;
                int filled;
                if (!prop.canDrain()) continue;
                boolean good = false;
                for (IFluidTankProperties cprop : container.getTankProperties()) {
                    if (!cprop.canFillFluidType(prop.getContents())) continue;
                    good = true;
                    break;
                }
                if (!good || (filled = container.fill(prop.getContents(), false)) == 0 || (drained = fluidHandler.drain(filled, false)) == null || drained.amount == 0) continue;
                drained = fluidHandler.drain(drained.amount, true);
                filled = container.fill(drained, true);
                if (theRest != null) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, theRest);
                    player.field_71071_by.func_70441_a(container.getContainer());
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, container.getContainer());
                }
                return true;
            }
        }
        return false;
    }

    public static boolean drainPlayerHandOfFluid(World world, BlockPos pos, EntityPlayer player, IFluidHandler fluidHandler) {
        if (fluidHandler == null) {
            return false;
        }
        ItemStack inHand = player.field_71071_by.func_70448_g();
        if (inHand.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem container = (IFluidHandlerItem)inHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            for (IFluidTankProperties prop : fluidHandler.getTankProperties()) {
                if (!prop.canFill()) continue;
                boolean good = false;
                for (IFluidTankProperties cprop : container.getTankProperties()) {
                    FluidStack drained;
                    int filled;
                    if (!prop.canFillFluidType(cprop.getContents()) || (filled = fluidHandler.fill(cprop.getContents(), false)) == 0 || (drained = container.drain(filled, false)) == null || drained.amount == 0) continue;
                    drained = container.drain(drained.amount, true);
                    filled = fluidHandler.fill(drained, true);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, container.getContainer());
                    return true;
                }
            }
        }
        return false;
    }
}

