/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.util;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.IItemHandler;

public class ItemUtils {
    @GameRegistry.ItemStackHolder(value="minecraft:clock")
    public static ItemStack CLOCK;
    public static final Pattern leadingCount;

    @Nonnull
    public static ItemStack getStackFromTag(String tag) {
        try {
            int count = 1;
            Matcher res = leadingCount.matcher(tag);
            while (res.find()) {
                count = Integer.parseInt(res.group(1));
                tag = tag.substring(res.end());
            }
            String[] parts = tag.split(":");
            if (parts.length == 1) {
                Item item = Item.func_111206_d((String)parts[0]);
                Preconditions.checkNotNull((Object)item);
                return new ItemStack(item, count);
            }
            if (parts.length == 2) {
                Item item = Item.func_111206_d((String)tag);
                if (item != null) {
                    return new ItemStack(item, count);
                }
                int meta = parts[1].equals("*") ? Short.MAX_VALUE : Integer.parseInt(parts[1]);
                item = Item.func_111206_d((String)("minecraft:" + parts[0]));
                Preconditions.checkNotNull((Object)item);
                return new ItemStack(item, count, meta);
            }
            if (parts.length == 3) {
                int meta = parts[2].equals("*") ? Short.MAX_VALUE : Integer.parseInt(parts[2]);
                Item item = Item.func_111206_d((String)(parts[0] + ":" + parts[1]));
                Preconditions.checkNotNull((Object)item, (Object)("Can't locate the item " + tag));
                return new ItemStack(item, count, meta);
            }
        }
        catch (NullPointerException count) {
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Can't locate the item " + tag, ex);
        }
        throw new RuntimeException("I don't understand the item " + tag);
    }

    @Nonnull
    public static Item getItemFromTag(String tag) {
        try {
            Item item = Item.func_111206_d((String)tag);
            Preconditions.checkNotNull((Object)item);
            return item;
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("I don't understand the item " + tag);
        }
    }

    @Nonnull
    public static String getTagFromItem(@Nonnull Item item) {
        ResourceLocation res = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        Preconditions.checkNotNull((Object)res);
        if (res.func_110624_b().equals("minecraft")) {
            return res.func_110623_a();
        }
        return res.toString();
    }

    public static String getTagFromStack(ItemStack stack) {
        StringBuilder ret = new StringBuilder();
        ret.append(stack.func_77973_b().getRegistryName().toString());
        if (stack.func_77960_j() != 0) {
            ret.append(":");
            ret.append(stack.func_77960_j());
        }
        return ret.toString();
    }

    public static boolean areEqual(@Nullable NonNullList<ItemStack> a, @Nullable NonNullList<ItemStack> b) {
        if (a == b) {
            return true;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            ItemStack bi;
            ItemStack ai = (ItemStack)a.get(i);
            if (ai.func_77969_a(bi = (ItemStack)b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void giveToPlayerOrDrop(@Nonnull ItemStack itemStack, @Nonnull EntityPlayer player) {
        ItemStack newStack = itemStack.func_77946_l();
        if (!player.field_71071_by.func_70441_a(newStack)) {
            ItemUtils.dropItem(player.func_130014_f_(), newStack, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
    }

    public static void dropItem(@Nonnull World world, @Nonnull ItemStack itemStack, double x, double y, double z) {
        EntityItem item = new EntityItem(world, x, y, z, itemStack);
        world.func_72838_d((Entity)item);
    }

    @Nonnull
    public static ItemStack insertItemIfPossible(@Nonnull ItemStack itemStack, @Nonnull IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack ret;
            if (!itemHandler.isItemValid(i, itemStack) || (ret = itemHandler.insertItem(i, itemStack, true)) == itemStack) continue;
            ret = itemHandler.insertItem(i, itemStack, false);
            return ret;
        }
        return itemStack;
    }

    @Nonnull
    public static NBTTagCompound getItemTag(@Nonnull ItemStack stack) {
        NBTTagCompound ret = stack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            stack.func_77982_d(ret);
        }
        return ret;
    }

    static {
        leadingCount = Pattern.compile("^(\\d+)x");
    }
}

