/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.util;

import com.mike_caron.mikesmodslib.block.BlockBase;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MultiblockUtil {
    private MultiblockUtil() {
    }

    public static BlockPos walkMultiblock(@Nonnull World world, @Nonnull BlockPos start, Class<? extends BlockBase> medium, BiFunction<IBlockState, BlockPos, Boolean> shouldStop) {
        return MultiblockUtil.walkMultiblock(world, start, (IBlockState blockState, BlockPos pos) -> medium.isInstance(blockState.func_177230_c()), shouldStop);
    }

    public static BlockPos walkMultiblock(@Nonnull World world, @Nonnull BlockPos start, BiFunction<IBlockState, BlockPos, Boolean> shouldEnter, BiFunction<IBlockState, BlockPos, Boolean> shouldStop) {
        HashSet<Long> explored = new HashSet<Long>();
        PriorityQueue<DistPos> toExplore = new PriorityQueue<DistPos>(DistPos::compare);
        toExplore.add(new DistPos(start, 0));
        while (!toExplore.isEmpty()) {
            DistPos spot = (DistPos)((Object)toExplore.remove());
            IBlockState block = world.func_180495_p((BlockPos)spot);
            if (!shouldEnter.apply(block, spot).booleanValue()) continue;
            if (shouldStop.apply(block, spot).booleanValue()) {
                return spot;
            }
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                DistPos newPos = spot.offset(dir);
                if (explored.contains(newPos.func_177986_g())) continue;
                explored.add(newPos.func_177986_g());
                toExplore.add(spot.offset(dir));
            }
        }
        return null;
    }

    private static class DistPos
    extends BlockPos {
        public final int dist;

        DistPos(BlockPos pos, int distance) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.dist = distance;
        }

        public static int compare(DistPos a, DistPos b) {
            int ret = b.dist - a.dist;
            if (ret != 0) {
                return ret;
            }
            return a.compareTo((Vec3i)b);
        }

        @Nonnull
        public DistPos offset(@Nonnull EnumFacing facing) {
            return new DistPos(super.func_177972_a(facing), this.dist + 1);
        }
    }
}

