/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.mikesmodslib.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class TileEntityProxy<T extends TileEntity>
implements INBTSerializable<NBTTagCompound> {
    BlockPos pos;
    int lastCheck = 0;

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        if (this.pos != null) {
            ret.func_74768_a("x", this.pos.func_177958_n());
            ret.func_74768_a("y", this.pos.func_177956_o());
            ret.func_74768_a("z", this.pos.func_177952_p());
        }
        return ret;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("x") && compound.func_74764_b("y") && compound.func_74764_b("z")) {
            int x = compound.func_74762_e("x");
            int y = compound.func_74762_e("y");
            int z = compound.func_74762_e("z");
            this.pos = new BlockPos(x, y, z);
        } else {
            this.pos = null;
        }
    }

    @Nullable
    public T getTileEntity(@Nonnull World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (this.pos != null) {
            TileEntity ret = world.func_175625_s(this.pos);
            if (ret != null) {
                try {
                    return (T)ret;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.pos = this.findTileEntity();
            this.markDirty();
            if (this.pos != null) {
                return this.getTileEntity(world);
            }
        }
        ++this.lastCheck;
        if (this.lastCheck >= 20) {
            this.lastCheck = 0;
            BlockPos p = this.findTileEntity();
            if (p != null) {
                this.pos = p;
                this.markDirty();
            }
            return this.getTileEntity(world);
        }
        return null;
    }

    public boolean isValid() {
        return this.pos != null;
    }

    @Nullable
    protected abstract BlockPos findTileEntity();

    protected void markDirty() {
    }

    public void invalidate() {
        BlockPos newPos = this.findTileEntity();
        if (!TileEntityProxy.areEqual(this.pos, newPos)) {
            this.pos = newPos;
            this.markDirty();
        }
    }

    private static boolean areEqual(BlockPos a, BlockPos b) {
        if (a == null && b == null) {
            return false;
        }
        if (a != null) {
            return a.equals((Object)b);
        }
        return false;
    }
}

