/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.apiimp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.intwheel.InteractionWheel;
import mcjty.intwheel.api.IInteractionWheel;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.IWheelActionProvider;
import mcjty.intwheel.api.IWheelActionRegistry;
import mcjty.intwheel.playerdata.PlayerProperties;
import mcjty.intwheel.playerdata.PlayerWheelConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class InteractionWheelImp
implements IInteractionWheel {
    private List<IWheelActionProvider> providers = new ArrayList<IWheelActionProvider>();

    private int findProvider(String id) {
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!id.equals(this.providers.get(i).getID())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void registerProvider(IWheelActionProvider provider) {
        int idx = this.findProvider(provider.getID());
        if (idx != -1) {
            this.providers.set(idx, provider);
        } else {
            this.providers.add(provider);
        }
    }

    public List<IWheelActionProvider> getProviders() {
        return this.providers;
    }

    private IWheelActionProvider getProviderByID(String id) {
        for (IWheelActionProvider provider : this.providers) {
            if (!provider.getID().equals(id)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public IWheelActionRegistry getRegistry() {
        return InteractionWheel.registry;
    }

    public List<String> getSortedActions(@Nonnull EntityPlayer player) {
        PlayerWheelConfiguration config = PlayerProperties.getWheelConfig(player);
        ArrayList<String> orderedActions = new ArrayList<String>(config.getOrderedActions());
        for (String id : InteractionWheel.registry.getRegistrationOrder()) {
            if (orderedActions.contains(id)) continue;
            orderedActions.add(id);
        }
        ArrayList<String> valid = new ArrayList<String>();
        for (String action : orderedActions) {
            if (InteractionWheel.registry.get(action) == null) continue;
            valid.add(action);
        }
        return valid;
    }

    @Nonnull
    public List<String> getActions(@Nonnull EntityPlayer player, World world, @Nullable BlockPos pos) {
        HashSet<String> actions = new HashSet<String>();
        for (IWheelActionProvider provider : this.providers) {
            try {
                provider.updateWheelActions(actions, player, world, pos);
            }
            catch (Exception e) {
                InteractionWheel.logger.log(Level.ERROR, "The provider " + provider.getID() + " caused a crash!", (Throwable)e);
            }
        }
        PlayerWheelConfiguration config = PlayerProperties.getWheelConfig(player);
        ArrayList<String> newactions = new ArrayList<String>();
        for (String id : this.getSortedActions(player)) {
            if (!actions.contains(id)) continue;
            Boolean enabled = config.isEnabled(id);
            if (enabled == null) {
                IWheelAction action = InteractionWheel.registry.get(id);
                enabled = action == null ? Boolean.FALSE : Boolean.valueOf(action.isDefaultEnabled());
            }
            if (!enabled.booleanValue()) continue;
            newactions.add(id);
        }
        return newactions;
    }
}

