/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.gui;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import mcjty.intwheel.InteractionWheel;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.WheelActionElement;
import mcjty.intwheel.playerdata.PlayerProperties;
import mcjty.intwheel.playerdata.PlayerWheelConfiguration;
import mcjty.intwheel.varia.RenderHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiWheelConfig
extends GuiScreen {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 204;
    public static final int MARGIN = 4;
    public static final int SIZE = 30;
    private int guiLeft;
    private int guiTop;
    private static final ResourceLocation background = new ResourceLocation("intwheel", "textures/gui/wheel_config.png");

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 204) / 2;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int cx = mouseX - this.guiLeft;
        int cy = mouseY - this.guiTop;
        String id = this.getSelectedActionID(cx, cy);
        if (id != null) {
            PlayerWheelConfiguration config = PlayerProperties.getWheelConfig((EntityPlayer)this.field_146297_k.field_71439_g);
            if (keyCode == 203) {
                List<String> actions = InteractionWheel.interactionWheelImp.getSortedActions((EntityPlayer)this.field_146297_k.field_71439_g);
                int idx = actions.indexOf(id);
                if (idx > 0) {
                    String idprev = actions.get(idx - 1);
                    actions.set(idx - 1, id);
                    actions.set(idx, idprev);
                    config.setOrderActions(actions);
                    config.sendToServer();
                }
            } else if (keyCode == 205) {
                List<String> actions = InteractionWheel.interactionWheelImp.getSortedActions((EntityPlayer)this.field_146297_k.field_71439_g);
                int idx = actions.indexOf(id);
                if (idx < actions.size() - 1) {
                    String idnext = actions.get(idx + 1);
                    actions.set(idx + 1, id);
                    actions.set(idx, idnext);
                    config.setOrderActions(actions);
                    config.sendToServer();
                }
            } else if (keyCode == 199) {
                List<String> actions = InteractionWheel.interactionWheelImp.getSortedActions((EntityPlayer)this.field_146297_k.field_71439_g);
                int idx = actions.indexOf(id);
                if (idx > 0) {
                    String idnext = actions.get(0);
                    actions.set(0, id);
                    actions.set(idx, idnext);
                    config.setOrderActions(actions);
                    config.sendToServer();
                }
            } else if (keyCode == 207) {
                List<String> actions = InteractionWheel.interactionWheelImp.getSortedActions((EntityPlayer)this.field_146297_k.field_71439_g);
                int idx = actions.indexOf(id);
                if (idx < actions.size() - 1) {
                    String idnext = actions.get(actions.size() - 1);
                    actions.set(actions.size() - 1, id);
                    actions.set(idx, idnext);
                    config.setOrderActions(actions);
                    config.sendToServer();
                }
            } else if (typedChar >= 'a' && typedChar <= 'z' || keyCode == 211 || keyCode == 14) {
                if (keyCode == 211 || keyCode == 14) {
                    config.getHotkeys().remove(id);
                } else {
                    config.getHotkeys().put(id, keyCode);
                }
                config.sendToServer();
            }
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int cx = mouseX - this.guiLeft;
        int cy = mouseY - this.guiTop;
        List<String> actions = InteractionWheel.interactionWheelImp.getSortedActions((EntityPlayer)this.field_146297_k.field_71439_g);
        int selected = this.getSelectedAction(cx, cy);
        if (selected >= 0 && selected < actions.size()) {
            PlayerWheelConfiguration config = PlayerProperties.getWheelConfig((EntityPlayer)this.field_146297_k.field_71439_g);
            String id = actions.get(selected);
            IWheelAction action = InteractionWheel.registry.get(id);
            if (action != null) {
                Boolean enabled = config.isEnabled(id);
                if (enabled == null) {
                    enabled = action.isDefaultEnabled();
                }
                if (enabled.booleanValue()) {
                    config.disable(id);
                } else {
                    config.enable(id);
                }
                config.sendToServer();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 204);
        this.drawIcons();
        int cx = mouseX - this.guiLeft;
        int cy = mouseY - this.guiTop;
        String id = this.getSelectedActionID(cx, cy);
        if (id != null) {
            this.drawTooltip(id);
        }
    }

    private void renderTooltipText(String desc, int dy) {
        int x = this.guiLeft + 5;
        int y = this.guiTop + 157 + 1 + dy;
        RenderHelper.renderText(this.field_146297_k, x, y, desc);
    }

    private void drawTooltip(String id) {
        IWheelAction action = InteractionWheel.registry.get(id);
        if (action != null) {
            WheelActionElement element = action.createElement();
            String desc = element.getDescription();
            this.renderTooltipText(TextFormatting.AQUA + id + ": " + TextFormatting.WHITE + desc, 0);
            this.renderTooltipText(TextFormatting.YELLOW + "Click to enable/disable this action", 10);
            this.renderTooltipText(TextFormatting.YELLOW + "Press 'a' to 'z' to assign hotkey ('del' to remove hotkey)", 20);
            this.renderTooltipText(TextFormatting.YELLOW + "Arrows and home/end to order actions", 30);
        }
    }

    private void drawIcons() {
        PlayerWheelConfiguration config = PlayerProperties.getWheelConfig((EntityPlayer)this.field_146297_k.field_71439_g);
        Map<String, Integer> hotkeys = config.getHotkeys();
        List<String> actions = InteractionWheel.interactionWheelImp.getSortedActions((EntityPlayer)this.field_146297_k.field_71439_g);
        int ox = 0;
        int oy = 0;
        for (String id : actions) {
            IWheelAction action = InteractionWheel.registry.get(id);
            WheelActionElement element = action.createElement();
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation(element.getTexture()));
            int txtw = element.getTxtw();
            int txth = element.getTxth();
            Boolean enabled = config.isEnabled(action.getId());
            if (enabled == null) {
                enabled = action.isDefaultEnabled();
            }
            int u = enabled != false ? element.getUhigh() : element.getUlow();
            int v = enabled != false ? element.getVhigh() : element.getVlow();
            RenderHelper.drawTexturedModalRect(this.guiLeft + ox * 30 + 4, this.guiTop + oy * 30 + 4, u, v, 31, 31, txtw, txth);
            if (hotkeys.containsKey(id)) {
                String keyName = Keyboard.getKeyName((int)hotkeys.get(id));
                RenderHelper.renderText(this.field_146297_k, this.guiLeft + ox * 30 + 4 + 1, this.guiTop + oy * 30 + 4 + 1, keyName);
            }
            if (++ox < 8) continue;
            ox = 0;
            ++oy;
        }
    }

    private int getSelectedAction(int cx, int cy) {
        if (cx < 4 || cy < 4) {
            return -1;
        }
        if (cx > 256 || cy > 256) {
            return -1;
        }
        int totw = 8;
        int i = (cx - 4) / 30 + totw * ((cy - 4) / 30);
        return i;
    }

    private String getSelectedActionID(int cx, int cy) {
        List<String> actions = InteractionWheel.interactionWheelImp.getSortedActions((EntityPlayer)this.field_146297_k.field_71439_g);
        int selected = this.getSelectedAction(cx, cy);
        if (selected >= 0 && selected < actions.size()) {
            return actions.get(selected);
        }
        return null;
    }
}

