/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.network;

import io.netty.buffer.ByteBuf;
import mcjty.intwheel.InteractionWheel;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.network.NetworkTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPerformAction
implements IMessage {
    private BlockPos pos;
    private String actionId;
    private boolean extended;

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = NetworkTools.readPos(buf);
        }
        this.actionId = NetworkTools.readString(buf);
        this.extended = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            NetworkTools.writePos(buf, this.pos);
        } else {
            buf.writeBoolean(false);
        }
        NetworkTools.writeString(buf, this.actionId);
        buf.writeBoolean(this.extended);
    }

    public PacketPerformAction() {
    }

    public PacketPerformAction(BlockPos pos, String id, boolean extended) {
        this.pos = pos;
        this.actionId = id;
        this.extended = extended;
    }

    public static class Handler
    implements IMessageHandler<PacketPerformAction, IMessage> {
        public IMessage onMessage(PacketPerformAction message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketPerformAction message, MessageContext ctx) {
            IWheelAction action = InteractionWheel.registry.get(message.actionId);
            if (action != null) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                action.performServer((EntityPlayer)player, player.func_130014_f_(), message.pos, message.extended);
            }
        }
    }
}

