/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.playerdata;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.intwheel.network.PacketHandler;
import mcjty.intwheel.network.PacketSyncConfigToServer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerWheelConfiguration {
    private Map<String, Integer> hotkeys = new HashMap<String, Integer>();
    private Map<String, Boolean> enabledActions = new HashMap<String, Boolean>();
    private List<String> orderedActions = new ArrayList<String>();

    public Map<String, Integer> getHotkeys() {
        return this.hotkeys;
    }

    public void addHotkey(int key, String id) {
        this.hotkeys.put(id, key);
    }

    public void removeHotkey(String id) {
        this.hotkeys.remove(id);
    }

    public void enable(String id) {
        this.enabledActions.put(id, Boolean.TRUE);
    }

    public void disable(String id) {
        this.enabledActions.put(id, Boolean.FALSE);
    }

    public List<String> getOrderedActions() {
        return this.orderedActions;
    }

    public void setOrderActions(List<String> actions) {
        this.orderedActions = new ArrayList<String>(actions);
    }

    public Boolean isEnabled(String id) {
        return this.enabledActions.get(id);
    }

    public void copyFrom(PlayerWheelConfiguration source) {
        this.hotkeys = new HashMap<String, Integer>(source.hotkeys);
        this.enabledActions = new HashMap<String, Boolean>(source.enabledActions);
        this.orderedActions = new ArrayList<String>(source.orderedActions);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tc;
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Integer> entry : this.hotkeys.entrySet()) {
            tc = new NBTTagCompound();
            tc.func_74778_a("id", entry.getKey());
            tc.func_74768_a("key", entry.getValue().intValue());
            list.func_74742_a((NBTBase)tc);
        }
        compound.func_74782_a("hotkeys", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, Constable> entry : this.enabledActions.entrySet()) {
            tc = new NBTTagCompound();
            tc.func_74778_a("id", entry.getKey());
            tc.func_74757_a("enabled", ((Boolean)entry.getValue()).booleanValue());
            list.func_74742_a((NBTBase)tc);
        }
        compound.func_74782_a("enabled", (NBTBase)list);
        list = new NBTTagList();
        for (String string : this.orderedActions) {
            list.func_74742_a((NBTBase)new NBTTagString(string));
        }
        compound.func_74782_a("order", (NBTBase)list);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tc;
        int i;
        this.hotkeys = new HashMap<String, Integer>();
        NBTTagList list = compound.func_150295_c("hotkeys", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            tc = (NBTTagCompound)list.func_179238_g(i);
            this.hotkeys.put(tc.func_74779_i("id"), tc.func_74762_e("key"));
        }
        this.enabledActions = new HashMap<String, Boolean>();
        list = compound.func_150295_c("enabled", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            tc = (NBTTagCompound)list.func_179238_g(i);
            this.enabledActions.put(tc.func_74779_i("id"), tc.func_74767_n("enabled"));
        }
        this.orderedActions = new ArrayList<String>();
        list = compound.func_150295_c("order", 8);
        for (i = 0; i < list.func_74745_c(); ++i) {
            tc = (NBTTagString)list.func_179238_g(i);
            this.orderedActions.add(tc.func_150285_a_());
        }
    }

    public void sendToServer() {
        NBTTagCompound tc = new NBTTagCompound();
        this.saveNBTData(tc);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncConfigToServer(tc));
    }
}

