/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics;

import astavie.thermallogistics.attachment.CrafterFluid;
import astavie.thermallogistics.attachment.CrafterItem;
import astavie.thermallogistics.attachment.DistributorFluid;
import astavie.thermallogistics.attachment.DistributorItem;
import astavie.thermallogistics.attachment.RequesterFluid;
import astavie.thermallogistics.attachment.RequesterItem;
import astavie.thermallogistics.block.BlockTerminalItem;
import astavie.thermallogistics.compat.CompatTE;
import astavie.thermallogistics.compat.ICrafterWrapper;
import astavie.thermallogistics.item.ItemCrafter;
import astavie.thermallogistics.item.ItemDistributor;
import astavie.thermallogistics.item.ItemManager;
import astavie.thermallogistics.item.ItemRequester;
import astavie.thermallogistics.tile.TileTerminalItem;
import cofh.core.gui.CreativeTabCore;
import cofh.core.util.core.IInitializer;
import cofh.thermaldynamics.duct.AttachmentRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="thermallogistics", name="Thermal Logistics", dependencies="required-after:thermaldynamics;", acceptedMinecraftVersions="[1.12.2]")
public class ThermalLogistics {
    public static final String MOD_ID = "thermallogistics";
    public static final String MOD_NAME = "Thermal Logistics";
    public static final String MOD_VERSION = Objects.requireNonNull(Loader.instance().activeModContainer()).getVersion();
    @Mod.Instance(value="thermallogistics")
    public static ThermalLogistics INSTANCE;
    private final Map<Class<?>, ICrafterWrapper<?>> registry = new HashMap();
    public CreativeTabs tab = new CreativeTabCore("thermallogistics"){

        public ItemStack func_78016_d() {
            return new ItemStack((Block)Blocks.terminal_item);
        }
    };
    public Configuration config;
    public int refreshDelay;

    public <T extends TileEntity> boolean registerWrapper(Class<T> c, ICrafterWrapper<T> w) {
        if (this.registry.containsKey(c)) {
            return false;
        }
        this.registry.put(c, w);
        return true;
    }

    public ICrafterWrapper<?> getWrapper(Class<?> c) {
        return this.registry.get(c);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        AttachmentRegistry.registerAttachment((ResourceLocation)RequesterItem.ID, RequesterItem::new);
        AttachmentRegistry.registerAttachment((ResourceLocation)RequesterFluid.ID, RequesterFluid::new);
        AttachmentRegistry.registerAttachment((ResourceLocation)CrafterItem.ID, CrafterItem::new);
        AttachmentRegistry.registerAttachment((ResourceLocation)CrafterFluid.ID, CrafterFluid::new);
        AttachmentRegistry.registerAttachment((ResourceLocation)DistributorItem.ID, DistributorItem::new);
        AttachmentRegistry.registerAttachment((ResourceLocation)DistributorFluid.ID, DistributorFluid::new);
        if (Loader.isModLoaded((String)"thermalexpansion")) {
            this.registerWrapper(CompatTE.TILE, new CompatTE());
        }
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.refreshDelay = this.config.getInt("Refresh Delay", "general", 10, 1, 100, "The amount of ticks delay between sync packets from the server when looking at a GUI.");
        this.config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TileEntity.func_190560_a((String)Blocks.terminal_item.getRegistryName().toString(), TileTerminalItem.class);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventBusSubscriber
    public static class RegistryHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            RegistryHandler.register(event.getRegistry(), (IInitializer)new BlockTerminalItem("terminal", "item"));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            RegistryHandler.register(event.getRegistry(), (IInitializer)new ItemRequester("requester"));
            RegistryHandler.register(event.getRegistry(), (IInitializer)new ItemCrafter("crafter"));
            RegistryHandler.register(event.getRegistry(), (IInitializer)new ItemDistributor("distributor"));
            RegistryHandler.register(event.getRegistry(), new ItemManager("manager"));
            RegistryHandler.registerBlock((IForgeRegistry<Item>)event.getRegistry(), (Block)Blocks.terminal_item);
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            Items.requester.initialize();
            Items.crafter.initialize();
            Items.distributor.initialize();
            Items.manager.initialize();
            Blocks.terminal_item.initialize();
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            Items.requester.registerModels();
            Items.crafter.registerModels();
            Items.distributor.registerModels();
            Items.manager.registerModels();
            Blocks.terminal_item.registerModels();
        }

        private static <V extends IForgeRegistryEntry<V>> void register(IForgeRegistry<V> registry, IInitializer i) {
            i.preInit();
            registry.register((IForgeRegistryEntry)i);
        }

        private static void registerBlock(IForgeRegistry<Item> registry, Block block) {
            registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
    }

    @GameRegistry.ObjectHolder(value="thermallogistics")
    public static class Items {
        public static final ItemRequester requester = null;
        public static final ItemCrafter crafter = null;
        public static final ItemDistributor distributor = null;
        public static final ItemManager manager = null;
    }

    @GameRegistry.ObjectHolder(value="thermallogistics")
    public static class Blocks {
        public static final BlockTerminalItem terminal_item = null;
    }
}

