/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui;

import astavie.thermallogistics.client.gui.GuiTerminal;
import astavie.thermallogistics.client.gui.element.ElementSlotItem;
import astavie.thermallogistics.client.gui.tab.TabCrafting;
import astavie.thermallogistics.client.gui.tab.TabRequest;
import astavie.thermallogistics.container.ContainerTerminalItem;
import astavie.thermallogistics.process.RequestItem;
import astavie.thermallogistics.tile.TileTerminalItem;
import astavie.thermallogistics.util.Shared;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class GuiTerminalItem
extends GuiTerminal<ItemStack> {
    public final TileTerminalItem tile;
    public TabCrafting tabCrafting;
    public TabRequest tabRequest;
    private Pair<List<ItemStack>, List<String>> cache = Pair.of(null, null);
    private ElementButton dump2;

    public GuiTerminalItem(TileTerminalItem tile, InventoryPlayer inventory) {
        super(tile, (Container)new ContainerTerminalItem(tile, inventory), new ResourceLocation("thermallogistics", "textures/gui/terminal.png"));
        ((ContainerTerminalItem)this.field_147002_h).gui = this;
        this.tile = tile;
        this.field_146999_f = 194;
        this.field_147000_g = 250;
    }

    public Object getStackAt(int mouseX, int mouseY) {
        if (this.selected != null && this.button.isVisible() && mouseX >= 25 && mouseX < 43 && mouseY >= 73 && mouseY < 91) {
            return this.selected;
        }
        int i = this.slider.getValue() * 9;
        block0: for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slot = i + x + y * 9;
                if (slot >= this.filter.size()) break block0;
                int posX = 8 + x * 18;
                int posY = 18 + y * 18;
                if (mouseX < posX - 1 || mouseX >= posX + 17 || mouseY < posY - 1 || mouseY >= posY + 17) continue;
                return ((Triple)this.filter.get(slot)).getLeft();
            }
        }
        if (this.tabCrafting.isFullyOpened()) {
            return this.tabCrafting.getStackAt(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public void addTooltips(List<String> tooltip) {
        List list;
        super.addTooltips(tooltip);
        if (this.tabCrafting.button.intersectsWith(this.mouseX - this.tabCrafting.posX(), this.mouseY - this.tabCrafting.getPosY()) && (list = (List)this.cache.getRight()) != null) {
            tooltip.addAll(list);
        }
    }

    private Pair<List<ItemStack>, List<String>> request() {
        if (Arrays.stream(this.tile.shared).allMatch(shared -> shared.test(ItemStack.field_190927_a))) {
            return Pair.of(null, null);
        }
        LinkedList<Triple> copy = new LinkedList<Triple>();
        for (ItemStack stack : this.tile.inventory.items) {
            if (stack.func_190926_b()) continue;
            copy.add(Triple.of((Object)ItemHelper.cloneStack((ItemStack)stack, (int)1), (Object)stack.func_190916_E(), (Object)false));
        }
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
            if (stack.func_190926_b()) continue;
            copy.add(Triple.of((Object)ItemHelper.cloneStack((ItemStack)stack, (int)1), (Object)stack.func_190916_E(), (Object)false));
        }
        copy.addAll(this.tile.terminal);
        int count = 1;
        if (!this.tabCrafting.amount.getText().isEmpty()) {
            count = Integer.parseInt(this.tabCrafting.amount.getText());
        }
        RequestItem request = new RequestItem(null);
        RequestItem missing = new RequestItem(null);
        block2: for (Shared.Item item : this.tile.shared) {
            if (item.test(ItemStack.field_190927_a)) continue;
            int amount = count;
            for (int i = 0; i < copy.size(); ++i) {
                Triple triple = (Triple)copy.get(i);
                if (!((Boolean)triple.getRight()).booleanValue() && (Long)triple.getMiddle() == 0L || !item.test((ItemStack)triple.getLeft())) continue;
                if (((Boolean)triple.getRight()).booleanValue()) {
                    request.addStack(ItemHelper.cloneStack((ItemStack)((ItemStack)triple.getLeft()), (int)count));
                    continue block2;
                }
                int shrink = (int)Math.min((Long)triple.getMiddle(), (long)amount);
                request.addStack(ItemHelper.cloneStack((ItemStack)((ItemStack)triple.getLeft()), (int)shrink));
                copy.set(i, Triple.of((Object)triple.getLeft(), (Object)((Long)triple.getMiddle() - (long)shrink), (Object)triple.getRight()));
                if ((amount -= shrink) == 0) continue block2;
            }
            missing.addStack(ItemHelper.cloneStack((ItemStack)item.getDisplayStack(), (int)amount));
        }
        if (missing.stacks.isEmpty()) {
            for (Shared.Item item : this.tile.inventory.items) {
                request.decreaseStack((ItemStack)item);
            }
            for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
                request.decreaseStack(stack);
            }
            if (request.stacks.isEmpty()) {
                return Pair.of(null, Collections.singletonList(StringHelper.localize((String)"gui.logistics.terminal.enough")));
            }
            return Pair.of((Object)request.stacks, null);
        }
        LinkedList<String> tooltip = new LinkedList<String>();
        tooltip.add(StringHelper.localize((String)"gui.logistics.terminal.missing"));
        for (ItemStack stack : missing.stacks) {
            tooltip.add(StringHelper.localizeFormat((String)"info.logistics.manager.e.1", (Object[])new Object[]{stack.func_190916_E(), stack.func_82833_r()}));
        }
        return Pair.of(null, tooltip);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i += 9;
        this.tabCrafting = new TabCrafting(this, this.tile.shared, () -> {
            InventoryCraftingFalse inventory = new InventoryCraftingFalse(3, 3);
            for (int i = 0; i < 9; ++i) {
                inventory.func_70299_a(i, (ItemStack)this.tile.shared[i].get());
            }
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inventory, (World)Minecraft.func_71410_x().field_71441_e);
            if (recipe == null) {
                return;
            }
            PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
            packet.addByte(2);
            packet.addBool(StringHelper.isShiftKeyDown());
            for (Shared.Item stacks : this.tile.shared) {
                Ingredient ingredient = stacks.asIngredient();
                packet.addInt(ingredient.func_193365_a().length);
                for (ItemStack item : ingredient.func_193365_a()) {
                    packet.addItemStack(item);
                }
            }
            packet.addString(recipe.getRegistryName().toString());
            PacketHandler.sendToServer((PacketBase)packet);
        }, () -> {
            if (this.cache.getLeft() != null) {
                for (ItemStack stack : (List)this.cache.getLeft()) {
                    this.request(ItemHelper.cloneStack((ItemStack)stack, (int)1), stack.func_190916_E());
                }
            }
        }, () -> this.cache.getLeft() != null);
        this.addTab(this.tabCrafting).setOffsets(-18, 74);
        this.tabRequest = new TabRequest(this, this.tile.requests.stacks, (TileEntity)this.tile);
        this.addTab(this.tabRequest).setOffsets(-18, 74);
        ElementButton dump = new ElementButton((GuiContainerCore)this, 153, 153, "dump", 194, 0, 194, 14, 14, 14, this.texture.toString());
        dump.setToolTip("info.logistics.terminal.dump.inventory");
        this.dump2 = new ElementButton((GuiContainerCore)this, 153, 75, "dump2", 208, 0, 208, 14, 14, 14, this.texture.toString());
        this.dump2.setToolTip("info.logistics.terminal.dump.network");
        this.addElement((ElementBase)dump);
        this.addElement((ElementBase)this.dump2);
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (mouseButton == 0) {
            if (buttonName.equals("dump")) {
                GuiTerminalItem.playClickSound((float)1.0f);
                PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
                packet.addByte(4);
                PacketHandler.sendToServer((PacketBase)packet);
            } else if (buttonName.equals("dump2")) {
                GuiTerminalItem.playClickSound((float)1.0f);
                PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
                packet.addByte(5);
                PacketHandler.sendToServer((PacketBase)packet);
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.dump2.setVisible(this.requester().func_75216_d());
        this.cache = this.request();
        boolean visible = this.requester().func_75216_d();
        this.tabCrafting.setVisible(visible);
        this.tabRequest.setVisible(visible);
    }

    @Override
    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        if (this.button.isVisible() && !Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            int mouseX = mX - this.field_147003_i - 7;
            int mouseY = mY - this.field_147009_r - 17;
            if (mouseX >= 0 && mouseX < 162 && mouseY >= 0 && mouseY < 54) {
                PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
                packet.addByte(3);
                PacketHandler.sendToServer((PacketBase)packet);
                return;
            }
        }
        super.func_73864_a(mX, mY, mouseButton);
    }

    protected void func_146273_a(int mX, int mY, int lastClick, long timeSinceClick) {
        if (lastClick == 0 && this.button.isVisible() && Arrays.stream(this.tabCrafting.grid).anyMatch(slot -> slot.intersectsWith(mX - this.field_147003_i - this.tabCrafting.posX(), mY - this.field_147009_r - this.tabCrafting.getPosY()))) {
            try {
                this.func_73864_a(mX, mY, lastClick);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            super.func_146273_a(mX, mY, lastClick, timeSinceClick);
        }
    }

    protected boolean func_193983_c(int x, int y, int left, int top) {
        boolean yes = super.func_193983_c(x, y, left, top);
        if (yes) {
            for (ElementSlotItem element : this.tabCrafting.grid) {
                if (!element.intersectsWith(x - left - this.tabCrafting.posX(), y - top - this.tabCrafting.getPosY())) continue;
                return false;
            }
            if (this.tabCrafting.output.intersectsWith(x - left - this.tabCrafting.posX(), y - top - this.tabCrafting.getPosY())) {
                return false;
            }
        }
        return yes;
    }

    @Override
    protected void func_73869_a(char characterTyped, int keyPressed) throws IOException {
        if (this.tabCrafting != null && this.tabCrafting.isFullyOpened() && this.tabCrafting.onKeyTyped(characterTyped, keyPressed)) {
            return;
        }
        super.func_73869_a(characterTyped, keyPressed);
    }

    @Override
    protected boolean isSelected(ItemStack stack) {
        return ItemHelper.itemsIdentical((ItemStack)((ItemStack)this.selected), (ItemStack)stack);
    }

    @Override
    protected void updateFilter() {
        this.filter.clear();
        block0: for (Triple stack : this.tile.terminal) {
            if (this.search.getText().isEmpty() || ((ItemStack)stack.getLeft()).func_82833_r().toLowerCase().contains(this.search.getText().toLowerCase())) {
                this.filter.add(stack);
                continue;
            }
            for (String string : this.func_191927_a((ItemStack)stack.getLeft())) {
                if (!string.toLowerCase().contains(this.search.getText().toLowerCase())) continue;
                this.filter.add(stack);
                continue block0;
            }
        }
        this.filter.sort((i1, i2) -> {
            int count = -Long.compare((Long)i1.getMiddle(), (Long)i2.getMiddle());
            if (count != 0) {
                return count;
            }
            int id = Integer.compare(Item.func_150891_b((Item)((ItemStack)i1.getLeft()).func_77973_b()), Item.func_150891_b((Item)((ItemStack)i2.getLeft()).func_77973_b()));
            if (id != 0) {
                return id;
            }
            int damage = Integer.compare(((ItemStack)i1.getLeft()).func_77952_i(), ((ItemStack)i2.getLeft()).func_77952_i());
            if (damage != 0) {
                return damage;
            }
            CreativeTabs tab = ((ItemStack)i1.getLeft()).func_77973_b().func_77640_w();
            if (tab == null) {
                tab = CreativeTabs.field_78027_g;
            }
            NonNullList list = NonNullList.func_191196_a();
            ((ItemStack)i1.getLeft()).func_77973_b().func_150895_a(tab, list);
            for (ItemStack stack : list) {
                if (ItemHelper.itemsIdentical((ItemStack)((ItemStack)i1.getLeft()), (ItemStack)stack)) {
                    return -1;
                }
                if (!ItemHelper.itemsIdentical((ItemStack)((ItemStack)i2.getLeft()), (ItemStack)stack)) continue;
                return 1;
            }
            if (((ItemStack)i1.getLeft()).func_77978_p() == null && ((ItemStack)i2.getLeft()).func_77978_p() != null) {
                return -1;
            }
            if (((ItemStack)i1.getLeft()).func_77978_p() != null && ((ItemStack)i2.getLeft()).func_77978_p() == null) {
                return 1;
            }
            return 0;
        });
    }

    @Override
    protected void updateAmount(Triple<ItemStack, Long, Boolean> stack) {
        this.amount.setText(Long.toString((Boolean)stack.getRight() != false ? (long)((ItemStack)this.selected).func_77976_d() : Math.min((Long)stack.getMiddle(), (long)((ItemStack)this.selected).func_77976_d())));
    }
}

