/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.RequestFluid;
import codechicken.lib.fluid.FluidUtils;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.FluidTankGrid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ProcessFluid
extends Process<FluidStack> {
    public ProcessFluid(IRequester<FluidStack> requester) {
        super(requester);
    }

    public static boolean checkRequests(IRequester<FluidStack> requester, List<Request<FluidStack>> requests, BiFunction<IRequester<FluidStack>, IRequester<FluidStack>, List<FluidStack>> function) {
        boolean changed = false;
        Iterator<Request<FluidStack>> iterator = requests.iterator();
        while (iterator.hasNext()) {
            Request<FluidStack> request = iterator.next();
            if (!request.attachment.isLoaded()) continue;
            IRequester attachment = request.attachment.getAttachment();
            if (attachment == null || !attachment.isEnabled()) {
                iterator.remove();
                requester.markDirty();
                continue;
            }
            List<FluidStack> list = function.apply(attachment, requester);
            Iterator iterator1 = request.stacks.iterator();
            block1: while (iterator1.hasNext()) {
                FluidStack stack = (FluidStack)iterator1.next();
                for (FluidStack compare : list) {
                    if (!FluidHelper.isFluidEqual((FluidStack)stack, (FluidStack)compare)) continue;
                    if (stack.amount <= compare.amount) continue block1;
                    stack.amount = compare.amount;
                    changed = true;
                    requester.markDirty();
                    continue block1;
                }
                iterator1.remove();
                requester.markDirty();
            }
            if (!request.stacks.isEmpty()) continue;
            iterator.remove();
            requester.markDirty();
        }
        return changed;
    }

    @Override
    public NBTTagList writeNbt() {
        NBTTagList requests = new NBTTagList();
        for (Request request : this.requests) {
            requests.func_74742_a((NBTBase)RequestFluid.writeNBT(request));
        }
        return requests;
    }

    @Override
    public void readNbt(NBTTagList nbt) {
        this.requests.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            this.requests.add(RequestFluid.readNBT(nbt.func_150305_b(i)));
        }
    }

    @Override
    public void tick() {
        GridFluid other;
        DuctUnitFluid.Cache cache;
        int side;
        int maxInput;
        if (!this.requester.hasRequests()) {
            return;
        }
        ProcessFluid.checkRequests(this.requester, this.requests, IRequester::getOutputTo);
        TileEntity tile = this.requester.getCachedTile();
        if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)(this.requester.getSide() ^ 1)))) {
            return;
        }
        IFluidHandler myHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)(this.requester.getSide() ^ 1)));
        if (myHandler == null) {
            return;
        }
        GridFluid grid = (GridFluid)((DuctUnitFluid)this.requester.getDuct()).getGrid();
        FluidTankGrid tank = grid.myTank;
        int c = maxInput = (int)Math.ceil((float)tank.fluidThroughput * this.requester.getThrottle());
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext() && maxInput > 0) {
            int input;
            FluidStack drainFluid;
            IFluidHandler handler;
            IRequester<FluidStack> requester;
            Request request = (Request)iterator.next();
            if (!request.attachment.isLoaded() || (requester = request.attachment.getAttachment()) == null) continue;
            DuctUnitFluid endPoint = (DuctUnitFluid)requester.getDuct();
            side = requester.getSide();
            cache = ((DuctUnitFluid.Cache[])endPoint.tileCache)[side];
            if (cache == null || !endPoint.isOutput(side) && !endPoint.isInput(side) || (handler = cache.getHandler(side ^ 1)) == null || (drainFluid = handler.drain(maxInput, false)) == null || (input = Math.min(tank.fill(drainFluid, false), request.getCount(drainFluid))) == 0) continue;
            input = tank.fill(handler.drain(input, true), true);
            maxInput -= input;
            FluidStack fluid = FluidUtils.copy((FluidStack)drainFluid, (int)input);
            requester.onFinishCrafting(this.requester, fluid);
            request.decreaseStack(fluid);
            if (request.stacks.isEmpty()) {
                iterator.remove();
            }
            this.requester.markDirty();
            if (grid.toDistribute <= 0 || tank.getFluid() == null || (other = (GridFluid)endPoint.getGrid()) == null) continue;
            ((DuctUnitFluid)requester.getDuct()).transfer(side, Math.min(other.myTank.getFluid().amount, other.toDistribute), false, other.myTank.getFluid(), true);
        }
        if (maxInput == 0) {
            return;
        }
        NonNullList crafters = NonNullList.func_191196_a();
        Iterator iterator2 = grid.nodeSet.iterator();
        while (iterator2.hasNext() && maxInput > 0) {
            DuctUnitFluid fluidDuct = (DuctUnitFluid)iterator2.next();
            for (int k = 0; k < 6 && maxInput > 0; ++k) {
                int input;
                FluidStack drainFluid;
                Object handler;
                side = (k + fluidDuct.internalSideCounter) % 6;
                cache = ((DuctUnitFluid.Cache[])fluidDuct.tileCache)[side];
                if (cache == null) continue;
                Attachment attachment = fluidDuct.parent.getAttachment(side);
                if (attachment instanceof ICrafter) {
                    crafters.add((ICrafter)attachment);
                }
                if (attachment != null && !attachment.canSend()) continue;
                if (cache.tile instanceof ICrafter) {
                    crafters.add((ICrafter)cache.tile);
                }
                if (!fluidDuct.isOutput(side) && !fluidDuct.isInput(side) || (handler = cache.getHandler(side ^ 1)) == null || handler.equals(myHandler) || (drainFluid = handler.drain(maxInput, false)) == null || (input = Math.min(tank.fill(drainFluid, false), this.requester.amountRequired(drainFluid) - tank.getFluidAmount())) <= 0) continue;
                maxInput -= tank.fill(handler.drain(input, true), true);
                if (grid.toDistribute <= 0 || tank.getFluid() == null || (other = (GridFluid)fluidDuct.getGrid()) == null) continue;
                ((DuctUnitFluid)this.requester.getDuct()).transfer(side, Math.min(other.myTank.getFluid().amount, other.toDistribute), false, other.myTank.getFluid(), true);
            }
        }
        if (maxInput != c || (this.requester.getDuct().world().func_82737_E() - this.offset) % (long)this.requester.tickDelay() != 0L) {
            return;
        }
        for (ICrafter crafter : crafters) {
            Set blacklist;
            if (crafter == this.requester || !crafter.isEnabled() || (blacklist = crafter.getBlacklist()).stream().anyMatch(reference -> reference.references(this.requester))) continue;
            for (FluidStack stack : crafter.getOutputs()) {
                int amount = this.requester.amountRequired(stack) - tank.getFluidAmount();
                if (amount <= 0 || (amount = Math.min(amount, this.requester.getMaxSend() * 1000 - this.getCount(stack))) == 0) continue;
                stack = stack.copy();
                stack.amount = amount;
                if (!crafter.request(this.requester, stack)) continue;
                this.requester.markDirty();
                for (Request request : this.requests) {
                    if (!request.attachment.references(crafter)) continue;
                    request.addStack(stack);
                    request.blacklist.addAll(blacklist);
                    return;
                }
                RequestFluid request = new RequestFluid(crafter.getReference(), stack);
                request.blacklist.add(crafter.getReference());
                request.blacklist.addAll(blacklist);
                this.requests.add(request);
                return;
            }
        }
    }
}

