/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.RequestItem;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessItem
extends Process<ItemStack> {
    public ProcessItem(IRequester<ItemStack> requester) {
        super(requester);
    }

    public static boolean checkRequests(IRequester<ItemStack> requester, List<Request<ItemStack>> requests, BiFunction<IRequester<ItemStack>, IRequester<ItemStack>, List<ItemStack>> function) {
        boolean changed = false;
        Iterator<Request<ItemStack>> iterator = requests.iterator();
        while (iterator.hasNext()) {
            Request<ItemStack> request = iterator.next();
            if (!request.attachment.isLoaded()) continue;
            IRequester attachment = request.attachment.getAttachment();
            if (attachment == null || !attachment.isEnabled()) {
                iterator.remove();
                requester.markDirty();
                continue;
            }
            List<ItemStack> list = function.apply(attachment, requester);
            Iterator iterator1 = request.stacks.iterator();
            block1: while (iterator1.hasNext()) {
                ItemStack stack = (ItemStack)iterator1.next();
                for (ItemStack compare : list) {
                    if (!ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)compare)) continue;
                    if (stack.func_190916_E() <= compare.func_190916_E()) continue block1;
                    stack.func_190920_e(compare.func_190916_E());
                    changed = true;
                    requester.markDirty();
                    continue block1;
                }
                iterator1.remove();
                requester.markDirty();
            }
            if (!request.stacks.isEmpty()) continue;
            iterator.remove();
            requester.markDirty();
        }
        return changed;
    }

    @Override
    public NBTTagList writeNbt() {
        NBTTagList requests = new NBTTagList();
        for (Request request : this.requests) {
            requests.func_74742_a((NBTBase)RequestItem.writeNBT(request));
        }
        return requests;
    }

    @Override
    public void readNbt(NBTTagList nbt) {
        this.requests.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            this.requests.add(RequestItem.readNBT(nbt.func_150305_b(i)));
        }
    }

    private static Pair<ItemStack, Route> extract(IRequester<ItemStack> requester, IItemHandler handler, Function<ItemStack, Integer> amountRequired, DuctUnitItem endPoint, DuctUnitItem.Cache cache, IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            int maxStackSize;
            Route route1;
            int amount;
            ItemStack item = inv.getStackInSlot(slot);
            if (item.func_190926_b() || cache != null && !cache.filter.matchesFilter(item) || (amount = Math.min(amountRequired.apply(item), requester.getMaxSend())) == 0) continue;
            item = ItemHelper.cloneStack((ItemStack)item, (int)(requester.hasMultiStack() ? Integer.MAX_VALUE : item.func_190916_E()));
            if (item.func_190926_b() || (item = ProcessItem.checkItem(requester, handler, item, amount)).func_190926_b() || (route1 = endPoint.getRoute((IGridTileRoute)requester.getDuct())) == null || (item = inv.extractItem(slot, maxStackSize = item.func_190916_E(), false)).func_190926_b()) continue;
            route1 = route1.copy();
            route1.pathDirections.add(requester.getSide());
            if (requester.hasMultiStack() && item.func_190916_E() < maxStackSize) {
                while (item.func_190916_E() < maxStackSize && slot < inv.getSlots()) {
                    ItemStack extract;
                    if (ItemHelper.itemsEqualWithMetadata((ItemStack)inv.getStackInSlot(slot), (ItemStack)item, (boolean)true) && !(extract = inv.extractItem(slot, maxStackSize - item.func_190916_E(), false)).func_190926_b()) {
                        item.func_190917_f(extract.func_190916_E());
                    }
                    ++slot;
                }
            }
            requester.refreshCache();
            return Pair.of((Object)item, (Object)route1);
        }
        return null;
    }

    private static ItemStack checkItem(IRequester<ItemStack> requester, IItemHandler handler, ItemStack item, int amount) {
        ItemStack remainder = item.func_77946_l();
        if (remainder.func_190916_E() <= amount) {
            remainder = InventoryHelper.insertStackIntoInventory((IItemHandler)handler, (ItemStack)remainder, (boolean)true);
        } else {
            ItemStack remaining = InventoryHelper.insertStackIntoInventory((IItemHandler)handler, (ItemStack)remainder.func_77979_a(amount), (boolean)true);
            if (!remaining.func_190926_b()) {
                remainder.func_190917_f(remaining.func_190916_E());
            }
        }
        if (!remainder.func_190926_b()) {
            item.func_190918_g(remainder.func_190916_E());
        }
        if (item.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        int remain = ((DuctUnitItem)requester.getDuct()).canRouteItem(item, requester.getSide());
        if (remain == -1) {
            return ItemStack.field_190927_a;
        }
        item.func_190918_g(remain);
        return item;
    }

    @Override
    public void tick() {
        if (!this.requester.hasRequests() || (this.requester.getDuct().world().func_82737_E() - this.offset) % (long)this.requester.tickDelay() != 0L) {
            return;
        }
        ProcessItem.checkRequests(this.requester, this.requests, IRequester::getOutputTo);
        TileEntity tile = this.requester.getCachedTile();
        if (tile == null) {
            return;
        }
        IItemHandler handler = InventoryHelper.getItemHandlerCap((TileEntity)tile, (EnumFacing)EnumFacing.func_82600_a((int)(this.requester.getSide() ^ 1)));
        if (handler == null) {
            return;
        }
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            Pair<ItemStack, Route> extract;
            IItemHandler inv;
            IRequester<Object> requester;
            Request request = (Request)iterator.next();
            if (request.stacks.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (!request.attachment.isLoaded() || (requester = request.attachment.getAttachment()) == null) continue;
            DuctUnitItem endPoint = (DuctUnitItem)requester.getDuct();
            byte side = requester.getSide();
            DuctUnitItem.Cache cache = ((DuctUnitItem.Cache[])endPoint.tileCache)[side];
            if (cache == null || !endPoint.isInput((int)side) && !endPoint.isOutput((int)side) || !endPoint.parent.getConnectionType((int)side).allowTransfer || (inv = cache.getItemHandler(side ^ 1)) == null || (extract = ProcessItem.extract(this.requester, handler, request::getCount, endPoint, null, inv)) == null) continue;
            requester.onFinishCrafting(this.requester, extract.getLeft());
            request.decreaseStack(extract.getLeft());
            if (request.stacks.isEmpty()) {
                iterator.remove();
            }
            endPoint.insertNewItem(new TravelingItem((ItemStack)extract.getLeft(), (IGridTile)endPoint, (Route)extract.getRight(), (byte)(side ^ 1), this.requester.getSpeed()));
            this.requester.markDirty();
            return;
        }
        NonNullList crafters = NonNullList.func_191196_a();
        ListWrapper<Route<DuctUnitItem, GridItem>> routes = this.requester.getRoutes();
        for (Route route : routes) {
            Pair<ItemStack, Route> extract;
            Object inv;
            DuctUnitItem.Cache cache;
            DuctUnitItem endPoint = (DuctUnitItem)route.endPoint;
            byte side = route.getLastSide();
            Attachment attachment = endPoint.parent.getAttachment((int)side);
            if (attachment instanceof ICrafter) {
                crafters.add((ICrafter)attachment);
            }
            if (attachment != null && !attachment.canSend() || (cache = ((DuctUnitItem.Cache[])endPoint.tileCache)[side]) == null) continue;
            if (cache.tile instanceof ICrafter) {
                crafters.add((ICrafter)cache.tile);
            }
            if (!endPoint.isInput((int)side) && !endPoint.isOutput((int)side) || !endPoint.parent.getConnectionType((int)side).allowTransfer || (inv = cache.getItemHandler(side ^ 1)) == null || inv.equals(handler) || (extract = ProcessItem.extract(this.requester, handler, this.requester::amountRequired, endPoint, cache, (IItemHandler)inv)) == null) continue;
            endPoint.insertNewItem(new TravelingItem((ItemStack)extract.getLeft(), (IGridTile)endPoint, (Route)extract.getRight(), (byte)(side ^ 1), this.requester.getSpeed()));
            routes.advanceCursor();
            return;
        }
        for (ICrafter crafter : crafters) {
            Set blacklist;
            if (crafter == this.requester || !crafter.isEnabled() || (blacklist = crafter.getBlacklist()).stream().anyMatch(reference -> reference.references(this.requester))) continue;
            for (ItemStack stack : crafter.getOutputs()) {
                int amount = this.requester.amountRequired(stack);
                if (amount == 0 || (amount = Math.min(amount, this.requester.getMaxSend() - this.getCount(stack))) == 0 || !crafter.request(this.requester, stack = ItemHelper.cloneStack((ItemStack)stack, (int)amount))) continue;
                this.requester.markDirty();
                for (Request request : this.requests) {
                    if (!request.attachment.references(crafter)) continue;
                    request.addStack(stack);
                    request.blacklist.addAll(blacklist);
                    return;
                }
                RequestItem request = new RequestItem(crafter.getReference(), stack);
                request.blacklist.add(crafter.getReference());
                request.blacklist.addAll(blacklist);
                this.requests.add(request);
                return;
            }
        }
    }
}

