/*
 * Decompiled with CFR 0.152.
 */
package openmods.fakeplayer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openmods.LibConfig;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.world.DropCapture;

public class BreakBlockAction
implements FakePlayerPool.PlayerUserReturning<List<EntityItem>> {
    private final World worldObj;
    private final BlockPos blockPos;
    @Nonnull
    private ItemStack stackToUse;
    private boolean findEffectiveTool;
    private static Cache<IBlockState, ItemStack> effectiveToolCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();

    public BreakBlockAction(World worldObj, BlockPos blockPos) {
        this.worldObj = worldObj;
        this.blockPos = blockPos;
        this.stackToUse = BreakBlockAction.createToolStack(Items.field_151046_w);
    }

    private static ItemStack createToolStack(Item tool) {
        return new ItemStack(tool, 1, 0);
    }

    public BreakBlockAction setStackToUse(@Nonnull ItemStack stack) {
        this.stackToUse = stack;
        return this;
    }

    public BreakBlockAction findEffectiveTool() {
        this.findEffectiveTool = true;
        return this;
    }

    private void selectTool(IBlockState state, OpenModsFakePlayer fakePlayer) {
        if (this.findEffectiveTool) {
            ItemStack optimalTool = (ItemStack)effectiveToolCache.getIfPresent((Object)state);
            if (optimalTool != null) {
                BreakBlockAction.setPlayerTool(fakePlayer, optimalTool);
            } else {
                for (ItemStack tool : ConfigAccess.probeTools()) {
                    BreakBlockAction.setPlayerTool(fakePlayer, tool);
                    if (!ForgeHooks.canHarvestBlock((Block)state.func_177230_c(), (EntityPlayer)fakePlayer, (IBlockAccess)this.worldObj, (BlockPos)this.blockPos)) continue;
                    effectiveToolCache.put((Object)state, (Object)tool);
                    return;
                }
                ItemStack fallbackTool = BreakBlockAction.createToolStack(Items.field_151046_w);
                effectiveToolCache.put((Object)state, (Object)fallbackTool);
                BreakBlockAction.setPlayerTool(fakePlayer, fallbackTool);
            }
        } else {
            BreakBlockAction.setPlayerTool(fakePlayer, this.stackToUse);
        }
    }

    private static void setPlayerTool(OpenModsFakePlayer fakePlayer, ItemStack tool) {
        fakePlayer.field_71071_by.func_70299_a(0, tool.func_77946_l());
    }

    private boolean removeBlock(EntityPlayer player, BlockPos pos, IBlockState state, boolean canHarvest) {
        Block block = state.func_177230_c();
        block.func_176208_a(this.worldObj, pos, state, player);
        boolean result = block.removedByPlayer(state, this.worldObj, pos, player, canHarvest);
        if (result) {
            block.func_176206_d(this.worldObj, pos, state);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EntityItem> usePlayer(OpenModsFakePlayer fakePlayer) {
        List<EntityItem> drops;
        if (!this.worldObj.func_175660_a((EntityPlayer)fakePlayer, this.blockPos)) {
            return Lists.newArrayList();
        }
        IBlockState state = this.worldObj.func_180495_p(this.blockPos);
        fakePlayer.field_71071_by.field_70461_c = 0;
        this.selectTool(state, fakePlayer);
        DropCapture.CaptureContext dropsCapturer = DropCapture.instance.start(this.blockPos);
        try {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.worldObj, this.blockPos, state, (EntityPlayer)fakePlayer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            TileEntity te = this.worldObj.func_175625_s(this.blockPos);
            boolean canHarvest = state.func_177230_c().canHarvestBlock((IBlockAccess)this.worldObj, this.blockPos, (EntityPlayer)fakePlayer);
            boolean isRemoved = this.removeBlock((EntityPlayer)fakePlayer, this.blockPos, state, canHarvest);
            if (isRemoved && canHarvest) {
                state.func_177230_c().func_180657_a(this.worldObj, (EntityPlayer)fakePlayer, this.blockPos, state, te, this.stackToUse);
                this.worldObj.func_180498_a((EntityPlayer)fakePlayer, 2001, this.blockPos, Block.func_176210_f((IBlockState)state));
            }
        }
        finally {
            List<EntityItem> drops2 = dropsCapturer.stop();
        }
        return drops;
    }

    @Mod.EventBusSubscriber
    private static class ConfigAccess {
        private static ItemStack[] probeTools;

        private ConfigAccess() {
        }

        @SubscribeEvent
        public static void onConfigUpdate(ConfigurationChange evt) {
            if (evt.check("feature", "fakePlayerBlockBreakTools")) {
                probeTools = null;
                effectiveToolCache.invalidateAll();
            }
        }

        public static ItemStack[] probeTools() {
            if (probeTools == null) {
                ArrayList items = Lists.newArrayList();
                for (String itemId : LibConfig.toolProbes) {
                    Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId));
                    if (item != null) {
                        items.add(BreakBlockAction.createToolStack(item));
                        continue;
                    }
                    Log.warn("Failed to find item: %s", itemId);
                }
                probeTools = items.toArray(new ItemStack[items.size()]);
            }
            return probeTools;
        }
    }
}

