/*
 * Decompiled with CFR 0.152.
 */
package com.matt_r__.ConfigChecker;

import com.matt_r__.ConfigChecker.Event;
import com.matt_r__.ConfigChecker.ModConfig;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import util.Config;

@Mod(modid="concheckrmd", name="Config Checker", version="1.7.0", acceptedMinecraftVersions="[1.12, 1.12.2]", dependencies="before:*")
public class Main {
    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Main.previousversion();
        if (Main.previousversion()) {
            JFrame jf = new JFrame();
            jf.isAlwaysOnTop();
            int action = JOptionPane.showConfirmDialog(jf, "An older Config Checker configuration file has been detected. Your settings can be moved to the new version. Would you like to transfer your settings?");
            if (action == 0) {
                Main.transferoldconfig();
            } else {
                try {
                    new File("config/Config Checker.cfg").renameTo(new File("config/Config Checker.cfg.old"));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(jf, "Unable to delete old file. Please delete it manually from 'Config/Config Checker.cfg'." + e.getMessage());
                }
            }
        }
        Main.LoadConfig();
        Config.gamebooting = true;
        this.checkadditionals();
        this.meetsrequiredram();
        this.meetsrecommendedram();
        this.launchwebpage();
        this.displaycustommessage();
        MinecraftForge.EVENT_BUS.register((Object)new Event());
        this.gamelaunchtimout();
    }

    public static void LoadConfig() {
        Configuration config = new Configuration(new File("concheckrmd"));
        config.load();
        Config.ramrecommendedinmbonload = ModConfig.ramlaunch.launchrecommendedraminmb;
        Config.checkRecommendedRAM = config.get("RAM Recommendation", "2. Check RAM meets recommendation?", true).getBoolean();
        Config.RecommendedRAMPopupTopmost = ModConfig.ramlaunch.launchdisplayrammessageboxtopmost;
        Config.DisplayCustomMessageBoxRecommendations = ModConfig.ramlaunch.launchcustomrecommendedtext;
        Config.CustomRAMRecommendationsMessageBox = ModConfig.ramlaunch.messageboxtext;
        Config.ramrecommendedinmbingame = ModConfig.ramgame.chatrecommendedraminmb;
        Config.showrecommendedramingame = ModConfig.ramgame.chatcheckrecommendedram;
        Config.showrecommendedramingamecustommessage = ModConfig.ramgame.chatcustomrecommendedtext;
        Config.recommendedramingamecustommessage = ModConfig.ramgame.chatramcustomtext;
        Config.ramrequiredinmb = ModConfig.reqram.requiredraminmb;
        Config.checkRequiredRAM = ModConfig.reqram.checkrequiredram;
        Config.RequiredRAMPopupTopmost = ModConfig.reqram.ramreqmessageboxtopmost;
        Config.DisplayCustomMessageBoxRequirements = ModConfig.reqram.customrequiredtext;
        Config.CustomRAMRequirementsMessageBox = ModConfig.reqram.requiredramcustomtext;
        Config.displaygreetingmessageingame = ModConfig.customg.displaychatgreeting;
        Config.greetingmessagetext = ModConfig.customg.greetingmessagetext;
        Config.launchtimeoutinseconds = ModConfig.launchtimeout.launchtimeoutinseconds;
        Config.checklaunchtimeout = ModConfig.launchtimeout.checklaunchtimeout;
        Config.launchtimeoutmessageboxtopmost = ModConfig.launchtimeout.launchtimeoutmessageboxtopmost;
        Config.displaycustomlaunchtimeoutmessagebox = ModConfig.launchtimeout.displaycustomlaunchtimeoutmessagebox;
        Config.customlaunchtimeoutmessageboxtext = ModConfig.launchtimeout.customlaunchtimeoutmessageboxtext;
        Config.webpageURL = ModConfig.webpage.websiteurl;
        Config.launchwebpage = ModConfig.webpage.displaywebsite;
        Config.displaylaunchmessage = ModConfig.custommb.displaymessagebox;
        Config.launchmessagetext = ModConfig.custommb.messageboxtext;
        Config.launchmessagetopmost = ModConfig.custommb.displaymessageboxtopmost;
        if (new File("config/concheckrmd.lock").exists()) {
            Config.lockconfig = true;
        }
        config.save();
    }

    public static boolean previousversion() {
        return new File("config/Config Checker.cfg").exists();
    }

    public static void transferoldconfig() {
        try {
            Configuration config = new Configuration(new File("config/Config Checker.cfg"));
            config.load();
            ModConfig.ramlaunch.launchrecommendedraminmb = config.get("RAM Recommendation", "1. Ram Recommended (IN MB)", 2048).getInt();
            ModConfig.ramlaunch.launchcheckrecommendedram = config.get("RAM Recommendation", "2. Check RAM meets recommendation?", true).getBoolean();
            ModConfig.ramlaunch.launchdisplayrammessageboxtopmost = config.get("RAM Recommendation", "3. Display message box on top of all other windows?", true).getBoolean();
            ModConfig.ramlaunch.launchcustomrecommendedtext = config.get("RAM Recommendation", "4. Display custom text in message box if RAM recommendations not met?", false).getBoolean();
            ModConfig.ramlaunch.messageboxtext = config.getString("5. Custom recommendation text", "RAM Recommendation", "You should add more RAM.", "Enter custom text to be shown if RAM recommendation not met. Will only display if 'Display custom text in message box if RAM recommendation not met?' equals true");
            ModConfig.ramgame.chatrecommendedraminmb = config.get("RAM Recommendation", "1. Ram Recommended (IN MB)", 2048).getInt();
            ModConfig.ramgame.chatcheckrecommendedram = config.get("RAM Recommendation", "6. Display warning in game chat if RAM recommendation not met?", true).getBoolean();
            ModConfig.ramgame.chatcustomrecommendedtext = config.get("RAM Recommendation", "7. Customise game chat RAM recommendation message?", false).getBoolean();
            ModConfig.ramgame.chatramcustomtext = config.getString("8. Custom chat message", "RAM Recommendation", "[WARNING] You should assign more RAM to this modpack.", "Enter custom text to be shown in game chat if RAM recommendation not met. Will only display if 'Customise game chat RAM recommendation message?\"' equals true");
            ModConfig.reqram.requiredraminmb = config.get("RAM Requirement", "1. Ram Required (IN MB)", 1024).getInt();
            ModConfig.reqram.checkrequiredram = config.get("RAM Requirement", "2. Check RAM meets requirement?", false).getBoolean();
            ModConfig.reqram.ramreqmessageboxtopmost = config.get("RAM Requirement", "3. Display message box on top of all other windows?", true).getBoolean();
            ModConfig.reqram.customrequiredtext = config.get("RAM Requirement", "4. Display custom text in message box if RAM requirement not met?", false).getBoolean();
            ModConfig.reqram.requiredramcustomtext = config.getString("5. Custom requirement text", "RAM Requirement", "You need more RAM.", "Enter custom text to be shown if RAM requirement not met. Will only display if 'Display custom text in message box if RAM requirement not met?' equals true");
            ModConfig.customg.displaychatgreeting = config.get("Custom Greeting Message", "1. Display custom greeting message when joining a world?", false).getBoolean();
            ModConfig.customg.greetingmessagetext = config.getString("2. Custom greeting message text", "Custom Greeting Message", "Hello there! Welcome to my modpack.", "A message that will be displayed in chat when a game is loaded. Will only display if 'Display custom greeting message when joining a world?' equals true");
            ModConfig.webpage.websiteurl = config.getString("2. URL to webpage", "Display Webpage", "http://minecraft.curseforge.com/projects/config-checker", "Enter URL to be launched. Will only display if 'Open web browser to URL when game loads?' equals true");
            ModConfig.webpage.displaywebsite = config.get("Display Webpage", "1. Open web browser to URL when game loads?", false).getBoolean();
            ModConfig.custommb.messageboxtext = config.getString("3. Custom Messagebox text", "Custom Messagebox", "Hello World!!", "Enter popup text. Will only display if 'Show custom messagebox when game loads?' equals true");
            ModConfig.custommb.displaymessagebox = config.get("Custom Messagebox", "1. Show custom messagebox when game loads?", false).getBoolean();
            ModConfig.custommb.displaymessageboxtopmost = config.get("Custom Messagebox", "2. Display message box on top of all other windows?", true).getBoolean();
            config.save();
            ModConfig.updatemanually();
            JFrame jf = new JFrame();
            jf.setAlwaysOnTop(true);
            try {
                new File("config/Config Checker.cfg").renameTo(new File("config/Config Checker.cfg.old"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(jf, "Unable to delete old file. Please delete it manually from 'Config/Config Checker.cfg'." + e.getMessage());
            }
        }
        catch (Exception error) {
            JFrame jf = new JFrame();
            jf.setAlwaysOnTop(true);
            int action = JOptionPane.showConfirmDialog(jf, "Error transferring settings. Please make sure you do not have the file open in notepad. " + error.getMessage() + ". Would you like to try again?", "Error Transferring Settings", 0);
            if (action == 0) {
                Main.transferoldconfig();
            }
            try {
                new File("config/Config Checker.cfg").renameTo(new File("config/Config Checker.cfg.old"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(jf, "Unable to delete old file. Please delete it manually from 'Config/Config Checker.cfg'." + e.getMessage());
            }
        }
    }

    public void gamelaunchtimout() {
        if (Config.checklaunchtimeout) {
            Timer timer = new Timer();
            final JFrame jf = new JFrame();
            final long launchtimeout = TimeUnit.SECONDS.toMillis(Config.launchtimeoutinseconds);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Config.gamebooting) {
                        if (Config.launchtimeoutmessageboxtopmost) {
                            jf.setAlwaysOnTop(true);
                        }
                        if (Config.displaycustomlaunchtimeoutmessagebox) {
                            JOptionPane.showMessageDialog(jf, Config.customlaunchtimeoutmessageboxtext, "Time Limit Exceeded", 0);
                        } else {
                            JOptionPane.showMessageDialog(jf, "The modpack author has set the launch timeout to " + Main.calculateTime(launchtimeout) + ". This time limit has now been reached. The game will now close.", "Launch Time Limit Exceeded", 0);
                        }
                        FMLCommonHandler.instance().exitJava(1, false);
                    }
                }
            }, launchtimeout);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String calculateTime(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (days == 1L) {
            sb.append(days);
            sb.append(" day ");
        } else if (days != 0L) {
            sb.append(days);
            sb.append(" days ");
        }
        if (hours == 1L) {
            sb.append(hours);
            sb.append(" hour ");
        } else if (hours != 0L) {
            sb.append(hours);
            sb.append(" hours ");
        }
        if (minutes == 1L) {
            sb.append(minutes);
            sb.append(" minute ");
        } else if (minutes != 0L) {
            sb.append(minutes);
            sb.append(" minutes ");
        }
        if (seconds == 1L) {
            sb.append(seconds);
            sb.append(" second ");
        } else if (seconds != 0L) {
            sb.append(seconds);
            sb.append(" seconds ");
        }
        return sb.toString();
    }

    public void launchwebpage() {
        if (Config.launchwebpage) {
            Desktop desktop = Desktop.getDesktop();
            try {
                if (Config.webpageURL.startsWith("http")) {
                    desktop.browse(URI.create(Config.webpageURL));
                } else {
                    desktop.browse(URI.create("http://" + Config.webpageURL));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JFrame jf = new JFrame();
                jf.setAlwaysOnTop(true);
                JOptionPane.showMessageDialog(jf, "Error opening webpage. The error is: " + e.getMessage(), "Error Opening Webpage", 0);
            }
        }
    }

    public void displaycustommessage() {
        if (Config.displaylaunchmessage) {
            JFrame jf = new JFrame();
            if (Config.launchmessagetopmost) {
                jf.setAlwaysOnTop(true);
            }
            JOptionPane.showMessageDialog(jf, Config.launchmessagetext, "Message from Modpack Author", 1);
        }
    }

    public void meetsrecommendedram() {
        int currentraminmb;
        if (Config.checkRecommendedRAM && Config.ramrecommendedinmbonload > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.coulddowithmoreram();
        }
    }

    public void coulddowithmoreram() {
        long RamRecommendedinbytes = Config.ramrecommendedinmbonload * 1024;
        JFrame jf = new JFrame();
        if (Config.RecommendedRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if (Config.DisplayCustomMessageBoxRecommendations) {
            JOptionPane.showMessageDialog(jf, Config.CustomRAMRecommendationsMessageBox, "Memory Warning", 2);
        } else {
            JOptionPane.showMessageDialog(jf, "You have " + Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true) + " of RAM set up for this modpack but the modpack author recommends at least " + Main.humanReadableByteCount(RamRecommendedinbytes * 1024L, true) + ". You may have performance issues unless you change this.", "Memory Warning", 2);
        }
    }

    public void meetsrequiredram() {
        int currentraminmb;
        if (Config.checkRequiredRAM && Config.ramrequiredinmb > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.needmoreram();
        }
    }

    public void needmoreram() {
        long RamRequiredinbytes = Config.ramrequiredinmb * 1024;
        JFrame jf = new JFrame();
        if (Config.RequiredRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if (Config.DisplayCustomMessageBoxRequirements) {
            JOptionPane.showMessageDialog(jf, Config.CustomRAMRequirementsMessageBox, "Memory Error", 0);
        } else {
            JOptionPane.showMessageDialog(jf, "You have " + Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true) + " of RAM set up for this modpack but the modpack author claims at least " + Main.humanReadableByteCount(RamRequiredinbytes * 1024L, true) + " is required for the modpack to run. The game will now close.", "Memory Error", 0);
        }
        FMLCommonHandler.instance().exitJava(1, false);
    }

    public void checkadditionals() {
        if (Config.craftsaddle) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("Saddle_top"), (ResourceLocation)new ResourceLocation("recipes"), (ItemStack)new ItemStack(Items.field_151141_av, 1), (Object[])new Object[]{"LLL", "T T", "   ", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('T'), Blocks.field_150479_bC});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("Saddle_bottom"), (ResourceLocation)new ResourceLocation("recipes"), (ItemStack)new ItemStack(Items.field_151141_av, 1), (Object[])new Object[]{"   ", "LLL", "T T", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('T'), Blocks.field_150479_bC});
        }
    }
}

