/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.mj.MjAPI;
import io.netty.buffer.ByteBuf;
import mekanism.api.MekanismAPI;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.FuelHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsGuiHandler;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.block.states.BlockStateGenerator;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="mekanismgenerators", name="MekanismGenerators", version="9.4.11", dependencies="required-after:mekanism", guiFactory="mekanism.generators.client.gui.GeneratorsGuiFactory", acceptedMinecraftVersions="[1.12,1.13)")
@Mod.EventBusSubscriber
public class MekanismGenerators
implements IModule {
    @SidedProxy(clientSide="mekanism.generators.client.GeneratorsClientProxy", serverSide="mekanism.generators.common.GeneratorsCommonProxy")
    public static GeneratorsCommonProxy proxy;
    @Mod.Instance(value="mekanismgenerators")
    public static MekanismGenerators instance;
    public static Version versionNumber;
    public static MultiblockManager<SynchronizedTurbineData> turbineManager;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GeneratorsBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        GeneratorsItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        GeneratorsBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerBlockRenders();
        proxy.registerItemRenders();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        proxy.loadConfiguration();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        PacketSimpleGui.handlers.add(1, proxy);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GeneratorsGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerRegularTileEntities();
        proxy.registerSpecialTileEntities();
        this.addRecipes();
        for (ItemStack ore : OreDictionary.getOres((String)"dustGold")) {
            RecipeHandler.addMetallurgicInfuserRecipe((InfuseType)InfuseRegistry.get((String)"CARBON"), (int)10, (ItemStack)MekanismUtils.size((ItemStack)ore, (int)4), (ItemStack)GeneratorsItems.Hohlraum.getEmptyItem());
        }
        Mekanism.logger.info("Loaded MekanismGenerators module.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (FuelHandler.BCPresent() && BuildcraftFuelRegistry.fuel != null) {
            for (IFuel s : BuildcraftFuelRegistry.fuel.getFuels()) {
                if (s.getFluid() == null || GasRegistry.containsGas((String)s.getFluid().getFluid().getName())) continue;
                GasRegistry.register((Gas)new Gas(s.getFluid().getFluid()));
            }
            BuildcraftFuelRegistry.fuel.addFuel(MekanismFluids.Ethene.getFluid(), (long)(240.0 * MekanismConfig.general.TO_RF / 20.0 * (double)MjAPI.MJ), 40000);
        }
    }

    public void addRecipes() {
        FuelHandler.addGas((Gas)MekanismFluids.Ethene, (int)MekanismConfig.general.ETHENE_BURN_TIME, (double)(MekanismConfig.general.FROM_H2 + MekanismConfig.generators.bioGeneration * 2.0 * (double)MekanismConfig.general.ETHENE_BURN_TIME));
    }

    public Version getVersion() {
        return versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void writeConfig(ByteBuf dataStream) {
        dataStream.writeDouble(MekanismConfig.generators.advancedSolarGeneration);
        dataStream.writeDouble(MekanismConfig.generators.bioGeneration);
        dataStream.writeDouble(MekanismConfig.generators.heatGeneration);
        dataStream.writeDouble(MekanismConfig.generators.heatGenerationLava);
        dataStream.writeDouble(MekanismConfig.generators.heatGenerationNether);
        dataStream.writeDouble(MekanismConfig.generators.solarGeneration);
        dataStream.writeDouble(MekanismConfig.generators.windGenerationMin);
        dataStream.writeDouble(MekanismConfig.generators.windGenerationMax);
        dataStream.writeInt(MekanismConfig.generators.windGenerationMinY);
        dataStream.writeInt(MekanismConfig.generators.windGenerationMaxY);
        dataStream.writeInt(MekanismConfig.generators.turbineBladesPerCoil);
        dataStream.writeDouble(MekanismConfig.generators.turbineVentGasFlow);
        dataStream.writeDouble(MekanismConfig.generators.turbineDisperserGasFlow);
        dataStream.writeInt(MekanismConfig.generators.condenserRate);
        dataStream.writeDouble(MekanismConfig.generators.energyPerFusionFuel);
        for (BlockStateGenerator.GeneratorType type : BlockStateGenerator.GeneratorType.getGeneratorsForConfig()) {
            dataStream.writeBoolean(MekanismConfig.generators.generatorsManager.isEnabled(type.blockName));
        }
    }

    public void readConfig(ByteBuf dataStream) {
        MekanismConfig.generators.advancedSolarGeneration = dataStream.readDouble();
        MekanismConfig.generators.bioGeneration = dataStream.readDouble();
        MekanismConfig.generators.heatGeneration = dataStream.readDouble();
        MekanismConfig.generators.heatGenerationLava = dataStream.readDouble();
        MekanismConfig.generators.heatGenerationNether = dataStream.readDouble();
        MekanismConfig.generators.solarGeneration = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMin = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMax = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMinY = dataStream.readInt();
        MekanismConfig.generators.windGenerationMaxY = dataStream.readInt();
        MekanismConfig.generators.turbineBladesPerCoil = dataStream.readInt();
        MekanismConfig.generators.turbineVentGasFlow = dataStream.readDouble();
        MekanismConfig.generators.turbineDisperserGasFlow = dataStream.readDouble();
        MekanismConfig.generators.condenserRate = dataStream.readInt();
        MekanismConfig.generators.energyPerFusionFuel = dataStream.readDouble();
        for (BlockStateGenerator.GeneratorType type : BlockStateGenerator.GeneratorType.getGeneratorsForConfig()) {
            MekanismConfig.generators.generatorsManager.setEntry(type.blockName, dataStream.readBoolean());
        }
    }

    public void resetClient() {
        SynchronizedTurbineData.clientRotationMap.clear();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mekanismgenerators")) {
            proxy.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onBlacklistUpdate(MekanismAPI.BoxBlacklistEvent event) {
        MekanismAPI.addBoxBlacklist((Block)GeneratorsBlocks.Generator, (int)5);
        MekanismAPI.addBoxBlacklist((Block)GeneratorsBlocks.Generator, (int)6);
    }

    static {
        versionNumber = new Version(9, 4, 13);
        turbineManager = new MultiblockManager("industrialTurbine");
    }
}

