/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.abilities;

import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataBoolean;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.pymtech.fluids.PTFluids;
import lucraft.mods.pymtech.items.ItemShrunkenSuit;
import lucraft.mods.pymtech.items.PTItems;
import lucraft.mods.pymtech.sounds.PTSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class AbilityShrinkSuit
extends AbilityAction {
    public static final AbilityData<Boolean> NEEDS_PYM_PARTICLES = new AbilityDataBoolean("needs_pym_particles").disableSaving().setSyncType(EnumSync.SELF).enableSetting("advanced", "Determines if you need Pym Particles to shrink the suit");

    public AbilityShrinkSuit(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(NEEDS_PYM_PARTICLES, (Object)true);
    }

    public boolean isUnlocked() {
        return super.isUnlocked() && this.hasArmorOn();
    }

    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        ItemStack stack = new ItemStack(PTItems.SHRUNKEN_SUIT);
        ItemShrunkenSuit.storeSuit(stack, this.entity.func_184582_a(EntityEquipmentSlot.HEAD), this.entity.func_184582_a(EntityEquipmentSlot.CHEST), this.entity.func_184582_a(EntityEquipmentSlot.LEGS), this.entity.func_184582_a(EntityEquipmentSlot.FEET));
        float zLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
        Minecraft.func_71410_x().func_175599_af().field_77023_b = -100.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, 0, 0);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_175599_af().field_77023_b = zLevel;
    }

    public boolean action() {
        if (this.entity instanceof EntityPlayer) {
            PlayerHelper.playSound((World)this.entity.field_70170_p, (EntityPlayer)((EntityPlayer)this.entity), (double)this.entity.field_70165_t, (double)this.entity.field_70163_u, (double)this.entity.field_70161_v, (SoundEvent)PTSoundEvents.BUTTON, (SoundCategory)SoundCategory.PLAYERS);
        }
        if (((Boolean)this.dataManager.get(NEEDS_PYM_PARTICLES)).booleanValue()) {
            ItemStack currentChestplate = this.entity.func_184582_a(EntityEquipmentSlot.CHEST);
            if (currentChestplate.func_190926_b() || !currentChestplate.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                return false;
            }
            FluidStack drainedShrink = ((IFluidHandlerItem)currentChestplate.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(new FluidStack(PTFluids.SHRINK_PYM_PARTICLES, 500), false);
            FluidStack drainedGrow = ((IFluidHandlerItem)currentChestplate.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(new FluidStack(PTFluids.GROW_PYM_PARTICLES, 500), false);
            if (drainedShrink == null || drainedShrink.amount != 500) {
                if (this.entity instanceof EntityPlayer) {
                    ((EntityPlayer)this.entity).func_146105_b((ITextComponent)new TextComponentTranslation("pymtech.info.not_enough_shrink_pp", new Object[0]), true);
                }
                return false;
            }
            if (drainedGrow == null || drainedGrow.amount != 500) {
                if (this.entity instanceof EntityPlayer) {
                    ((EntityPlayer)this.entity).func_146105_b((ITextComponent)new TextComponentTranslation("pymtech.info.not_enough_grow_pp", new Object[0]), true);
                }
                return false;
            }
            ((IFluidHandlerItem)currentChestplate.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(new FluidStack(PTFluids.SHRINK_PYM_PARTICLES, 500), true);
            ((IFluidHandlerItem)currentChestplate.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(new FluidStack(PTFluids.GROW_PYM_PARTICLES, 500), true);
        }
        ItemStack stack = new ItemStack(PTItems.SHRUNKEN_SUIT);
        ItemShrunkenSuit.storeSuit(stack, this.entity.func_184582_a(EntityEquipmentSlot.HEAD), this.entity.func_184582_a(EntityEquipmentSlot.CHEST), this.entity.func_184582_a(EntityEquipmentSlot.LEGS), this.entity.func_184582_a(EntityEquipmentSlot.FEET));
        this.entity.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        this.entity.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
        this.entity.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
        this.entity.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
        if (this.entity instanceof EntityPlayer) {
            PlayerHelper.givePlayerItemStack((EntityPlayer)((EntityPlayer)this.entity), (ItemStack)stack);
        }
        PlayerHelper.playSoundToAll((World)this.entity.field_70170_p, (double)this.entity.field_70165_t, (double)this.entity.field_70163_u, (double)this.entity.field_70161_v, (double)50.0, (SoundEvent)PTSoundEvents.SHRINK, (SoundCategory)SoundCategory.PLAYERS);
        return true;
    }

    public boolean hasArmorOn() {
        return !this.entity.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || !this.entity.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() || !this.entity.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() || !this.entity.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
    }
}

