/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.client.render.entities;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lucraft.mods.pymtech.client.models.CachedRender;
import lucraft.mods.pymtech.client.render.shrunkenstructure.ShrunkenStructureAccess;
import lucraft.mods.pymtech.entities.EntityShrunkenStructure;
import lucraft.mods.pymtech.items.ItemShrunkenStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="pymtech", value={Side.CLIENT})
public class RenderShrunkenStructure
extends Render<EntityShrunkenStructure> {
    public static Map<Long, CachedRender> renders = new HashMap<Long, CachedRender>();

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70173_aa % 600 == 0) {
            renders.clear();
        }
    }

    @SubscribeEvent
    public static void onClientLeaveServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        renders.clear();
    }

    @SubscribeEvent
    public static void onClientJoinServer(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        renders.clear();
    }

    public RenderShrunkenStructure(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(EntityShrunkenStructure entity, double posX, double posY, double posZ, float entityYaw, float partialTicks) {
        if (entity.shrunkenStructure == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
        this.func_110776_a(TextureMap.field_110575_b);
        float scale = entity.prevScale + (entity.getScale() - entity.prevScale) * partialTicks;
        RenderShrunkenStructure.storeAndRender(entity.field_70170_p, entity.func_180425_c(), entity.shrunkenStructure, partialTicks, scale, false);
        GlStateManager.func_179121_F();
    }

    public static boolean renderStructure(long id, BlockPos size, float scale, World world, float partialTicks, boolean trail) {
        if (!renders.containsKey(id)) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179137_b((double)((double)(-size.func_177958_n()) / 2.0), (double)0.0, (double)((double)(-size.func_177952_p()) / 2.0));
        if (!trail) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
        }
        renders.get(id).render(world, partialTicks);
        if (!trail) {
            RenderHelper.func_74519_b();
            GlStateManager.func_179117_G();
        }
        GlStateManager.func_179121_F();
        return true;
    }

    public static void storeAndRender(World world, BlockPos pos, ItemShrunkenStructure.ShrunkenStructure shrunkenStructure, float partialTicks, float scale, boolean trail) {
        if (!renders.containsKey(shrunkenStructure.getId())) {
            CachedRender cachedRender = new CachedRender(DefaultVertexFormats.field_176600_a, (format, buffer, theWorld, thePartialTicks) -> {
                BlockPos size = shrunkenStructure.getSize();
                for (int x = 0; x < size.func_177958_n(); ++x) {
                    for (int y = 0; y < size.func_177956_o(); ++y) {
                        for (int z = 0; z < size.func_177952_p(); ++z) {
                            BlockPos p;
                            IBlockState state;
                            ItemShrunkenStructure.BlockData data = shrunkenStructure.getData()[x][y][z];
                            IBlockState iBlockState = state = data == null ? null : data.getBlock();
                            if (state == null || state.func_177230_c() == Blocks.field_150350_a || state.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
                            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                            if (state.func_185901_i() == EnumBlockRenderType.MODEL) {
                                p = new BlockPos(x, y, z);
                                blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)new ShrunkenStructureAccess(world, pos, shrunkenStructure), blockrendererdispatcher.func_184389_a(state), state, p, buffer, false);
                                continue;
                            }
                            if (state.func_185901_i() != EnumBlockRenderType.LIQUID) continue;
                            p = new BlockPos(x, y, z);
                            blockrendererdispatcher.func_175018_a(state, p, (IBlockAccess)theWorld, buffer);
                        }
                    }
                }
            });
            renders.put(shrunkenStructure.getId(), cachedRender);
            RenderShrunkenStructure.renderStructure(shrunkenStructure.getId(), shrunkenStructure.getSize(), scale, world, partialTicks, trail);
        } else {
            RenderShrunkenStructure.renderStructure(shrunkenStructure.getId(), shrunkenStructure.getSize(), scale, world, partialTicks, trail);
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityShrunkenStructure entity) {
        return TextureMap.field_110575_b;
    }
}

