/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.core;

import lucraft.mods.pymtech.PymTech;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.EFX10;

public class SoundReverbHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static boolean available;
    private static boolean setup;
    private static int auxEffectSlot;
    private static int reverbEffectSlot;
    private static boolean reverbApplied;

    public static void onPlaySound(int soundId) {
        if (!setup) {
            SoundReverbHandler.setupEffects();
            setup = true;
        }
        if (available) {
            SoundReverbHandler.applyEffect(soundId);
        }
    }

    private static void setupEffects() {
        available = ALC10.alcIsExtensionPresent((ALCdevice)AL.getDevice(), (String)"ALC_EXT_EFX");
        if (!available) {
            PymTech.LOGGER.warn("Unable to setup reverb effects, AL EFX not supported!");
            return;
        }
        auxEffectSlot = EFX10.alGenAuxiliaryEffectSlots();
        EFX10.alAuxiliaryEffectSloti((int)auxEffectSlot, (int)3, (int)1);
        reverbEffectSlot = EFX10.alGenEffects();
    }

    private static void applyEffect(int soundId) {
        if (SoundReverbHandler.shouldEcho((World)SoundReverbHandler.MC.field_71441_e)) {
            SoundReverbHandler.applyReverbEffect();
        } else {
            SoundReverbHandler.applyDefaultEffect();
        }
        AL11.alSource3i((int)soundId, (int)131078, (int)auxEffectSlot, (int)0, (int)0);
    }

    private static void applyReverbEffect() {
        if (reverbApplied) {
            return;
        }
        reverbApplied = true;
        EFX10.alEffecti((int)reverbEffectSlot, (int)32769, (int)32768);
        EFX10.alEffectf((int)reverbEffectSlot, (int)6, (float)6.0f);
        EFX10.alAuxiliaryEffectSloti((int)auxEffectSlot, (int)1, (int)reverbEffectSlot);
    }

    private static void applyDefaultEffect() {
        if (!reverbApplied) {
            return;
        }
        reverbApplied = false;
        EFX10.alEffecti((int)reverbEffectSlot, (int)32769, (int)0);
        EFX10.alAuxiliaryEffectSloti((int)auxEffectSlot, (int)1, (int)reverbEffectSlot);
    }

    private static boolean shouldEcho(World world) {
        return false;
    }
}

