/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.entities;

import com.mojang.authlib.GameProfile;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.pymtech.entities.EntityShrunkenStructureTrail;
import lucraft.mods.pymtech.items.ItemShrunkenStructure;
import lucraft.mods.pymtech.items.PTItems;
import lucraft.mods.pymtech.network.MessageSyncStructureEntity;
import lucraft.mods.pymtech.network.PTPacketDispatcher;
import lucraft.mods.pymtech.sounds.PTSoundEvents;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EntityShrunkenStructure
extends Entity {
    private static final DataParameter<Boolean> SHRINKING = EntityDataManager.func_187226_a(EntityShrunkenStructure.class, (DataSerializer)DataSerializers.field_187198_h);
    public ItemShrunkenStructure.ShrunkenStructure shrunkenStructure;
    public float scale;
    public float prevScale;
    public EntityPlayer placer;

    public EntityShrunkenStructure(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.setScale(1.0f);
    }

    public EntityShrunkenStructure(World worldIn, ItemShrunkenStructure.ShrunkenStructure shrunkenStructure) {
        super(worldIn);
        this.shrunkenStructure = shrunkenStructure;
        this.func_70105_a(Math.max((float)this.shrunkenStructure.getSize().func_177958_n() * this.getScale(), (float)this.shrunkenStructure.getSize().func_177952_p()) * this.getScale(), (float)this.shrunkenStructure.getSize().func_177956_o() * this.getScale());
        this.setShrinking(true);
        this.setScale(0.1f);
    }

    public EntityShrunkenStructure(World worldIn, AxisAlignedBB axisAlignedBB, Predicate<BlockPos> predicate, boolean destroy) {
        this(worldIn);
        this.func_70107_b((axisAlignedBB.field_72340_a + axisAlignedBB.field_72336_d) / 2.0, axisAlignedBB.field_72338_b, (axisAlignedBB.field_72339_c + axisAlignedBB.field_72334_f) / 2.0);
        BlockPos size = new BlockPos((int)(axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a), (int)(axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b), (int)(axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c));
        this.func_70105_a(Math.max((float)size.func_177958_n() * this.getScale(), (float)size.func_177952_p()) * this.getScale(), (float)size.func_177956_o() * this.getScale());
        ItemShrunkenStructure.BlockData[][][] blockData = new ItemShrunkenStructure.BlockData[size.func_177958_n()][size.func_177956_o()][size.func_177952_p()];
        int x = 0;
        while ((double)x < axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) {
            int y = 0;
            while ((double)y < axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b) {
                int z = 0;
                while ((double)z < axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) {
                    BlockPos pos = new BlockPos(axisAlignedBB.field_72340_a + (double)x, axisAlignedBB.field_72338_b + (double)y, axisAlignedBB.field_72339_c + (double)z);
                    if (!worldIn.func_175623_d(pos) && predicate.test(pos)) {
                        if (worldIn.func_175625_s(pos) != null) {
                            EntityShrunkenStructure.clearShrunkenStructureItems(worldIn.func_175625_s(pos));
                            blockData[x][y][z] = new ItemShrunkenStructure.BlockData(worldIn.func_180495_p(pos), worldIn.func_175625_s(pos).func_189515_b(new NBTTagCompound()));
                        } else {
                            blockData[x][y][z] = new ItemShrunkenStructure.BlockData(worldIn.func_180495_p(pos), null);
                        }
                        if (destroy) {
                            if (this.field_70170_p.func_175625_s(pos) != null) {
                                this.field_70170_p.func_175713_t(pos);
                            }
                            this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.shrunkenStructure = new ItemShrunkenStructure.ShrunkenStructure(blockData, size);
    }

    public static void clearShrunkenStructureItems(TileEntity tileEntity) {
        block3: {
            block2: {
                if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) break block2;
                IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stack = itemHandler.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof ItemShrunkenStructure) && !(stack.func_77973_b() instanceof ItemShulkerBox)) continue;
                    InventoryHelper.func_180173_a((World)tileEntity.func_145831_w(), (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), (ItemStack)stack);
                    itemHandler.extractItem(i, stack.func_190916_E(), false);
                }
                break block3;
            }
            if (!(tileEntity instanceof IInventory)) break block3;
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemShrunkenStructure) && !(stack.func_77973_b() instanceof ItemShulkerBox)) continue;
                InventoryHelper.func_180173_a((World)tileEntity.func_145831_w(), (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), (ItemStack)stack);
                inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SHRINKING, (Object)true);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public boolean isShrinking() {
        return (Boolean)this.field_70180_af.func_187225_a(SHRINKING);
    }

    public void setShrinking(boolean shrinking) {
        this.field_70180_af.func_187227_b(SHRINKING, (Object)shrinking);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return EnumActionResult.PASS;
        }
        if (player.func_70093_af()) {
            if (this.field_71088_bW == 0) {
                this.shrunkenStructure = ItemShrunkenStructure.rotateCounterclockwise(this.shrunkenStructure);
                this.sync();
                this.field_71088_bW = 10;
            }
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = new ItemStack(PTItems.SHRUNKEN_STRUCTURE);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("ShrunkenStructure", (NBTBase)this.shrunkenStructure.serializeNBT());
        stack.func_77982_d(nbt);
        PlayerHelper.givePlayerItemStack((EntityPlayer)player, (ItemStack)stack);
        this.func_70106_y();
        return EnumActionResult.SUCCESS;
    }

    public void placeBlocks(@Nullable EntityPlayer player) {
        if (this.field_70170_p.field_72995_K || !(this.field_70170_p instanceof WorldServer)) {
            return;
        }
        for (int x = 0; x < this.shrunkenStructure.getSize().func_177958_n(); ++x) {
            for (int y = 0; y < this.shrunkenStructure.getSize().func_177956_o(); ++y) {
                for (int z = 0; z < this.shrunkenStructure.getSize().func_177952_p(); ++z) {
                    EntityPlayer p;
                    NBTTagCompound tileEntity;
                    ItemShrunkenStructure.BlockData data = this.shrunkenStructure.getData()[x][y][z];
                    IBlockState state = data == null ? null : data.getBlock();
                    NBTTagCompound nBTTagCompound = tileEntity = data == null ? null : data.getTileEntityData();
                    if (state == null || state.func_177230_c() == Blocks.field_150350_a) continue;
                    Vec3d origin = new Vec3d((double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p());
                    Vec3d v = new Vec3d((double)(x - this.shrunkenStructure.getSize().func_177958_n() / 2), (double)y, (double)(z - this.shrunkenStructure.getSize().func_177952_p() / 2));
                    BlockPos pos = new BlockPos(origin.field_72450_a + v.field_72450_a, origin.field_72448_b + v.field_72448_b, origin.field_72449_c + v.field_72449_c);
                    IBlockState current = this.field_70170_p.func_180495_p(pos);
                    Object object = p = player == null ? new FakePlayer((WorldServer)this.field_70170_p, new GameProfile(null, "PymTech")) : player;
                    if (current.func_185887_b(this.field_70170_p, pos) == -1.0f || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.field_70170_p, pos, current, p))) {
                        state.func_177230_c().func_176226_b(this.field_70170_p, pos, state, 0);
                        continue;
                    }
                    if (current.func_185887_b(this.field_70170_p, pos) > state.func_185887_b(this.field_70170_p, pos)) {
                        state.func_177230_c().func_176226_b(this.field_70170_p, pos, state, 0);
                        continue;
                    }
                    this.field_70170_p.func_175655_b(pos, true);
                    this.field_70170_p.func_180501_a(pos, state, 2);
                    if (tileEntity == null || this.field_70170_p.func_175625_s(pos) == null) continue;
                    tileEntity.func_74768_a("x", pos.func_177958_n());
                    tileEntity.func_74768_a("y", pos.func_177956_o());
                    tileEntity.func_74768_a("z", pos.func_177952_p());
                    this.field_70170_p.func_175625_s(pos).func_145839_a(tileEntity);
                }
            }
        }
        this.func_70106_y();
    }

    protected void func_70105_a(float width, float height) {
        float w;
        Vec3d pos = this.func_174791_d();
        this.field_70130_N = w = width / 2.0f;
        this.field_70131_O = height;
        this.func_174826_a(new AxisAlignedBB(pos.field_72450_a - (double)w, pos.field_72448_b, pos.field_72449_c - (double)w, pos.field_72450_a + (double)w, pos.field_72448_b + (double)height, pos.field_72449_c + (double)w));
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setShrinking(compound.func_74767_n("Shrinking"));
        this.setScale(compound.func_74760_g("Scale"));
        this.shrunkenStructure = new ItemShrunkenStructure.ShrunkenStructure(compound.func_74775_l("ShrunkenStructure"));
        this.func_70105_a(Math.max((float)this.shrunkenStructure.getSize().func_177958_n() * this.getScale(), (float)this.shrunkenStructure.getSize().func_177952_p()) * this.getScale(), (float)this.shrunkenStructure.getSize().func_177956_o() * this.getScale());
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("Shrinking", this.isShrinking());
        compound.func_74776_a("Scale", this.getScale());
        compound.func_74782_a("ShrunkenStructure", (NBTBase)this.shrunkenStructure.serializeNBT());
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70030_z() {
        double d5;
        double d4;
        double d3;
        double d6;
        boolean flag;
        if (this.shrunkenStructure == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        super.func_70030_z();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double d0 = this.field_70159_w;
        double d1 = this.field_70181_x;
        double d2 = this.field_70179_y;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.field_70145_X = this.field_70170_p.field_72995_K ? false : this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
        if ((flag || this.field_70173_aa % 25 == 0) && this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        this.func_70072_I();
        if (!this.field_70170_p.field_72995_K && (d6 = (d3 = this.field_70159_w - d0) * d3 + (d4 = this.field_70181_x - d1) * d4 + (d5 = this.field_70179_y - d2) * d5) > 0.01) {
            this.field_70160_al = true;
        }
        this.prevScale = this.getScale();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isShrinking() && this.getScale() >= 1.0f) {
                PlayerHelper.playSoundToAll((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (SoundEvent)PTSoundEvents.SHRINK, (SoundCategory)SoundCategory.NEUTRAL);
            }
            if (!this.isShrinking() && this.getScale() <= 0.1f) {
                PlayerHelper.playSoundToAll((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (SoundEvent)PTSoundEvents.GROW, (SoundCategory)SoundCategory.NEUTRAL);
            }
        }
        if (this.isShrinking() && this.getScale() > 0.1f) {
            this.setScale(this.getScale() - 0.05f);
            if (this.field_70173_aa % 2 == 0 && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)new EntityShrunkenStructureTrail(this.field_70170_p, this, 10));
            }
        } else if (!this.isShrinking() && this.getScale() < 1.0f) {
            this.setScale(this.getScale() + 0.05f);
            if (this.field_70173_aa % 2 == 0 && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)new EntityShrunkenStructureTrail(this.field_70170_p, this, 10));
            }
        }
        if (this.getScale() >= 1.0f && !this.isShrinking()) {
            this.placeBlocks(this.placer);
        }
        this.func_70105_a(Math.max((float)this.shrunkenStructure.getSize().func_177958_n() * this.getScale(), (float)this.shrunkenStructure.getSize().func_177952_p()) * this.getScale(), (float)this.shrunkenStructure.getSize().func_177956_o() * this.getScale());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.sync();
    }

    public void sync() {
        if (this.func_130014_f_() instanceof WorldServer) {
            for (EntityPlayer players : ((WorldServer)this.func_130014_f_()).func_73039_n().getTrackingPlayers((Entity)this)) {
                if (!(players instanceof EntityPlayerMP)) continue;
                PTPacketDispatcher.sendTo(new MessageSyncStructureEntity(this), (EntityPlayerMP)players);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="pymtech")
    public static class EventHandler {
        @SubscribeEvent
        public static void onPlayerStartTracking(PlayerEvent.StartTracking e) {
            if (e.getTarget() instanceof EntityShrunkenStructure && e.getEntityPlayer() instanceof EntityPlayerMP) {
                PTPacketDispatcher.sendTo(new MessageSyncStructureEntity((EntityShrunkenStructure)e.getTarget()), (EntityPlayerMP)e.getEntityPlayer());
            }
        }
    }
}

