/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.network;

import com.mojang.realmsclient.util.Pair;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import lucraft.mods.pymtech.entities.EntityShrunkenStructure;
import lucraft.mods.pymtech.items.ItemShrunkenStructure;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncStructureEntity
implements IMessage {
    public int entityId;
    public float scale;
    public ItemShrunkenStructure.ShrunkenStructure shrunkenStructure;

    public MessageSyncStructureEntity() {
    }

    public MessageSyncStructureEntity(EntityShrunkenStructure entity) {
        this.entityId = entity.func_145782_y();
        this.scale = entity.scale;
        this.shrunkenStructure = entity.shrunkenStructure;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.scale = buf.readFloat();
        BlockPos size = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int listSize = buf.readInt();
        ItemShrunkenStructure.BlockData[][][] data = new ItemShrunkenStructure.BlockData[size.func_177958_n()][size.func_177956_o()][size.func_177952_p()];
        for (int i = 0; i < listSize; ++i) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
            byte meta = buf.readByte();
            NBTTagCompound tileEntity = null;
            if (buf.readBoolean()) {
                tileEntity = ByteBufUtils.readTag((ByteBuf)buf);
            }
            BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            data[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] = new ItemShrunkenStructure.BlockData(block.func_176203_a((int)meta), tileEntity);
        }
        this.shrunkenStructure = new ItemShrunkenStructure.ShrunkenStructure(data, size);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeFloat(this.scale);
        buf.writeInt(this.shrunkenStructure.getSize().func_177958_n());
        buf.writeInt(this.shrunkenStructure.getSize().func_177956_o());
        buf.writeInt(this.shrunkenStructure.getSize().func_177952_p());
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (int x = 0; x < this.shrunkenStructure.getSize().func_177958_n(); ++x) {
            for (int y = 0; y < this.shrunkenStructure.getSize().func_177956_o(); ++y) {
                for (int z = 0; z < this.shrunkenStructure.getSize().func_177952_p(); ++z) {
                    ItemShrunkenStructure.BlockData d = this.shrunkenStructure.getData()[x][y][z];
                    if (d == null) continue;
                    list.add(Pair.of((Object)new BlockPos(x, y, z), (Object)d));
                }
            }
        }
        buf.writeInt(list.size());
        for (Pair pair : list) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((ResourceLocation)Block.field_149771_c.func_177774_c((Object)((ItemShrunkenStructure.BlockData)pair.second()).getBlock().func_177230_c())).toString());
            buf.writeByte(((ItemShrunkenStructure.BlockData)pair.second()).getBlock().func_177230_c().func_176201_c(((ItemShrunkenStructure.BlockData)pair.second()).getBlock()));
            buf.writeBoolean(((ItemShrunkenStructure.BlockData)pair.second()).hasTileEntity());
            if (((ItemShrunkenStructure.BlockData)pair.second()).hasTileEntity()) {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((ItemShrunkenStructure.BlockData)pair.second()).getTileEntityData());
            }
            buf.writeInt(((BlockPos)pair.first()).func_177958_n());
            buf.writeInt(((BlockPos)pair.first()).func_177956_o());
            buf.writeInt(((BlockPos)pair.first()).func_177952_p());
        }
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncStructureEntity> {
        public IMessage handleClientMessage(EntityPlayer player, MessageSyncStructureEntity message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(() -> {
                Entity entity;
                if (message != null && ctx != null && (entity = LucraftCore.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_73045_a(message.entityId)) != null && entity instanceof EntityShrunkenStructure) {
                    ((EntityShrunkenStructure)entity).scale = message.scale;
                    ((EntityShrunkenStructure)entity).shrunkenStructure = message.shrunkenStructure;
                }
            });
            return null;
        }
    }
}

