/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.pymtech.tileentities;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.util.energy.EnergyStorageExt;
import lucraft.mods.lucraftcore.util.fluids.FluidTankExt;
import lucraft.mods.lucraftcore.util.fluids.LCFluidUtil;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.pymtech.PTConfig;
import lucraft.mods.pymtech.entities.EntityShrunkenStructure;
import lucraft.mods.pymtech.fluids.PTFluids;
import lucraft.mods.pymtech.sounds.PTSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityStructureShrinker
extends TileEntity
implements ITickable {
    public static final int TANK_CAPACITY = 5000;
    public BlockPos area = new BlockPos(0, 0, 0);
    protected ItemStackHandler fluidSlots = new ItemStackHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack) != null;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.func_190926_b()) {
                return;
            }
            if (slot == 0) {
                ItemStack result = LCFluidUtil.transferFluidFromItemToTank((ItemStack)stack, (FluidTank)TileEntityStructureShrinker.this.fluidTank, (ItemStackHandler)TileEntityStructureShrinker.this.fluidSlots);
                if (!result.func_190926_b()) {
                    TileEntityStructureShrinker.this.fluidTank.update = true;
                    this.setStackInSlot(slot, result);
                    PlayerHelper.playSoundToAll((World)TileEntityStructureShrinker.this.field_145850_b, (double)TileEntityStructureShrinker.this.func_174877_v().func_177958_n(), (double)TileEntityStructureShrinker.this.func_174877_v().func_177956_o(), (double)TileEntityStructureShrinker.this.func_174877_v().func_177952_p(), (double)50.0, (SoundEvent)TileEntityStructureShrinker.this.fluidTank.getFluid().getFluid().getEmptySound(TileEntityStructureShrinker.this.fluidTank.getFluid()), (SoundCategory)SoundCategory.BLOCKS);
                }
            } else {
                ItemStack result = LCFluidUtil.transferFluidFromTankToItem((ItemStack)stack, (FluidTank)TileEntityStructureShrinker.this.fluidTank, (ItemStackHandler)TileEntityStructureShrinker.this.fluidSlots);
                if (!result.func_190926_b()) {
                    TileEntityStructureShrinker.this.fluidTank.update = true;
                    this.setStackInSlot(slot, result);
                    FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)result);
                    if (fluidStack != null) {
                        PlayerHelper.playSoundToAll((World)TileEntityStructureShrinker.this.field_145850_b, (double)TileEntityStructureShrinker.this.func_174877_v().func_177958_n(), (double)TileEntityStructureShrinker.this.func_174877_v().func_177956_o(), (double)TileEntityStructureShrinker.this.func_174877_v().func_177952_p(), (double)50.0, (SoundEvent)fluidStack.getFluid().getFillSound(fluidStack), (SoundCategory)SoundCategory.BLOCKS);
                    }
                }
            }
        }
    };
    public EnergyStorageExt energyStorage = new EnergyStorageExt(100000, 100000, 100000);
    public FluidTankExt fluidTank = new FluidTankExt(5000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == PTFluids.SHRINK_PYM_PARTICLES;
        }
    };
    public boolean showBox;
    private String customName;

    public void changeSettings(BlockPos areaIn, boolean showBox) {
        this.area = areaIn;
        if (this.area.func_177958_n() > PTConfig.STRUCTURE_SHRINKER_LIMIT) {
            this.area = new BlockPos(PTConfig.STRUCTURE_SHRINKER_LIMIT, this.area.func_177956_o(), this.area.func_177952_p());
        }
        if (this.area.func_177958_n() < -PTConfig.STRUCTURE_SHRINKER_LIMIT) {
            this.area = new BlockPos(-PTConfig.STRUCTURE_SHRINKER_LIMIT, this.area.func_177956_o(), this.area.func_177952_p());
        }
        if (this.area.func_177956_o() > PTConfig.STRUCTURE_SHRINKER_LIMIT) {
            this.area = new BlockPos(this.area.func_177958_n(), PTConfig.STRUCTURE_SHRINKER_LIMIT, this.area.func_177952_p());
        }
        if (this.area.func_177956_o() < -PTConfig.STRUCTURE_SHRINKER_LIMIT) {
            this.area = new BlockPos(this.area.func_177958_n(), -PTConfig.STRUCTURE_SHRINKER_LIMIT, this.area.func_177952_p());
        }
        if (this.area.func_177952_p() > PTConfig.STRUCTURE_SHRINKER_LIMIT) {
            this.area = new BlockPos(this.area.func_177958_n(), this.area.func_177956_o(), PTConfig.STRUCTURE_SHRINKER_LIMIT);
        }
        if (this.area.func_177952_p() < -PTConfig.STRUCTURE_SHRINKER_LIMIT) {
            this.area = new BlockPos(this.area.func_177958_n(), this.area.func_177956_o(), -PTConfig.STRUCTURE_SHRINKER_LIMIT);
        }
        this.showBox = showBox;
        this.func_70296_d();
    }

    public void shrink(@Nullable EntityPlayer player) {
        if (!this.canShrink(false) || !(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        EntityPlayer player1 = player != null ? player : new FakePlayer((WorldServer)this.field_145850_b, new GameProfile(null, "PymTech"));
        PlayerHelper.playSoundToAll((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)50.0, (SoundEvent)PTSoundEvents.BUTTON, (SoundCategory)SoundCategory.BLOCKS);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() + 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() + 1), (double)(this.func_174877_v().func_177958_n() + 1 + this.area.func_177958_n()), (double)(this.func_174877_v().func_177956_o() + this.area.func_177956_o()), (double)(this.func_174877_v().func_177952_p() + 1 + this.area.func_177952_p()));
        EntityShrunkenStructure entity = new EntityShrunkenStructure(this.field_145850_b, axisAlignedBB, p -> !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.field_145850_b, p, this.field_145850_b.func_180495_p(p), player1)) && this.field_145850_b.func_180495_p(p).func_185887_b(this.field_145850_b, p) != -1.0f, true);
        entity.setShrinking(true);
        entity.field_70177_z = 90.0f;
        this.field_145850_b.func_72838_d((Entity)entity);
    }

    public boolean canShrink(boolean simulate) {
        if (this.energyStorage.extractEnergy(10000, true) != 10000) {
            return false;
        }
        if (this.fluidTank.getFluidAmount() < 1000) {
            return false;
        }
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() + 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() + 1), (double)(this.func_174877_v().func_177958_n() + 1 + this.area.func_177958_n()), (double)(this.func_174877_v().func_177956_o() + this.area.func_177956_o()), (double)(this.func_174877_v().func_177952_p() + 1 + this.area.func_177952_p()));
        boolean empty = true;
        int x = (int)axisAlignedBB.field_72340_a;
        while ((double)x < axisAlignedBB.field_72336_d) {
            int y = (int)axisAlignedBB.field_72338_b;
            while ((double)y < axisAlignedBB.field_72337_e) {
                int z = (int)axisAlignedBB.field_72339_c;
                while ((double)z < axisAlignedBB.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.field_145850_b.func_175623_d(pos)) {
                        empty = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (empty) {
            return false;
        }
        if (!simulate) {
            this.energyStorage.extractEnergy(10000, false);
            this.fluidTank.drain(1000, true);
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean update = false;
        if (this.energyStorage.update) {
            update = true;
            this.energyStorage.update = false;
        }
        if (this.fluidTank.update) {
            update = true;
            this.fluidTank.update = false;
        }
        if (update) {
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.fluidSlots;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidTank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.area = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("Area"));
        this.fluidSlots.deserializeNBT(compound.func_74775_l("FluidItems"));
        this.energyStorage.deserializeNBT(compound);
        this.fluidTank.readFromNBT(compound.func_74775_l("FluidTank"));
        this.showBox = compound.func_74767_n("ShowBox");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("Area", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.area));
        compound.func_74782_a("FluidItems", (NBTBase)this.fluidSlots.serializeNBT());
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        compound.func_74782_a("FluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        compound.func_74757_a("ShowBox", this.showBox);
        if (this.customName != null && !this.customName.isEmpty()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return super.func_189515_b(compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.area = NBTUtil.func_186861_c((NBTTagCompound)pkt.func_148857_g().func_74775_l("Area"));
        this.energyStorage.deserializeNBT(pkt.func_148857_g());
        this.fluidTank.readFromNBT(pkt.func_148857_g().func_74775_l("FluidTank"));
        this.showBox = pkt.func_148857_g().func_74767_n("ShowBox");
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Area", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.area));
        tag.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        tag.func_74782_a("FluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        tag.func_74757_a("ShowBox", this.showBox);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74782_a("Area", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.area));
        nbt.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        nbt.func_74782_a("FluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("ShowBox", this.showBox);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.showBox) {
            return super.getRenderBoundingBox();
        }
        return super.getRenderBoundingBox().func_72321_a((double)this.area.func_177958_n(), (double)this.area.func_177956_o(), (double)this.area.func_177952_p());
    }

    public void setCustomInventoryName(String name) {
        this.customName = name;
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null && !this.customName.isEmpty() ? new TextComponentString(this.customName) : new TextComponentTranslation("tile.structure_shrinker.name", new Object[0]);
    }
}

