/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="equivalentintegrations")
@Config.LangKey(value="equivalentintegrations.config.title")
public class ModConfig {
    private static final String CATEGORY_GENERAL = "general";
    @Config.Comment(value={"The amount to multiply EMC consumption by in the Transmutation Generator. Does not, directly, affect energy production"})
    @Config.RangeDouble(min=0.01, max=100.0)
    @Config.LangKey(value="equivalentintegrations.config.generatoremcmultiplier")
    public static double generatorEMCMultiplier = 1.0;
    @Config.Comment(value={"The maximum amount of a single item to expose, even if you have enough EMC to make more."})
    @Config.RangeInt(min=64)
    @Config.LangKey(value="equivalentintegrations.config.maximumexposedstacksize")
    public static int maximumExposedStackSize = 1000000;
    @Config.Comment(value={"Whether to expose a Soulbound Talisman linked to an invalid player. Only enable if you know what this means."})
    @Config.LangKey(value="equivalentintegrations.config.exposeinvalidtalisman")
    public static boolean exposeInvalidTalisman = false;
    @Config.Comment(value={"Whether to expose bunch of dummy items. You really don't want to do this."})
    @Config.LangKey(value="equivalentintegrations.config.exposedummytestitems")
    public static boolean exposeDummyTestItems = false;

    @Mod.EventBusSubscriber(modid="equivalentintegrations")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("equivalentintegrations")) {
                ConfigManager.sync((String)"equivalentintegrations", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

