/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.integrations.projecte.ProjectEWrapper;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class OfflineEMCWorldData
extends WorldSavedData {
    public static final String IDENTIFIER = "EquivalentIntegrationsOfflineData";
    private HashMap<UUID, Double> cachedEMCValues = null;

    public OfflineEMCWorldData() {
        super(IDENTIFIER);
    }

    public OfflineEMCWorldData(String string) {
        super(string);
    }

    public boolean hasCachedEMC(UUID uuid) {
        return this.cachedEMCValues != null && this.cachedEMCValues.containsKey(uuid);
    }

    public double getCachedEMC(UUID uuid) {
        if (this.cachedEMCValues != null && this.cachedEMCValues.containsKey(uuid)) {
            return this.cachedEMCValues.get(uuid);
        }
        return 0.0;
    }

    public void setCachedEMC(UUID uuid, double d) {
        if (this.cachedEMCValues == null) {
            this.cachedEMCValues = new HashMap();
        }
        this.cachedEMCValues.put(uuid, d);
        this.func_76185_a();
        if (ProjectEWrapper.instance.isSafe()) {
            EquivalentIntegrationsMod.logger.warn("Setting offline EMC when ProjectEX is installed");
        }
    }

    public void clearCachedEMC(UUID uuid) {
        if (this.cachedEMCValues != null && this.cachedEMCValues.containsKey(uuid)) {
            this.cachedEMCValues.remove(uuid);
            this.func_76185_a();
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.cachedEMCValues = new HashMap();
        if (nbt.func_74764_b("players")) {
            NBTTagCompound players = nbt.func_74775_l("players");
            for (String id : players.func_150296_c()) {
                UUID uuid = UUID.fromString(id);
                double d = players.func_74769_h(id);
                this.cachedEMCValues.put(uuid, d);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        if (this.cachedEMCValues != null) {
            NBTTagCompound players = new NBTTagCompound();
            for (UUID uuid : this.cachedEMCValues.keySet()) {
                players.func_74780_a(uuid.toString(), this.cachedEMCValues.get(uuid).doubleValue());
            }
            compound.func_74782_a("players", (NBTBase)players);
        }
        return compound;
    }

    public static OfflineEMCWorldData get(World world) {
        OfflineEMCWorldData data = (OfflineEMCWorldData)world.func_72943_a(OfflineEMCWorldData.class, IDENTIFIER);
        if (data == null) {
            data = new OfflineEMCWorldData();
            world.func_72823_a(IDENTIFIER, (WorldSavedData)data);
        }
        return data;
    }
}

