/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.block;

import com.mike_caron.equivalentintegrations.item.ModItems;
import com.mike_caron.equivalentintegrations.item.SoulboundTalisman;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TransmutationTileEntityBase
extends TileEntity {
    @Nullable
    protected UUID owner;
    @Nonnull
    protected final ItemStackHandler inventory = this.createInventory();

    @Nonnull
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    protected abstract ItemStackHandler createInventory();

    public boolean hasOwner() {
        return this.owner != null;
    }

    @Nullable
    public String getOwnerName() {
        if (this.owner == null || this.inventory == null) {
            return null;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_77973_b() != ModItems.soulboundTalisman) continue;
            return SoulboundTalisman.getOwnerNameFromStack(stack);
        }
        return null;
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void setOwner(UUID newOwner) {
        if (newOwner != this.owner) {
            UUID oldOwner = this.owner;
            this.owner = newOwner;
            this.onNewOwner(oldOwner);
            if (this.field_145850_b != null) {
                this.func_70296_d();
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
                this.field_145850_b.func_175685_c(this.func_174877_v(), state.func_177230_c(), true);
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("owner")) {
            this.setOwner(UUID.fromString(compound.func_74779_i("owner")));
        } else {
            this.setOwner(null);
        }
        if (compound.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        } else if (compound.func_74764_b("owner")) {
            compound.func_82580_o("owner");
        }
        compound.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void onNewOwner(UUID oldOwner) {
    }

    protected void notifyUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }
}

