/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.block.transmutation_chamber;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.block.TransmutationTileEntityBase;
import com.mike_caron.equivalentintegrations.block.transmutation_chamber.TransmutationChamberItemStackHandler;
import com.mike_caron.equivalentintegrations.item.SoulboundTalisman;
import com.mike_caron.equivalentintegrations.storage.EMCItemHandler;
import com.mike_caron.equivalentintegrations.storage.EmptyItemHandler;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TransmutationChamberTileEntity
extends TransmutationTileEntityBase
implements ITickable {
    private EMCItemHandler emcItemHandler;
    private int type = -1;
    private int ticksSinceLastUpdate = 0;
    private boolean forbidNbt = false;
    private boolean forbidDamaged = false;
    private static final EmptyItemHandler emptyInventory = new EmptyItemHandler();

    public TransmutationChamberTileEntity() {
    }

    public TransmutationChamberTileEntity(int type) {
        this.type = type;
    }

    @Override
    @Nonnull
    protected ItemStackHandler createInventory() {
        return new TransmutationChamberItemStackHandler(this.type == 0){

            protected void onContentsChanged(int slot) {
                if (((TransmutationChamberTileEntity)TransmutationChamberTileEntity.this).field_145850_b.field_72995_K) {
                    return;
                }
                ItemStack stack = this.getStackInSlot(0);
                UUID owner = SoulboundTalisman.getOwnerFromStack(stack);
                TransmutationChamberTileEntity.this.setOwner(owner);
                TransmutationChamberTileEntity.this.func_70296_d();
                TransmutationChamberTileEntity.this.setTransmutationParameters();
            }
        };
    }

    @Override
    protected void onNewOwner(UUID oldOwner) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.createEmcItemHandler(this.owner, this.field_145850_b);
        this.setTransmutationParameters();
    }

    private void createEmcItemHandler(UUID newOwner, World world) {
        if (EquivalentIntegrationsMod.getEmcManager(world) == null) {
            return;
        }
        if (this.emcItemHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.emcItemHandler);
            this.emcItemHandler = null;
        }
        if (newOwner != null) {
            this.emcItemHandler = new EMCItemHandler(newOwner, world, true, this.type == 0);
            MinecraftForge.EVENT_BUS.register((Object)this.emcItemHandler);
        }
    }

    private int getEfficiencyThreshold() {
        ItemStack stack = this.inventory.getStackInSlot(2);
        if (stack.func_190916_E() > 3) {
            return Integer.MAX_VALUE;
        }
        int ret = (int)(10.0 * Math.pow(10.0, stack.func_190916_E()));
        return ret;
    }

    public static int getEfficiencyThreshold(int count) {
        if (count > 3) {
            return Integer.MAX_VALUE;
        }
        return (int)(10.0 * Math.pow(10.0, count));
    }

    private EMCItemHandler.EnumLearning getCanLearn() {
        boolean canLearn;
        ItemStack stack = this.inventory.getStackInSlot(1);
        boolean bl = canLearn = !stack.func_190926_b();
        if (this.type == 0) {
            return canLearn ? EMCItemHandler.EnumLearning.CAN : EMCItemHandler.EnumLearning.CANNOT;
        }
        if (this.type == 1) {
            return canLearn ? EMCItemHandler.EnumLearning.CAN : EMCItemHandler.EnumLearning.SKIP;
        }
        return EMCItemHandler.EnumLearning.CANNOT;
    }

    private void setTransmutationParameters() {
        if (this.emcItemHandler == null) {
            return;
        }
        this.emcItemHandler.setCanLearn(this.getCanLearn());
        this.emcItemHandler.setEfficiencyThreshold(this.getEfficiencyThreshold());
        this.emcItemHandler.setForbidDamaged(this.forbidDamaged);
        this.emcItemHandler.setForbidNbt(this.forbidNbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            if (this.emcItemHandler == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)emptyInventory);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.emcItemHandler);
        }
        return super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.emcItemHandler == null && this.owner != null) {
            this.createEmcItemHandler(this.owner, this.field_145850_b);
            this.notifyUpdate();
        }
        if (this.emcItemHandler != null) {
            ++this.ticksSinceLastUpdate;
            if (this.ticksSinceLastUpdate >= 20) {
                this.setTransmutationParameters();
                this.ticksSinceLastUpdate = 0;
            }
        }
    }

    public boolean getForbidNbt() {
        return this.forbidNbt;
    }

    public boolean getForbidDamage() {
        return this.forbidDamaged;
    }

    public void setForbidNbt(boolean forbid) {
        this.forbidNbt = forbid;
        this.setTransmutationParameters();
        this.func_70296_d();
        this.notifyUpdate();
    }

    public void setForbidDamaged(boolean forbid) {
        this.forbidDamaged = forbid;
        this.setTransmutationParameters();
        this.func_70296_d();
        this.notifyUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.type = compound.func_74764_b("type") ? compound.func_74762_e("type") : 0;
        this.forbidNbt = compound.func_74764_b("forbidNbt") ? compound.func_74767_n("forbidNbt") : false;
        this.forbidDamaged = compound.func_74764_b("forbidDamaged") ? compound.func_74767_n("forbidDamaged") : false;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound ret = super.func_189515_b(compound);
        ret.func_74768_a("type", this.type);
        ret.func_74757_a("forbidDamaged", this.forbidDamaged);
        ret.func_74757_a("forbidNbt", this.forbidNbt);
        return ret;
    }

    public int getType() {
        return this.type;
    }

    public EMCItemHandler getEmcItemHandler() {
        return this.emcItemHandler;
    }
}

