/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.block.transmutation_generator;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.block.TransmutationBlockBase;
import com.mike_caron.equivalentintegrations.block.TransmutationTileEntityBase;
import com.mike_caron.equivalentintegrations.block.transmutation_generator.TransmutationGeneratorTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TransmutationGenerator
extends TransmutationBlockBase {
    public static final String id = "transmutation_generator";
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool GENERATING = PropertyBool.func_177716_a((String)"generating");
    public static final int GUI_ID = 2;

    public TransmutationGenerator() {
        super(id);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GENERATING, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TransmutationGeneratorTileEntity();
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        TransmutationGeneratorTileEntity te = this.getTE((IBlockAccess)world, observerPos);
        if (te != null) {
            te.updateNeighbours();
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TransmutationGeneratorTileEntity te = this.getTE(world, pos);
        if (te != null) {
            te.updateNeighbours();
        }
    }

    @Deprecated
    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TransmutationGeneratorTileEntity tileEntity = this.getTE(worldIn, pos);
        if (tileEntity == null) {
            return this.func_176223_P();
        }
        return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(tileEntity.hasOwner())).func_177226_a((IProperty)GENERATING, (Comparable)Boolean.valueOf(tileEntity.isGenerating()));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, GENERATING});
    }

    @Nullable
    private TransmutationGeneratorTileEntity getTE(IBlockAccess worldIn, BlockPos pos) {
        TileEntity ret = worldIn.func_175625_s(pos);
        if (ret instanceof TransmutationGeneratorTileEntity) {
            return (TransmutationGeneratorTileEntity)ret;
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TransmutationGeneratorTileEntity te = this.getTE((IBlockAccess)worldIn, pos);
        if (te == null) {
            return false;
        }
        playerIn.openGui((Object)EquivalentIntegrationsMod.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        List<String> ret = super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        TransmutationGeneratorTileEntity tileEntity = null;
        if (te instanceof TransmutationTileEntityBase) {
            tileEntity = (TransmutationGeneratorTileEntity)te;
        }
        if (tileEntity != null) {
            ret.add(this.getProducesString(tileEntity));
            ret.add(this.getConsumesString(tileEntity));
        }
        return ret;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TransmutationGeneratorTileEntity te = this.getTE((IBlockAccess)world, data.getPos());
        if (te == null) {
            return;
        }
        probeInfo.vertical().text(this.getProducesString(te)).text(this.getConsumesString(te));
    }

    private String getProducesString(TransmutationGeneratorTileEntity tileEntity) {
        StringBuilder ret = new StringBuilder();
        ret.append(new TextComponentTranslation("term.equivalentintegrations.produces", new Object[0]).func_150254_d()).append(" ").append(tileEntity.getPowerPerTick()).append(" ").append(new TextComponentTranslation("term.equivalentintegrations.fept", new Object[0]).func_150254_d());
        return ret.toString();
    }

    private String getConsumesString(TransmutationGeneratorTileEntity tileEntity) {
        StringBuilder ret = new StringBuilder();
        ret.append(new TextComponentTranslation("term.equivalentintegrations.consumes", new Object[0]).func_150254_d()).append(" ").append(tileEntity.getEMCPerTick()).append(" ").append(new TextComponentTranslation("term.equivalentintegrations.emcpt", new Object[0]).func_150254_d());
        return ret.toString();
    }
}

