/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.block.transmutation_generator;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.block.transmutation_generator.TransmutationGeneratorContainer;
import com.mike_caron.equivalentintegrations.block.transmutation_generator.TransmutationGeneratorTileEntity;
import com.mike_caron.equivalentintegrations.item.ModItems;
import com.mike_caron.equivalentintegrations.network.CtoSMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TransmutationGeneratorContainerGui
extends GuiContainer {
    public static final int WIDTH = 182;
    public static final int HEIGHT = 154;
    public static final int INCREASE_ID = 1;
    public static final int DECREASE_ID = 2;
    public static final int POWER_ID = 3;
    public static final int FONT_COLOUR = 0x404040;
    private boolean shiftHeld;
    private boolean altHeld;
    private boolean ctrlHeld;
    private boolean lastShiftHeld;
    private boolean lastAltHeld;
    private boolean lastCtrlHeld;
    private final TransmutationGeneratorTileEntity tileEntity;
    private final TransmutationGeneratorContainer container;
    private GuiButton decreaseButton;
    private GuiButton increaseButton;
    private PowerButton powerButton;
    private static final ResourceLocation background = new ResourceLocation("equivalentintegrations", "textures/gui/transmutation_generator_gui.png");

    public TransmutationGeneratorContainerGui(TransmutationGeneratorTileEntity tileEntity, TransmutationGeneratorContainer container) {
        super((Container)container);
        this.field_146999_f = 182;
        this.field_147000_g = 154;
        this.tileEntity = tileEntity;
        this.container = container;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int amt = this.getDeltaAmt();
        this.decreaseButton = new GuiButton(2, this.field_147003_i + 83, this.field_147009_r + 25, 30, 20, "-" + amt);
        this.field_146292_n.add(this.decreaseButton);
        this.powerButton = new PowerButton(3, this.field_147003_i + 118, this.field_147009_r + 25);
        this.field_146292_n.add(this.powerButton);
        this.increaseButton = new GuiButton(1, this.field_147003_i + 143, this.field_147009_r + 25, 30, 20, "+" + amt);
        this.field_146292_n.add(this.increaseButton);
        this.updateGui(true);
    }

    private void updateGui(boolean labels) {
        int amt = this.getDeltaAmt();
        if (labels) {
            this.decreaseButton.field_146126_j = "-" + amt;
            this.increaseButton.field_146126_j = "+" + amt;
        }
        this.decreaseButton.field_146124_l = this.tileEntity.getPowerPerTick() - amt > 0;
        this.increaseButton.field_146124_l = this.tileEntity.getPowerPerTick() + amt <= 50000;
        this.powerButton.setState(this.tileEntity.getGenerating());
    }

    private int getDeltaAmt() {
        int amt = 10;
        if (this.shiftHeld) {
            amt *= 10;
        }
        if (this.ctrlHeld) {
            amt *= 5;
        }
        if (this.altHeld) {
            amt /= 2;
        }
        return amt;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        this.lastShiftHeld = this.shiftHeld;
        this.lastAltHeld = this.altHeld;
        this.lastCtrlHeld = this.ctrlHeld;
        this.shiftHeld = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        this.altHeld = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
        boolean bl = this.ctrlHeld = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (this.shiftHeld != this.lastShiftHeld || this.altHeld != this.lastAltHeld || this.ctrlHeld != this.lastCtrlHeld) {
            this.updateGui(true);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(new TextComponentTranslation("container.transmutation_generator.title", new Object[0]).func_150260_c(), 8, 6, 0x404040);
        String powerPerTick = String.format("%d", this.tileEntity.getPowerPerTick());
        int w = this.field_146289_q.func_78256_a(powerPerTick);
        int x = 128 - w / 2;
        this.field_146289_q.func_78276_b(powerPerTick, x, 53, 0x404040);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateGui(false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (!button.field_146124_l) {
            return;
        }
        switch (button.field_146127_k) {
            case 1: {
                int amt = this.getDeltaAmt();
                if (amt + this.tileEntity.getPowerPerTick() >= 50000) break;
                CtoSMessage msg = new CtoSMessage(this.tileEntity.func_145831_w().field_73011_w.getDimension(), this.tileEntity.func_174877_v(), amt);
                EquivalentIntegrationsMod.networkWrapper.sendToServer((IMessage)msg);
                break;
            }
            case 2: {
                int amt = -this.getDeltaAmt();
                if (amt + this.tileEntity.getPowerPerTick() <= 0) break;
                CtoSMessage msg = new CtoSMessage(this.tileEntity.func_145831_w().field_73011_w.getDimension(), this.tileEntity.func_174877_v(), amt);
                EquivalentIntegrationsMod.networkWrapper.sendToServer((IMessage)msg);
                break;
            }
            case 3: {
                boolean onOff = !this.tileEntity.getGenerating();
                CtoSMessage msg = new CtoSMessage(this.tileEntity.func_145831_w().field_73011_w.getDimension(), this.tileEntity.func_174877_v(), CtoSMessage.KindEnum.OnOff, onOff);
                EquivalentIntegrationsMod.networkWrapper.sendToServer((IMessage)msg);
            }
        }
    }

    public List<String> func_191927_a(ItemStack stack) {
        List ret = super.func_191927_a(stack);
        if (stack.func_77973_b() == ModItems.efficiencyCatalyst) {
            String eff;
            switch (stack.func_190916_E()) {
                case 0: {
                    eff = "unknown";
                    break;
                }
                case 1: {
                    eff = "1";
                    break;
                }
                case 2: {
                    eff = "1/2";
                    break;
                }
                case 3: {
                    eff = "1/3";
                    break;
                }
                default: {
                    eff = "1/4";
                }
            }
            int pos = 2;
            ret.add(pos, TextFormatting.GOLD + new TextComponentTranslation("container.transmutation_generator.efficiency", new Object[0]).func_150254_d() + TextFormatting.RESET + " " + eff);
        }
        return ret;
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (this.inBounds(mouseX, mouseY, this.increaseButton) || this.inBounds(mouseX, mouseY, this.decreaseButton)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(new TextComponentTranslation("container.transmutation_generator.mod1", new Object[0]).func_150254_d());
            text.add(new TextComponentTranslation("container.transmutation_generator.mod2", new Object[0]).func_150254_d());
            text.add(new TextComponentTranslation("container.transmutation_generator.mod3", new Object[0]).func_150254_d());
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else if (this.inBounds(mouseX, mouseY, this.powerButton)) {
            ArrayList<String> text = new ArrayList<String>();
            if (this.tileEntity.getGenerating()) {
                text.add(new TextComponentTranslation("container.transmutation_generator.poweroff", new Object[0]).func_150254_d());
            } else {
                text.add(new TextComponentTranslation("container.transmutation_generator.poweron", new Object[0]).func_150254_d());
            }
            this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
        } else {
            super.func_191948_b(mouseX, mouseY);
        }
    }

    private boolean inBounds(int mouseX, int mouseY, GuiButton button) {
        return this.inBounds(mouseX, mouseY, button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g);
    }

    private boolean inBounds(int mouseX, int mouseY, int bx, int by, int bw, int bh) {
        return mouseX >= bx && mouseX < bx + bw && mouseY >= by && mouseY < by + bh;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @SideOnly(value=Side.CLIENT)
    public class PowerButton
    extends GuiButton {
        private boolean state;

        public PowerButton(int buttonID, int posX, int posY) {
            super(buttonID, posX, posY, 20, 20, "");
            this.state = false;
        }

        public boolean getState() {
            return this.state;
        }

        public void setState(boolean newState) {
            this.state = newState;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            mc.func_110434_K().func_110577_a(background);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int ty = this.state ? 0 : 16;
            this.func_73729_b(this.field_146128_h + 2, this.field_146129_i + 2, 192, ty, 16, 16);
        }
    }
}

