/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.block.transmutation_generator;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.ModConfig;
import com.mike_caron.equivalentintegrations.block.TransmutationTileEntityBase;
import com.mike_caron.equivalentintegrations.block.transmutation_generator.TransmutationGeneratorStackHandler;
import com.mike_caron.equivalentintegrations.item.SoulboundTalisman;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class TransmutationGeneratorTileEntity
extends TransmutationTileEntityBase
implements ITickable,
IEnergyStorage {
    boolean generating = false;
    boolean generatedLastTick = false;
    int powerPerTick = 10;
    int buffer;
    double internalEmcBuffer;
    private final List<IEnergyStorage> validOutputs = new ArrayList<IEnergyStorage>(6);
    private boolean neverUpdatedNeighbours = true;
    int timer = 0;
    int totalFrames;
    long totalNanoseconds;

    public static float getEfficiencyRaw(int num) {
        switch (num) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 2.0f;
            }
            case 3: {
                return 3.0f;
            }
        }
        return 4.0f;
    }

    @Override
    @Nonnull
    protected ItemStackHandler createInventory() {
        return new TransmutationGeneratorStackHandler(){

            protected void onContentsChanged(int slot) {
                if (((TransmutationGeneratorTileEntity)TransmutationGeneratorTileEntity.this).field_145850_b.field_72995_K) {
                    return;
                }
                ItemStack stack = this.getStackInSlot(0);
                UUID owner = SoulboundTalisman.getOwnerFromStack(stack);
                TransmutationGeneratorTileEntity.this.setOwner(owner);
                TransmutationGeneratorTileEntity.this.func_70296_d();
            }
        };
    }

    public int getPowerPerTick() {
        return this.powerPerTick;
    }

    public void setPowerPerTick(int ppt) {
        if (ppt > 0 && ppt < 50000) {
            this.powerPerTick = ppt;
            this.func_70296_d();
            this.notifyUpdate();
        }
    }

    public boolean isGenerating() {
        return this.generatedLastTick;
    }

    public boolean getGenerating() {
        return this.generating;
    }

    public void setGenerating(boolean generating) {
        this.generating = generating;
        this.func_70296_d();
        this.notifyUpdate();
    }

    @Override
    protected void onNewOwner(UUID oldOwner) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (oldOwner != null && this.internalEmcBuffer > 0.0) {
            this.refundEmc(oldOwner);
        }
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    private float getEfficiency() {
        ItemStack stack = this.inventory.getStackInSlot(1);
        double mult = ModConfig.generatorEMCMultiplier;
        if (mult <= 0.0) {
            mult = 0.01;
        }
        return (float)((double)TransmutationGeneratorTileEntity.getEfficiencyRaw(stack.func_190916_E()) / mult);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.generating = compound.func_74764_b("generating") ? compound.func_74767_n("generating") : false;
        this.buffer = compound.func_74764_b("buffer") ? compound.func_74762_e("buffer") : 0;
        this.powerPerTick = compound.func_74764_b("powerPerTick") ? compound.func_74762_e("powerPerTick") : 10;
        this.generatedLastTick = compound.func_74764_b("generatedLastTick") ? compound.func_74767_n("generatedLastTick") : false;
        this.internalEmcBuffer = compound.func_74764_b("internalEmc") ? compound.func_74769_h("internalEmc") : 0.0;
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound ret = super.func_189515_b(compound);
        ret.func_74757_a("generatedLastTick", this.generatedLastTick);
        ret.func_74757_a("generating", this.generating);
        ret.func_74768_a("buffer", this.buffer);
        ret.func_74768_a("powerPerTick", this.powerPerTick);
        ret.func_74780_a("internalEmc", this.internalEmcBuffer);
        return ret;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.neverUpdatedNeighbours) {
            this.updateNeighbours();
            this.neverUpdatedNeighbours = false;
        }
        boolean needsUpdate = this.pushEnergy();
        long startTime = System.nanoTime();
        needsUpdate = this.generateEnergy() || needsUpdate;
        long delta = System.nanoTime() - startTime;
        if (needsUpdate) {
            this.notifyUpdate();
        }
        this.totalNanoseconds += delta;
        ++this.totalFrames;
        ++this.timer;
        if (this.timer % 35 == 0) {
            this.totalFrames = 0;
            this.totalNanoseconds = 0L;
        }
    }

    public void updateNeighbours() {
        this.determineOutputs();
    }

    private void determineOutputs() {
        this.validOutputs.clear();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IEnergyStorage energyStorage;
            BlockPos neighbour = this.func_174877_v().func_177972_a(facing);
            EnumFacing theirFacing = facing.func_176734_d();
            TileEntity other = this.field_145850_b.func_175625_s(neighbour);
            if (other == null || !other.hasCapability(CapabilityEnergy.ENERGY, theirFacing) || !(energyStorage = (IEnergyStorage)other.getCapability(CapabilityEnergy.ENERGY, theirFacing)).canReceive()) continue;
            this.validOutputs.add(energyStorage);
        }
    }

    private boolean pushEnergy() {
        if (this.buffer <= 0) {
            return false;
        }
        List<IEnergyStorage> toSend = this.validOutputs;
        boolean isDirty = false;
        if (toSend.size() > 0) {
            int perBuffer = Math.floorDiv(this.buffer, toSend.size());
            if (perBuffer < 1) {
                perBuffer = 1;
            }
            for (IEnergyStorage energyStorage : toSend) {
                int sent;
                if (this.buffer <= 0) break;
                if (perBuffer < this.buffer) {
                    perBuffer = this.buffer;
                }
                if ((sent = energyStorage.receiveEnergy(perBuffer, false)) > 0) {
                    isDirty = true;
                }
                this.buffer -= sent;
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
        return false;
    }

    private boolean generateEnergy() {
        boolean prevGenerating = this.isGenerating();
        this.generatedLastTick = false;
        if (this.generating) {
            double emcToConsume;
            float energyModifier = this.getEfficiency();
            int energyToGet = this.getMaxEnergyStored() - this.buffer;
            if (energyToGet > this.powerPerTick) {
                energyToGet = this.powerPerTick;
            }
            if (this.internalEmcBuffer < (emcToConsume = (double)((float)energyToGet / energyModifier))) {
                this.fillEmcBuffer();
            }
            if (!(this.internalEmcBuffer < emcToConsume)) {
                this.internalEmcBuffer -= emcToConsume;
                this.buffer += energyToGet;
                this.generatedLastTick = true;
                this.func_70296_d();
            }
        } else if (this.owner != null && this.internalEmcBuffer > 0.0) {
            this.refundEmc(this.owner);
        }
        return this.isGenerating() != prevGenerating;
    }

    private void refundEmc(UUID owner) {
        if (EquivalentIntegrationsMod.getEmcManager(this.field_145850_b) != null) {
            EquivalentIntegrationsMod.getEmcManager(this.field_145850_b).depositEMC(this.field_145850_b, owner, (long)this.internalEmcBuffer);
            this.internalEmcBuffer = 0.0;
        }
    }

    private void fillEmcBuffer() {
        if (this.owner == null) {
            return;
        }
        float energyModifier = this.getEfficiency();
        long emcToGet = (long)Math.ceil((float)(this.powerPerTick * 20) / energyModifier);
        emcToGet = EquivalentIntegrationsMod.getEmcManager(this.field_145850_b).withdrawEMC(this.field_145850_b, this.owner, emcToGet);
        this.internalEmcBuffer += (double)emcToGet;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int actualExtract = maxExtract;
        if (actualExtract > this.buffer) {
            actualExtract = this.buffer;
        }
        if (!simulate) {
            this.buffer -= actualExtract;
            this.func_70296_d();
        }
        return actualExtract;
    }

    public int getEnergyStored() {
        return this.buffer;
    }

    public int getMaxEnergyStored() {
        return Math.max(this.buffer, this.powerPerTick * 20 * 10);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public float getEMCPerTick() {
        return (float)Math.round((float)this.powerPerTick / this.getEfficiency() * 100.0f) / 100.0f;
    }
}

