/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.impl;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.OfflineEMCWorldData;
import com.mike_caron.equivalentintegrations.api.events.EMCChangedEvent;
import com.mike_caron.equivalentintegrations.integrations.projecte.ProjectEWrapper;
import com.mike_caron.equivalentintegrations.storage.EMCInventory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.event.EMCRemapEvent;
import moze_intel.projecte.api.event.PlayerAttemptLearnEvent;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import scala.Tuple2;

@Mod.EventBusSubscriber
public class ManagedEMCManager {
    private static int TICK_DELAY = 60;
    private static int EMC_CHECK_DELAY = 5;
    private World world;
    private final HashMap<UUID, EMCInventory> emcInventories = new HashMap();
    private HashMap<UUID, Integer> dirtyPlayers = new HashMap();
    private HashMap<UUID, Double> lastKnownEmc = new HashMap();
    private HashSet<UUID> updateEmc = new HashSet();
    private final HashMap<Tuple2<Item, Integer>, Long> emcValues = new HashMap();
    private final Lock lock = new ReentrantLock();
    private int emcCheckTimer = 0;

    public ManagedEMCManager(World world) {
        this.world = world;
    }

    public double getEMC(@Nonnull World world, @Nonnull UUID owner) {
        double ret = -1.0;
        if (world.field_72995_K) {
            return ProjectEWrapper.instance.getEmc(world, owner);
        }
        if (ProjectEWrapper.instance.isSafe()) {
            ret = ProjectEWrapper.instance.getEmc(world, owner);
        } else {
            EntityPlayerMP player = this.getEntityPlayerMP(owner);
            if (player == null && OfflineEMCWorldData.get(world).hasCachedEMC(owner)) {
                EquivalentIntegrationsMod.debugLog("Retrieving cached EMC value for {}", owner);
                ret = OfflineEMCWorldData.get(world).getCachedEMC(owner);
            }
            if (ret == -1.0) {
                EquivalentIntegrationsMod.debugLog("Retrieving live EMC value for {}", owner);
                ret = ProjectEWrapper.instance.getEmc(world, owner);
            }
        }
        if (!this.lastKnownEmc.containsKey(owner)) {
            this.lastKnownEmc.put(owner, 0.0);
        }
        if (this.lastKnownEmc.get(owner) != ret) {
            this.lastKnownEmc.put(owner, ret);
            if (!ProjectEWrapper.instance.isSafe()) {
                OfflineEMCWorldData.get(world).setCachedEMC(owner, ret);
            }
            this.updateEmc.add(owner);
        }
        EquivalentIntegrationsMod.debugLog("Returned EMC value: {}", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEMC(@Nonnull World world, @Nonnull UUID owner, double emc) {
        if (world.field_72995_K) {
            throw new IllegalStateException("Unable to modify EMC on client side");
        }
        this.lock.lock();
        try {
            double currentEmc = this.getEMC(world, owner);
            if (emc != currentEmc) {
                if (ProjectEWrapper.instance.isSafe()) {
                    ProjectEWrapper.instance.setEmc(world, owner, emc);
                    this.markDirty(owner);
                } else {
                    EntityPlayerMP player = this.getEntityPlayerMP(owner);
                    if (player != null) {
                        ProjectEWrapper.instance.setEmc(world, owner, emc);
                        this.markDirty(owner);
                    } else {
                        OfflineEMCWorldData.get(world).setCachedEMC(owner, emc);
                    }
                }
                this.lastKnownEmc.put(owner, emc);
                this.updateEmc.add(owner);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long withdrawEMC(@Nonnull World world, @Nonnull UUID owner, long amt) {
        if (world.field_72995_K) {
            throw new IllegalStateException("Unable to modify EMC on client side");
        }
        this.lock.lock();
        try {
            double newEmc;
            double currentEmc = this.getEMC(world, owner);
            if ((double)amt > currentEmc) {
                amt = (long)currentEmc;
            }
            if ((newEmc = currentEmc - (double)amt) != currentEmc) {
                this.setEMC(world, owner, newEmc);
            }
            long l = amt;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void depositEMC(@Nonnull World world, @Nonnull UUID owner, long amt) {
        if (world.field_72995_K) {
            throw new IllegalStateException("Unable to modify EMC on client side");
        }
        this.lock.lock();
        try {
            double currentEmc = this.getEMC(world, owner);
            double newEmc = currentEmc + (double)amt;
            if (newEmc != currentEmc) {
                this.setEMC(world, owner, newEmc);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(@Nonnull World world) {
        if (world.field_72995_K) {
            return;
        }
        this.lock.lock();
        try {
            Iterator<UUID> keys = this.dirtyPlayers.keySet().iterator();
            while (keys.hasNext()) {
                UUID player = keys.next();
                int ticks = this.dirtyPlayers.get(player);
                if (--ticks <= 0) {
                    keys.remove();
                    EntityPlayerMP playermp = this.getEntityPlayerMP(player);
                    if (playermp == null) continue;
                    ProjectEWrapper.instance.sync(playermp);
                    continue;
                }
                this.dirtyPlayers.put(player, ticks);
            }
            if (--this.emcCheckTimer <= 0) {
                this.emcCheckTimer = EMC_CHECK_DELAY;
                for (UUID player : this.lastKnownEmc.keySet()) {
                    this.getEMC(world, player);
                }
            }
            for (UUID player : this.updateEmc) {
                double emc = this.lastKnownEmc.get(player);
                MinecraftForge.EVENT_BUS.post((Event)new EMCChangedEvent(player, emc));
            }
            this.updateEmc.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerLoggedIn(UUID owner) {
        if (this.world.field_72995_K) {
            return;
        }
        if (ProjectEWrapper.instance.isSafe()) {
            return;
        }
        this.lock.lock();
        try {
            OfflineEMCWorldData data = OfflineEMCWorldData.get(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_());
            if (data.hasCachedEMC(owner)) {
                ProjectEWrapper.instance.setEmc(this.world, owner, data.getCachedEMC(owner));
                EntityPlayerMP player = this.getEntityPlayerMP(owner);
                ProjectEWrapper.instance.sync(player);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEmcValue(ItemStack stack) {
        this.lock.lock();
        try {
            if (!stack.func_77984_f() && !stack.func_77942_o()) {
                Tuple2 key = new Tuple2((Object)stack.func_77973_b(), (Object)stack.func_77960_j());
                if (!this.emcValues.containsKey(key)) {
                    long value = EMCHelper.getEmcValue((ItemStack)stack);
                    this.emcValues.put((Tuple2<Item, Integer>)key, value);
                }
                long l = this.emcValues.get(key);
                return l;
            }
            long l = EMCHelper.getEmcValue((ItemStack)stack);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getEmcSellValue(ItemStack stack) {
        return EMCHelper.getEmcSellValue((ItemStack)stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EMCInventory getEMCInventory(@Nonnull World world, UUID owner) {
        this.lock.lock();
        try {
            if (!this.emcInventories.containsKey(owner)) {
                EMCInventory inv = new EMCInventory(world, owner, this);
                MinecraftForge.EVENT_BUS.register((Object)inv);
                this.emcInventories.put(owner, inv);
            }
            EMCInventory eMCInventory = this.emcInventories.get(owner);
            return eMCInventory;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void bustCache() {
        if (this.world.field_72995_K) {
            return;
        }
        this.lock.lock();
        try {
            this.emcValues.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void markDirty(UUID owner) {
        if (this.world.field_72995_K) {
            return;
        }
        if (!this.dirtyPlayers.containsKey(owner)) {
            this.dirtyPlayers.put(owner, TICK_DELAY);
        }
    }

    @Nullable
    private EntityPlayerMP getEntityPlayerMP(UUID owner) {
        if (this.world.field_72995_K) {
            return null;
        }
        EntityPlayerMP player = null;
        MinecraftServer server = this.world.func_73046_m();
        if (server != null) {
            player = server.func_184103_al().func_177451_a(owner);
        }
        return player;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        this.tick(event.world);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UUID owner = event.player.func_110124_au();
        this.playerLoggedIn(owner);
    }

    public void onEmcRemap(EMCRemapEvent event) {
        this.bustCache();
    }

    public boolean hasKnowledge(@Nonnull World world, @Nonnull UUID owner, @Nonnull ItemStack stack) {
        EMCInventory inv = this.getEMCInventory(world, owner);
        ItemStack ideal = this.getIdeal(stack);
        return inv.itemKnown(ideal);
    }

    public boolean tryLearn(@Nonnull World world, @Nonnull UUID owner, @Nonnull ItemStack stack, boolean simulate) {
        EntityPlayer player;
        EMCInventory inv = this.getEMCInventory(world, owner);
        if (!simulate) {
            stack = this.getIdeal(stack);
        }
        if ((player = world.func_152378_a(owner)) != null && !MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptLearnEvent(player, stack))) {
            return simulate || ProjectEWrapper.instance.addKnowledge(world, owner, stack);
        }
        return false;
    }

    public void unload() {
        this.lock.lock();
        try {
            for (EMCInventory inv : this.emcInventories.values()) {
                MinecraftForge.EVENT_BUS.unregister((Object)inv);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private ItemStack getIdeal(ItemStack stack) {
        ItemStack idealStack = stack.func_77946_l();
        if (idealStack.func_190916_E() != 1) {
            idealStack.func_190920_e(1);
        }
        if (ItemHelper.isDamageable((ItemStack)idealStack)) {
            idealStack.func_77964_b(0);
        }
        if (!NBTWhitelist.shouldDupeWithNBT((ItemStack)idealStack)) {
            idealStack.func_77982_d(null);
        }
        return idealStack;
    }
}

