/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.integrations.projecte;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.integrations.projecte.ProjectEXWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ProjectEWrapper {
    public static final ProjectEWrapper instance = ProjectEWrapper.getInstance();
    private ITransmutationProxy transmutationProxy = ProjectEAPI.getTransmutationProxy();

    protected ProjectEWrapper() {
    }

    private static ProjectEWrapper getInstance() {
        if (Loader.isModLoaded((String)"projectex")) {
            ProjectEXWrapper wrapper = new ProjectEXWrapper();
            try {
                wrapper.test();
                return wrapper;
            }
            catch (NoClassDefFoundError er) {
                EquivalentIntegrationsMod.logger.error("Tried to instantiate ProjectEX API, but failed. Try updating Project-EX!", (Throwable)er);
            }
        }
        return new ProjectEWrapper();
    }

    public boolean isSafe() {
        return false;
    }

    public double getEmc(@Nonnull World world, @Nonnull UUID owner) {
        IKnowledgeProvider provider = this.getKnowledgeProvider(world, owner);
        return provider.getEmc();
    }

    public double getEmc(@Nonnull EntityPlayer player) {
        IKnowledgeProvider provider = this.getKnowledgeProvider(player);
        return provider.getEmc();
    }

    public void setEmc(@Nonnull World world, @Nonnull UUID owner, double emc) {
        IKnowledgeProvider provider = this.getKnowledgeProvider(world, owner);
        provider.setEmc(emc);
    }

    public void setEmc(@Nonnull EntityPlayer player, double emc) {
        IKnowledgeProvider provider = this.getKnowledgeProvider(player);
        provider.setEmc(emc);
    }

    public void sync(EntityPlayerMP playerMP) {
        IKnowledgeProvider provider = this.getKnowledgeProvider((EntityPlayer)playerMP);
        provider.sync(playerMP);
    }

    public boolean hasKnowledge(@Nonnull World world, @Nonnull UUID owner, @Nonnull ItemStack stack) {
        IKnowledgeProvider provider = this.getKnowledgeProvider(world, owner);
        return provider.hasKnowledge(stack);
    }

    public boolean hasKnowledge(@Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        IKnowledgeProvider provider = this.getKnowledgeProvider(player);
        return provider.hasKnowledge(stack);
    }

    public boolean addKnowledge(@Nonnull World world, @Nonnull UUID owner, @Nonnull ItemStack stack) {
        IKnowledgeProvider provider = this.getKnowledgeProvider(world, owner);
        boolean ret = provider.addKnowledge(stack);
        EntityPlayer player = world.func_152378_a(owner);
        if (player instanceof EntityPlayerMP) {
            provider.sync((EntityPlayerMP)player);
        }
        return ret;
    }

    public void cleanupKnowledge(EntityPlayerMP player) {
        IKnowledgeProvider knowledge = this.getKnowledgeProvider((EntityPlayer)player);
        ArrayList oldKnowledge = new ArrayList(knowledge.getKnowledge());
        knowledge.clearKnowledge();
        for (ItemStack stack : oldKnowledge) {
            if (stack.func_77984_f() && stack.func_77951_h()) {
                stack.func_77964_b(0);
            }
            if (stack.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT((ItemStack)stack)) {
                stack.func_77982_d(null);
            }
            if (knowledge.hasKnowledge(stack)) continue;
            knowledge.addKnowledge(stack);
        }
        knowledge.sync(player);
    }

    protected IKnowledgeProvider getKnowledgeProvider(@Nonnull EntityPlayer player) {
        IKnowledgeProvider knowledge = this.transmutationProxy.getKnowledgeProviderFor(player.func_110124_au());
        return knowledge;
    }

    protected IKnowledgeProvider getKnowledgeProvider(@Nonnull World world, @Nonnull UUID owner) {
        IKnowledgeProvider knowledge = this.transmutationProxy.getKnowledgeProviderFor(owner);
        return knowledge;
    }

    public List<ItemStack> getKnowledge(@Nonnull World world, @Nonnull UUID owner) {
        IKnowledgeProvider knowledge = this.transmutationProxy.getKnowledgeProviderFor(owner);
        return knowledge.getKnowledge();
    }
}

