/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.item.IItemConfig;
import com.mike_caron.equivalentintegrations.item.ModItems;
import com.mike_caron.equivalentintegrations.storage.EMCItemHandler;
import com.mike_caron.mikesmodslib.inventory.ItemInventory;
import com.mike_caron.mikesmodslib.inventory.PlayerItemInventory;
import com.mike_caron.mikesmodslib.item.ItemBase;
import com.mike_caron.mikesmodslib.util.ItemUtils;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConjurationAssembler
extends ItemBase
implements IItemConfig {
    public static final String id = "conjuration_assembler";
    public static int STACK_LIMIT = 1;
    public static final int NESTED_ITEM_TINT_DELTA = 1;
    private static final LoadingCache<ItemStack, Data> itemCache = CacheBuilder.newBuilder().softValues().expireAfterAccess(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ItemStack, Data>(){

        @Nonnull
        public Data load(@Nonnull ItemStack key) throws Exception {
            return ConjurationAssembler.getData(key);
        }
    });

    public ConjurationAssembler() {
        super(id);
        this.func_77625_d(1);
        this.func_77637_a(EquivalentIntegrationsMod.creativeTab);
        this.func_185043_a(new ResourceLocation("active"), (stack, worldIn, entityIn) -> {
            Data data = (Data)itemCache.getUnchecked((Object)stack);
            boolean isActive = data.playerUuid != null && !data.itemStack.func_190926_b();
            return isActive ? 1.0f : 0.0f;
        });
        this.func_185043_a(new ResourceLocation("color"), (stack, worldIn, entityIn) -> {
            Data data = (Data)itemCache.getUnchecked((Object)stack);
            return data.color;
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        UUID owner;
        String tip = I18n.func_135052_a((String)"item.conjuration_assembler.desc1", (Object[])new Object[0]);
        if (!tip.isEmpty()) {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + tip);
        }
        if ((owner = ConjurationAssembler.getPlayerUUID(stack)) == null) {
            tip = I18n.func_135052_a((String)"item.conjuration_assembler.bind_tip", (Object[])new Object[0]);
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + tip);
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        String base = super.func_77653_i(stack);
        Data held = (Data)itemCache.getUnchecked((Object)stack);
        if (!held.itemStack.func_190926_b()) {
            base = base + " (" + held.itemStack.func_82833_r() + ")";
        }
        return base;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Data data = (Data)itemCache.getUnchecked((Object)stack);
        if (hand != EnumHand.MAIN_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K && player.func_70093_af()) {
            if (!player.func_110124_au().equals(data.playerUuid)) {
                stack = ConjurationAssembler.withOwner(stack, player.func_110124_au());
                player.func_184611_a(hand, stack);
            }
            player.openGui((Object)EquivalentIntegrationsMod.instance, 3, world, player.field_71071_by.field_70461_c, 0, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            EMCItemHandler handler;
            ItemStack actualStack;
            ItemStack containerStack = player.func_184586_b(EnumHand.MAIN_HAND);
            Data data = (Data)itemCache.getUnchecked((Object)containerStack);
            if (data.playerUuid != null && !data.itemStack.func_190926_b() && !(actualStack = (handler = ConjurationAssembler.getItemHandler(data.playerUuid, worldIn, data.itemStack)).getStackInSlot(0).func_77946_l()).func_190926_b()) {
                ItemStack extractResult;
                if (actualStack.func_190916_E() > 64) {
                    actualStack.func_190920_e(64);
                }
                player.func_184611_a(hand, actualStack.func_77946_l());
                EnumActionResult result = actualStack.func_179546_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
                ItemStack newActualStack = player.func_184586_b(hand);
                player.func_184611_a(hand, containerStack);
                ItemStack delta = ConjurationAssembler.getDelta(actualStack, newActualStack);
                if (!delta.func_190926_b() && (extractResult = handler.extractItem(delta, false)).func_190926_b()) {
                    EquivalentIntegrationsMod.logger.warn("Just leaked {}", (Object)delta);
                }
            }
        }
        return EnumActionResult.PASS;
    }

    private static EMCItemHandler getItemHandler(UUID playerUuid, World worldIn, ItemStack filter) {
        EMCItemHandler handler = new EMCItemHandler(playerUuid, worldIn, true, true, filter);
        handler.setCanLearn(EMCItemHandler.EnumLearning.CANNOT);
        handler.setForbidDamaged(true);
        handler.setForbidNbt(true);
        handler.setEfficiencyThreshold(Integer.MAX_VALUE);
        return handler;
    }

    public static ItemStack getFilter(@Nonnull ItemStack container) {
        Data data = (Data)itemCache.getUnchecked((Object)container);
        return data.itemStack;
    }

    @Nullable
    private static UUID getPlayerUUID(@Nonnull ItemStack container) {
        Data data = (Data)itemCache.getUnchecked((Object)container);
        return data.playerUuid;
    }

    @Nonnull
    private static Data getData(@Nonnull ItemStack container) {
        UUID uuid = null;
        ItemStack stack = ItemStack.field_190927_a;
        int color = 9;
        if (!container.func_190926_b()) {
            NBTTagCompound compound = container.func_77978_p();
            if (compound != null && compound.func_74764_b("player")) {
                uuid = UUID.fromString(compound.func_74779_i("player"));
            }
            if (compound != null && compound.func_74764_b("color")) {
                color = compound.func_74762_e("color");
            }
            ItemInventory inv = new ItemInventory(container, 1);
            stack = inv.func_70301_a(0);
        }
        return new Data(uuid, stack, color);
    }

    private static ItemStack getDelta(@Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (before.func_190926_b()) {
            throw new IllegalArgumentException("before cannot be empty");
        }
        if (after.func_190926_b()) {
            return before;
        }
        if (!before.func_185136_b(after)) {
            throw new IllegalArgumentException("before doesn't match after");
        }
        return new ItemStack(before.func_77973_b(), before.func_190916_E() - after.func_190916_E(), before.func_77960_j(), before.func_77978_p());
    }

    @Nonnull
    public static ItemStack withOwner(@Nonnull UUID owner) {
        return ConjurationAssembler.withOwnerAndFilter(owner, ItemStack.field_190927_a, 9);
    }

    @Nonnull
    public static ItemStack withOwner(@Nonnull ItemStack original, @Nonnull UUID owner) {
        Data data = (Data)itemCache.getUnchecked((Object)original);
        return ConjurationAssembler.withOwnerAndFilter(owner, data.itemStack, data.color);
    }

    @Nonnull
    public static ItemStack withFilter(@Nonnull ItemStack original, @Nonnull ItemStack filter) {
        Data data = (Data)itemCache.getUnchecked((Object)original);
        return ConjurationAssembler.withOwnerAndFilter(data.playerUuid, filter, data.color);
    }

    @Nonnull
    public static ItemStack withOwnerAndFilter(@Nullable UUID owner, @Nonnull ItemStack filter, int color) {
        NBTTagCompound tag = new NBTTagCompound();
        if (owner != null) {
            tag.func_74778_a("player", owner.toString());
        }
        if (!filter.func_190926_b()) {
            tag.func_74782_a("inventory", (NBTBase)filter.serializeNBT());
        }
        tag.func_74768_a("color", color);
        ItemStack ret = new ItemStack((Item)ModItems.conjurationAssembler, 1);
        ret.func_77982_d(tag);
        ItemInventory inv = new ItemInventory(ret, 1);
        inv.func_70299_a(0, filter);
        return ret;
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent evt) {
        EntityPlayer player = evt.getEntityPlayer();
        ItemStack pickedStack = evt.getItem().func_92059_d();
        if (pickedStack.func_190926_b() || player == null) {
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            EMCItemHandler handler;
            ItemStack result;
            boolean isMatching;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != this) continue;
            Data data = (Data)itemCache.getUnchecked((Object)stack);
            if (data.itemStack.func_190926_b() || !(isMatching = data.itemStack.func_185136_b(pickedStack)) || (result = (handler = ConjurationAssembler.getItemHandler(data.playerUuid, evt.getItem().field_70170_p, data.itemStack)).insertItem(0, pickedStack, false)).func_190916_E() == pickedStack.func_190916_E()) continue;
            if (pickedStack.func_190916_E() > 0) {
                pickedStack.func_190920_e(0);
            }
            return;
        }
    }

    @Override
    public void onConfig(@Nonnull ItemStack stack, int discriminator, int payload) {
        NBTTagCompound compound = ItemUtils.getItemTag((ItemStack)stack);
        switch (discriminator) {
            case 1: {
                compound.func_74768_a("color", payload);
            }
        }
    }

    public static class Inventory
    extends PlayerItemInventory {
        public Inventory(EntityPlayer player) {
            super(player, 1);
        }

        public Inventory(EntityPlayer player, int inventorySlot) {
            super(player, 1, inventorySlot);
        }

        public int getCurrentColor() {
            NBTTagCompound compound = ItemUtils.getItemTag((ItemStack)this.containerStack);
            if (!compound.func_74764_b("color")) {
                return 9;
            }
            return compound.func_74762_e("color");
        }
    }

    private static final class Data {
        @Nullable
        public final UUID playerUuid;
        @Nonnull
        public final ItemStack itemStack;
        public final int color;

        public Data(@Nullable UUID playerUuid, @Nonnull ItemStack itemStack, @Nonnull int color) {
            this.playerUuid = playerUuid;
            this.itemStack = itemStack;
            this.color = color;
        }
    }
}

